/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.res.Configuration;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.util.Log;
import android.view.Display;
import android.view.KeyEvent;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.ValueCallback;
import android.widget.LinearLayout;
import java.util.HashMap;
import java.util.Locale;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.cordova.AuthenticationToken;
import org.apache.cordova.Config;
import org.apache.cordova.CordovaChromeClient;
import org.apache.cordova.CordovaInterface;
import org.apache.cordova.CordovaPlugin;
import org.apache.cordova.CordovaWebView;
import org.apache.cordova.CordovaWebViewClient;
import org.apache.cordova.IceCreamCordovaWebViewClient;
import org.apache.cordova.LOG;
import org.apache.cordova.LinearLayoutSoftKeyboardDetect;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CordovaActivity
extends Activity
implements CordovaInterface {
    public static String TAG = "CordovaActivity";
    protected CordovaWebView appView;
    protected CordovaWebViewClient webViewClient;
    protected LinearLayout root;
    protected boolean cancelLoadUrl = false;
    protected ProgressDialog spinnerDialog = null;
    private final ExecutorService threadPool = Executors.newCachedThreadPool();
    private static int ACTIVITY_STARTING = 0;
    private static int ACTIVITY_RUNNING = 1;
    private static int ACTIVITY_EXITING = 2;
    private int activityState = 0;
    protected CordovaPlugin activityResultCallback = null;
    protected boolean activityResultKeepRunning;
    private int backgroundColor = -16777216;
    protected int splashscreen = 0;
    protected int splashscreenTime = 3000;
    protected int loadUrlTimeoutValue = 20000;
    protected boolean keepRunning = true;
    private int lastRequestCode;
    private Object responseCode;
    private Intent lastIntent;
    private Object lastResponseCode;
    private String initCallbackClass;
    private Object LOG_TAG;
    protected Dialog splashDialog;

    public void setAuthenticationToken(AuthenticationToken authenticationToken, String host, String realm) {
        if (this.appView != null && this.appView.viewClient != null) {
            this.appView.viewClient.setAuthenticationToken(authenticationToken, host, realm);
        }
    }

    public AuthenticationToken removeAuthenticationToken(String host, String realm) {
        if (this.appView != null && this.appView.viewClient != null) {
            return this.appView.viewClient.removeAuthenticationToken(host, realm);
        }
        return null;
    }

    public AuthenticationToken getAuthenticationToken(String host, String realm) {
        if (this.appView != null && this.appView.viewClient != null) {
            return this.appView.viewClient.getAuthenticationToken(host, realm);
        }
        return null;
    }

    public void clearAuthenticationTokens() {
        if (this.appView != null && this.appView.viewClient != null) {
            this.appView.viewClient.clearAuthenticationTokens();
        }
    }

    public void onCreate(Bundle savedInstanceState) {
        Config.init(this);
        LOG.d(TAG, "CordovaActivity.onCreate()");
        super.onCreate(savedInstanceState);
        if (savedInstanceState != null) {
            this.initCallbackClass = savedInstanceState.getString("callbackClass");
        }
        if (!this.getBooleanProperty("ShowTitle", false)) {
            this.getWindow().requestFeature(1);
        }
        if (this.getBooleanProperty("SetFullscreen", false)) {
            Log.d((String)TAG, (String)"The SetFullscreen configuration is deprecated in favor of Fullscreen, and will be removed in a future version.");
            this.getWindow().setFlags(1024, 1024);
        } else {
            this.getWindow().setFlags(2048, 2048);
        }
        Display display = this.getWindowManager().getDefaultDisplay();
        int width = display.getWidth();
        int height = display.getHeight();
        this.root = new LinearLayoutSoftKeyboardDetect((Context)this, width, height);
        this.root.setOrientation(1);
        this.root.setBackgroundColor(this.backgroundColor);
        this.root.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1, 0.0f));
        this.setVolumeControlStream(3);
    }

    @Override
    public Activity getActivity() {
        return this;
    }

    protected CordovaWebView makeWebView() {
        return new CordovaWebView((Context)this);
    }

    protected CordovaWebViewClient makeWebViewClient(CordovaWebView webView) {
        if (Build.VERSION.SDK_INT < 11) {
            return new CordovaWebViewClient(this, webView);
        }
        return new IceCreamCordovaWebViewClient(this, webView);
    }

    protected CordovaChromeClient makeChromeClient(CordovaWebView webView) {
        return new CordovaChromeClient(this, webView);
    }

    public void init() {
        CordovaWebView webView = this.makeWebView();
        this.init(webView, this.makeWebViewClient(webView), this.makeChromeClient(webView));
    }

    @SuppressLint(value={"NewApi"})
    public void init(CordovaWebView webView, CordovaWebViewClient webViewClient, CordovaChromeClient webChromeClient) {
        LOG.d(TAG, "CordovaActivity.init()");
        this.appView = webView;
        this.appView.setId(100);
        this.appView.setWebViewClient(webViewClient);
        this.appView.setWebChromeClient(webChromeClient);
        webViewClient.setWebView(this.appView);
        webChromeClient.setWebView(this.appView);
        this.appView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1, 1.0f));
        if (this.getBooleanProperty("DisallowOverscroll", false) && Build.VERSION.SDK_INT >= 9) {
            this.appView.setOverScrollMode(2);
        }
        this.appView.setVisibility(4);
        this.root.addView((View)this.appView);
        this.setContentView((View)this.root);
        this.cancelLoadUrl = false;
    }

    public void loadUrl(String url) {
        if (this.appView == null) {
            this.init();
        }
        this.splashscreenTime = this.getIntegerProperty("SplashScreenDelay", this.splashscreenTime);
        if (this.splashscreenTime > 0) {
            this.splashscreen = this.getIntegerProperty("SplashScreen", 0);
            if (this.splashscreen != 0) {
                this.showSplashScreen(this.splashscreenTime);
            }
        }
        this.backgroundColor = this.getIntegerProperty("BackgroundColor", -16777216);
        this.root.setBackgroundColor(this.backgroundColor);
        this.keepRunning = this.getBooleanProperty("KeepRunning", true);
        if (this.appView.getParent() != null) {
            this.loadSpinner();
        }
        if (this.splashscreen != 0) {
            this.appView.loadUrl(url, this.splashscreenTime);
        } else {
            this.appView.loadUrl(url);
        }
    }

    public void loadUrl(String url, int time) {
        this.splashscreenTime = time;
        this.loadUrl(url);
    }

    void loadSpinner() {
        String loading = null;
        loading = this.appView == null || !this.appView.canGoBack() ? this.getStringProperty("LoadingDialog", null) : this.getStringProperty("LoadingPageDialog", null);
        if (loading != null) {
            String title = "";
            String message = "Loading Application...";
            if (loading.length() > 0) {
                int comma = loading.indexOf(44);
                if (comma > 0) {
                    title = loading.substring(0, comma);
                    message = loading.substring(comma + 1);
                } else {
                    title = "";
                    message = loading;
                }
            }
            this.spinnerStart(title, message);
        }
    }

    @Deprecated
    public void cancelLoadUrl() {
        this.cancelLoadUrl = true;
    }

    public void clearCache() {
        if (this.appView == null) {
            this.init();
        }
        this.appView.clearCache(true);
    }

    public void clearHistory() {
        this.appView.clearHistory();
    }

    public boolean backHistory() {
        if (this.appView != null) {
            return this.appView.backHistory();
        }
        return false;
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
    }

    public boolean getBooleanProperty(String name, boolean defaultValue) {
        Boolean p;
        Bundle bundle = this.getIntent().getExtras();
        if (bundle == null) {
            return defaultValue;
        }
        name = name.toLowerCase(Locale.getDefault());
        try {
            p = (Boolean)bundle.get(name);
        }
        catch (ClassCastException e) {
            String s = bundle.get(name).toString();
            p = "true".equals(s) ? Boolean.valueOf(true) : Boolean.valueOf(false);
        }
        if (p == null) {
            return defaultValue;
        }
        return p;
    }

    public int getIntegerProperty(String name, int defaultValue) {
        Integer p;
        Bundle bundle = this.getIntent().getExtras();
        if (bundle == null) {
            return defaultValue;
        }
        name = name.toLowerCase(Locale.getDefault());
        try {
            p = (Integer)bundle.get(name);
        }
        catch (ClassCastException e) {
            p = Integer.parseInt(bundle.get(name).toString());
        }
        if (p == null) {
            return defaultValue;
        }
        return p;
    }

    public String getStringProperty(String name, String defaultValue) {
        Bundle bundle = this.getIntent().getExtras();
        if (bundle == null) {
            return defaultValue;
        }
        String p = bundle.getString(name = name.toLowerCase(Locale.getDefault()));
        if (p == null) {
            return defaultValue;
        }
        return p;
    }

    public double getDoubleProperty(String name, double defaultValue) {
        Double p;
        Bundle bundle = this.getIntent().getExtras();
        if (bundle == null) {
            return defaultValue;
        }
        name = name.toLowerCase(Locale.getDefault());
        try {
            p = (Double)bundle.get(name);
        }
        catch (ClassCastException e) {
            p = Double.parseDouble(bundle.get(name).toString());
        }
        if (p == null) {
            return defaultValue;
        }
        return p;
    }

    @Deprecated
    public void setBooleanProperty(String name, boolean value) {
        Log.d((String)TAG, (String)"Setting boolean properties in CordovaActivity will be deprecated in 3.0 on July 2013, please use config.xml");
        this.getIntent().putExtra(name.toLowerCase(), value);
    }

    @Deprecated
    public void setIntegerProperty(String name, int value) {
        Log.d((String)TAG, (String)"Setting integer properties in CordovaActivity will be deprecated in 3.0 on July 2013, please use config.xml");
        this.getIntent().putExtra(name.toLowerCase(), value);
    }

    @Deprecated
    public void setStringProperty(String name, String value) {
        Log.d((String)TAG, (String)"Setting string properties in CordovaActivity will be deprecated in 3.0 on July 2013, please use config.xml");
        this.getIntent().putExtra(name.toLowerCase(), value);
    }

    @Deprecated
    public void setDoubleProperty(String name, double value) {
        Log.d((String)TAG, (String)"Setting double properties in CordovaActivity will be deprecated in 3.0 on July 2013, please use config.xml");
        this.getIntent().putExtra(name.toLowerCase(), value);
    }

    protected void onPause() {
        super.onPause();
        LOG.d(TAG, "Paused the application!");
        if (this.activityState == ACTIVITY_EXITING) {
            return;
        }
        if (this.appView == null) {
            return;
        }
        this.appView.handlePause(this.keepRunning);
        this.removeSplashScreen();
    }

    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        if (this.appView != null) {
            this.appView.onNewIntent(intent);
        }
    }

    protected void onResume() {
        super.onResume();
        Config.init(this);
        LOG.d(TAG, "Resuming the App");
        String errorUrl = this.getStringProperty("ErrorUrl", null);
        LOG.d(TAG, "CB-3064: The errorUrl is " + errorUrl);
        if (this.activityState == ACTIVITY_STARTING) {
            this.activityState = ACTIVITY_RUNNING;
            return;
        }
        if (this.appView == null) {
            return;
        }
        this.appView.handleResume(this.keepRunning, this.activityResultKeepRunning);
        if ((!this.keepRunning || this.activityResultKeepRunning) && this.activityResultKeepRunning) {
            this.keepRunning = this.activityResultKeepRunning;
            this.activityResultKeepRunning = false;
        }
    }

    public void onDestroy() {
        LOG.d(TAG, "CordovaActivity.onDestroy()");
        super.onDestroy();
        this.removeSplashScreen();
        if (this.appView != null) {
            this.appView.handleDestroy();
        } else {
            this.activityState = ACTIVITY_EXITING;
        }
    }

    public void postMessage(String id, Object data) {
        if (this.appView != null) {
            this.appView.postMessage(id, data);
        }
    }

    @Deprecated
    public void addService(String serviceType, String className) {
        if (this.appView != null && this.appView.pluginManager != null) {
            this.appView.pluginManager.addService(serviceType, className);
        }
    }

    public void sendJavascript(String statement) {
        if (this.appView != null) {
            this.appView.jsMessageQueue.addJavaScript(statement);
        }
    }

    public void spinnerStart(String title, String message) {
        if (this.spinnerDialog != null) {
            this.spinnerDialog.dismiss();
            this.spinnerDialog = null;
        }
        final CordovaActivity me = this;
        this.spinnerDialog = ProgressDialog.show((Context)this, (CharSequence)title, (CharSequence)message, (boolean)true, (boolean)true, (DialogInterface.OnCancelListener)new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialog) {
                me.spinnerDialog = null;
            }
        });
    }

    public void spinnerStop() {
        if (this.spinnerDialog != null && this.spinnerDialog.isShowing()) {
            this.spinnerDialog.dismiss();
            this.spinnerDialog = null;
        }
    }

    public void endActivity() {
        this.activityState = ACTIVITY_EXITING;
        super.finish();
    }

    @Override
    public void startActivityForResult(CordovaPlugin command, Intent intent, int requestCode) {
        this.activityResultCallback = command;
        this.activityResultKeepRunning = this.keepRunning;
        if (command != null) {
            this.keepRunning = false;
        }
        super.startActivityForResult(intent, requestCode);
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent intent) {
        CordovaPlugin callback;
        LOG.d(TAG, "Incoming Result");
        super.onActivityResult(requestCode, resultCode, intent);
        Log.d((String)TAG, (String)("Request code = " + requestCode));
        if (this.appView != null && requestCode == 5173) {
            ValueCallback<Uri> mUploadMessage = this.appView.getWebChromeClient().getValueCallback();
            Log.d((String)TAG, (String)"did we get here?");
            if (null == mUploadMessage) {
                return;
            }
            Uri result = intent == null || resultCode != -1 ? null : intent.getData();
            Log.d((String)TAG, (String)("result = " + result));
            mUploadMessage.onReceiveValue((Object)result);
            mUploadMessage = null;
        }
        if ((callback = this.activityResultCallback) == null && this.initCallbackClass != null) {
            callback = this.activityResultCallback = this.appView.pluginManager.getPlugin(this.initCallbackClass);
        }
        if (callback != null) {
            LOG.d(TAG, "We have a callback to send this result to");
            callback.onActivityResult(requestCode, resultCode, intent);
        }
    }

    @Override
    public void setActivityResultCallback(CordovaPlugin plugin) {
        this.activityResultCallback = plugin;
    }

    public void onReceivedError(int errorCode, final String description, final String failingUrl) {
        final CordovaActivity me = this;
        final String errorUrl = me.getStringProperty("errorUrl", null);
        if (errorUrl != null && (errorUrl.startsWith("file://") || Config.isUrlWhiteListed(errorUrl)) && !failingUrl.equals(errorUrl)) {
            me.runOnUiThread(new Runnable(){

                public void run() {
                    me.spinnerStop();
                    me.appView.showWebPage(errorUrl, false, true, null);
                }
            });
        } else {
            final boolean exit = errorCode != -2;
            me.runOnUiThread(new Runnable(){

                public void run() {
                    if (exit) {
                        me.appView.setVisibility(8);
                        me.displayError("Application Error", description + " (" + failingUrl + ")", "OK", exit);
                    }
                }
            });
        }
    }

    public void displayError(final String title, final String message, final String button, final boolean exit) {
        final CordovaActivity me = this;
        me.runOnUiThread(new Runnable(){

            public void run() {
                try {
                    AlertDialog.Builder dlg = new AlertDialog.Builder((Context)me);
                    dlg.setMessage((CharSequence)message);
                    dlg.setTitle((CharSequence)title);
                    dlg.setCancelable(false);
                    dlg.setPositiveButton((CharSequence)button, new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialog, int which) {
                            dialog.dismiss();
                            if (exit) {
                                me.endActivity();
                            }
                        }
                    });
                    dlg.create();
                    dlg.show();
                }
                catch (Exception e) {
                    CordovaActivity.this.finish();
                }
            }
        });
    }

    public boolean isUrlWhiteListed(String url) {
        return Config.isUrlWhiteListed(url);
    }

    public boolean onCreateOptionsMenu(Menu menu) {
        this.postMessage("onCreateOptionsMenu", menu);
        return super.onCreateOptionsMenu(menu);
    }

    public boolean onPrepareOptionsMenu(Menu menu) {
        this.postMessage("onPrepareOptionsMenu", menu);
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        this.postMessage("onOptionsItemSelected", item);
        return true;
    }

    @Deprecated
    public Context getContext() {
        LOG.d(TAG, "This will be deprecated December 2012");
        return this;
    }

    public void showWebPage(String url, boolean openExternal, boolean clearHistory, HashMap<String, Object> params) {
        if (this.appView != null) {
            this.appView.showWebPage(url, openExternal, clearHistory, params);
        }
    }

    public void removeSplashScreen() {
        if (this.splashDialog != null && this.splashDialog.isShowing()) {
            this.splashDialog.dismiss();
            this.splashDialog = null;
        }
    }

    protected void showSplashScreen(final int time) {
        final CordovaActivity that = this;
        Runnable runnable = new Runnable(){

            public void run() {
                Display display = CordovaActivity.this.getWindowManager().getDefaultDisplay();
                LinearLayout root = new LinearLayout((Context)that.getActivity());
                root.setMinimumHeight(display.getHeight());
                root.setMinimumWidth(display.getWidth());
                root.setOrientation(1);
                root.setBackgroundColor(that.getIntegerProperty("backgroundColor", -16777216));
                root.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1, 0.0f));
                root.setBackgroundResource(that.splashscreen);
                CordovaActivity.this.splashDialog = new Dialog((Context)that, 0x1030010);
                if ((CordovaActivity.this.getWindow().getAttributes().flags & 0x400) == 1024) {
                    CordovaActivity.this.splashDialog.getWindow().setFlags(1024, 1024);
                }
                CordovaActivity.this.splashDialog.setContentView((View)root);
                CordovaActivity.this.splashDialog.setCancelable(false);
                CordovaActivity.this.splashDialog.show();
                Handler handler = new Handler();
                handler.postDelayed(new Runnable(){

                    public void run() {
                        CordovaActivity.this.removeSplashScreen();
                    }
                }, (long)time);
            }
        };
        this.runOnUiThread(runnable);
    }

    public boolean onKeyUp(int keyCode, KeyEvent event) {
        if (!(this.appView == null || !this.appView.isCustomViewShowing() && this.appView.getFocusedChild() == null || keyCode != 4 && keyCode != 82)) {
            return this.appView.onKeyUp(keyCode, event);
        }
        return super.onKeyUp(keyCode, event);
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (this.appView != null && this.appView.getFocusedChild() != null && (keyCode == 4 || keyCode == 82)) {
            return this.appView.onKeyDown(keyCode, event);
        }
        return super.onKeyDown(keyCode, event);
    }

    @Override
    public Object onMessage(String id, Object data) {
        if (!"onScrollChanged".equals(id)) {
            LOG.d(TAG, "onMessage(" + id + "," + data + ")");
        }
        if ("splashscreen".equals(id)) {
            if ("hide".equals(data.toString())) {
                this.removeSplashScreen();
            } else if (this.splashDialog == null || !this.splashDialog.isShowing()) {
                this.splashscreen = this.getIntegerProperty("SplashScreen", 0);
                this.showSplashScreen(this.splashscreenTime);
            }
        } else if ("spinner".equals(id)) {
            if ("stop".equals(data.toString())) {
                this.spinnerStop();
                this.appView.setVisibility(0);
            }
        } else if ("onReceivedError".equals(id)) {
            JSONObject d = (JSONObject)data;
            try {
                this.onReceivedError(d.getInt("errorCode"), d.getString("description"), d.getString("url"));
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        } else if ("exit".equals(id)) {
            this.endActivity();
        }
        return null;
    }

    @Override
    public ExecutorService getThreadPool() {
        return this.threadPool;
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        if (this.activityResultCallback != null) {
            String cClass = this.activityResultCallback.getClass().getName();
            outState.putString("callbackClass", cClass);
        }
    }
}

