/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.vending.expansion.downloader;

import android.content.Context;
import android.os.Environment;
import android.os.StatFs;
import android.os.SystemClock;
import android.util.Log;
import com.android.vending.expansion.downloader.R;
import com.google.android.vending.expansion.downloader.Constants;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Random;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Helpers {
    public static Random sRandom = new Random(SystemClock.uptimeMillis());
    private static final Pattern CONTENT_DISPOSITION_PATTERN = Pattern.compile("attachment;\\s*filename\\s*=\\s*\"([^\"]*)\"");

    private Helpers() {
    }

    static String parseContentDisposition(String contentDisposition) {
        try {
            Matcher m = CONTENT_DISPOSITION_PATTERN.matcher(contentDisposition);
            if (m.find()) {
                return m.group(1);
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        return null;
    }

    public static File getFilesystemRoot(String path) {
        File cache = Environment.getDownloadCacheDirectory();
        if (path.startsWith(cache.getPath())) {
            return cache;
        }
        File external = Environment.getExternalStorageDirectory();
        if (path.startsWith(external.getPath())) {
            return external;
        }
        throw new IllegalArgumentException("Cannot determine filesystem root for " + path);
    }

    public static boolean isExternalMediaMounted() {
        return Environment.getExternalStorageState().equals("mounted");
    }

    public static long getAvailableBytes(File root) {
        StatFs stat = new StatFs(root.getPath());
        long availableBlocks = (long)stat.getAvailableBlocks() - 4L;
        return (long)stat.getBlockSize() * availableBlocks;
    }

    public static boolean isFilenameValid(String filename) {
        return (filename = filename.replaceFirst("/+", "/")).startsWith(Environment.getDownloadCacheDirectory().toString()) || filename.startsWith(Environment.getExternalStorageDirectory().toString());
    }

    static void deleteFile(String path) {
        try {
            File file = new File(path);
            file.delete();
        }
        catch (Exception e) {
            Log.w((String)"LVLDL", (String)("file: '" + path + "' couldn't be deleted"), (Throwable)e);
        }
    }

    public static String getDownloadProgressString(long overallProgress, long overallTotal) {
        if (overallTotal == 0L) {
            return "";
        }
        return String.valueOf(String.format("%.2f", Float.valueOf((float)overallProgress / 1048576.0f))) + "MB /" + String.format("%.2f", Float.valueOf((float)overallTotal / 1048576.0f)) + "MB";
    }

    public static String getDownloadProgressStringNotification(long overallProgress, long overallTotal) {
        if (overallTotal == 0L) {
            return "";
        }
        return String.valueOf(Helpers.getDownloadProgressString(overallProgress, overallTotal)) + " (" + Helpers.getDownloadProgressPercent(overallProgress, overallTotal) + ")";
    }

    public static String getDownloadProgressPercent(long overallProgress, long overallTotal) {
        if (overallTotal == 0L) {
            return "";
        }
        return String.valueOf(Long.toString(overallProgress * 100L / overallTotal)) + "%";
    }

    public static String getSpeedString(float bytesPerMillisecond) {
        return String.format("%.2f", Float.valueOf(bytesPerMillisecond * 1000.0f / 1024.0f));
    }

    public static String getTimeRemaining(long durationInMilliseconds) {
        SimpleDateFormat sdf = durationInMilliseconds > 3600000L ? new SimpleDateFormat("HH:mm", Locale.getDefault()) : new SimpleDateFormat("mm:ss", Locale.getDefault());
        return sdf.format(new Date(durationInMilliseconds - (long)TimeZone.getDefault().getRawOffset()));
    }

    public static String getExpansionAPKFileName(Context c, boolean mainFile, int versionCode) {
        return String.valueOf(mainFile ? "main." : "patch.") + versionCode + "." + c.getPackageName() + ".obb";
    }

    public static String generateSaveFileName(Context c, String fileName) {
        String path = String.valueOf(Helpers.getSaveFilePath(c)) + File.separator + fileName;
        return path;
    }

    public static String getSaveFilePath(Context c) {
        File root = Environment.getExternalStorageDirectory();
        String path = String.valueOf(root.toString()) + Constants.EXP_PATH + c.getPackageName();
        return path;
    }

    public static boolean doesFileExist(Context c, String fileName, long fileSize, boolean deleteFileOnMismatch) {
        File fileForNewFile = new File(Helpers.generateSaveFileName(c, fileName));
        if (fileForNewFile.exists()) {
            if (fileForNewFile.length() == fileSize) {
                return true;
            }
            if (deleteFileOnMismatch) {
                fileForNewFile.delete();
            }
        }
        return false;
    }

    public static int getDownloaderStringResourceIDFromState(int state) {
        switch (state) {
            case 1: {
                return R.string.state_idle;
            }
            case 2: {
                return R.string.state_fetching_url;
            }
            case 3: {
                return R.string.state_connecting;
            }
            case 4: {
                return R.string.state_downloading;
            }
            case 5: {
                return R.string.state_completed;
            }
            case 6: {
                return R.string.state_paused_network_unavailable;
            }
            case 7: {
                return R.string.state_paused_by_request;
            }
            case 8: {
                return R.string.state_paused_wifi_disabled;
            }
            case 9: {
                return R.string.state_paused_wifi_unavailable;
            }
            case 10: {
                return R.string.state_paused_wifi_disabled;
            }
            case 11: {
                return R.string.state_paused_wifi_unavailable;
            }
            case 12: {
                return R.string.state_paused_roaming;
            }
            case 13: {
                return R.string.state_paused_network_setup_failure;
            }
            case 14: {
                return R.string.state_paused_sdcard_unavailable;
            }
            case 15: {
                return R.string.state_failed_unlicensed;
            }
            case 16: {
                return R.string.state_failed_fetching_url;
            }
            case 17: {
                return R.string.state_failed_sdcard_full;
            }
            case 18: {
                return R.string.state_failed_cancelled;
            }
        }
        return R.string.state_unknown;
    }
}

