/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.vending.expansion.downloader.impl;

import android.content.ContentResolver;
import android.content.Context;
import android.net.SSLCertificateSocketFactory;
import android.os.Looper;
import android.util.Log;
import com.google.android.vending.expansion.downloader.impl.HttpDateTime;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.params.HttpClientParams;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.RequestWrapper;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.BasicHttpProcessor;
import org.apache.http.protocol.HttpContext;

public final class AndroidHttpClient
implements HttpClient {
    static Class<?> sSslSessionCacheClass;
    public static long DEFAULT_SYNC_MIN_GZIP_BYTES;
    private static final int SOCKET_OPERATION_TIMEOUT = 60000;
    private static final String TAG = "AndroidHttpClient";
    private static final HttpRequestInterceptor sThreadCheckInterceptor;
    private final HttpClient delegate;
    private RuntimeException mLeakedException = new IllegalStateException("AndroidHttpClient created and never closed");
    private volatile LoggingConfiguration curlConfiguration;

    static {
        try {
            sSslSessionCacheClass = Class.forName("android.net.SSLSessionCache");
        }
        catch (Exception exception) {
            // empty catch block
        }
        DEFAULT_SYNC_MIN_GZIP_BYTES = 256L;
        sThreadCheckInterceptor = new HttpRequestInterceptor(){

            public void process(HttpRequest request, HttpContext context) {
                if (Looper.myLooper() != null && Looper.myLooper() == Looper.getMainLooper()) {
                    throw new RuntimeException("This thread forbids HTTP requests");
                }
            }
        };
    }

    public static AndroidHttpClient newInstance(String userAgent, Context context) {
        BasicHttpParams params = new BasicHttpParams();
        HttpConnectionParams.setStaleCheckingEnabled((HttpParams)params, (boolean)false);
        HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)60000);
        HttpConnectionParams.setSoTimeout((HttpParams)params, (int)60000);
        HttpConnectionParams.setSocketBufferSize((HttpParams)params, (int)8192);
        HttpClientParams.setRedirecting((HttpParams)params, (boolean)false);
        Object sessionCache = null;
        if (context != null && sSslSessionCacheClass != null) {
            try {
                Constructor<?> ct = sSslSessionCacheClass.getConstructor(Context.class);
                sessionCache = ct.newInstance(context);
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        HttpProtocolParams.setUserAgent((HttpParams)params, (String)userAgent);
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        schemeRegistry.register(new Scheme("http", (SocketFactory)PlainSocketFactory.getSocketFactory(), 80));
        SSLSocketFactory sslCertificateSocketFactory = null;
        if (sessionCache != null) {
            try {
                Method getHttpSocketFactoryMethod = SSLCertificateSocketFactory.class.getDeclaredMethod("getHttpSocketFactory", Integer.TYPE, sSslSessionCacheClass);
                sslCertificateSocketFactory = (SocketFactory)getHttpSocketFactoryMethod.invoke(null, 60000, sessionCache);
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        if (sslCertificateSocketFactory == null) {
            sslCertificateSocketFactory = SSLSocketFactory.getSocketFactory();
        }
        schemeRegistry.register(new Scheme("https", (SocketFactory)sslCertificateSocketFactory, 443));
        ThreadSafeClientConnManager manager = new ThreadSafeClientConnManager((HttpParams)params, schemeRegistry);
        return new AndroidHttpClient((ClientConnectionManager)manager, (HttpParams)params);
    }

    public static AndroidHttpClient newInstance(String userAgent) {
        return AndroidHttpClient.newInstance(userAgent, null);
    }

    private AndroidHttpClient(ClientConnectionManager ccm, HttpParams params) {
        this.delegate = new DefaultHttpClient(ccm, params){

            protected BasicHttpProcessor createHttpProcessor() {
                BasicHttpProcessor processor = super.createHttpProcessor();
                processor.addRequestInterceptor(sThreadCheckInterceptor);
                processor.addRequestInterceptor((HttpRequestInterceptor)new CurlLogger());
                return processor;
            }

            protected HttpContext createHttpContext() {
                BasicHttpContext context = new BasicHttpContext();
                context.setAttribute("http.authscheme-registry", (Object)this.getAuthSchemes());
                context.setAttribute("http.cookiespec-registry", (Object)this.getCookieSpecs());
                context.setAttribute("http.auth.credentials-provider", (Object)this.getCredentialsProvider());
                return context;
            }
        };
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.mLeakedException != null) {
            Log.e((String)TAG, (String)"Leak found", (Throwable)this.mLeakedException);
            this.mLeakedException = null;
        }
    }

    public static void modifyRequestToAcceptGzipResponse(HttpRequest request) {
        request.addHeader("Accept-Encoding", "gzip");
    }

    public static InputStream getUngzippedContent(HttpEntity entity) throws IOException {
        InputStream responseStream = entity.getContent();
        if (responseStream == null) {
            return responseStream;
        }
        Header header = entity.getContentEncoding();
        if (header == null) {
            return responseStream;
        }
        String contentEncoding = header.getValue();
        if (contentEncoding == null) {
            return responseStream;
        }
        if (contentEncoding.contains("gzip")) {
            responseStream = new GZIPInputStream(responseStream);
        }
        return responseStream;
    }

    public void close() {
        if (this.mLeakedException != null) {
            this.getConnectionManager().shutdown();
            this.mLeakedException = null;
        }
    }

    public HttpParams getParams() {
        return this.delegate.getParams();
    }

    public ClientConnectionManager getConnectionManager() {
        return this.delegate.getConnectionManager();
    }

    public HttpResponse execute(HttpUriRequest request) throws IOException {
        return this.delegate.execute(request);
    }

    public HttpResponse execute(HttpUriRequest request, HttpContext context) throws IOException {
        return this.delegate.execute(request, context);
    }

    public HttpResponse execute(HttpHost target, HttpRequest request) throws IOException {
        return this.delegate.execute(target, request);
    }

    public HttpResponse execute(HttpHost target, HttpRequest request, HttpContext context) throws IOException {
        return this.delegate.execute(target, request, context);
    }

    public <T> T execute(HttpUriRequest request, ResponseHandler<? extends T> responseHandler) throws IOException, ClientProtocolException {
        return (T)this.delegate.execute(request, responseHandler);
    }

    public <T> T execute(HttpUriRequest request, ResponseHandler<? extends T> responseHandler, HttpContext context) throws IOException, ClientProtocolException {
        return (T)this.delegate.execute(request, responseHandler, context);
    }

    public <T> T execute(HttpHost target, HttpRequest request, ResponseHandler<? extends T> responseHandler) throws IOException, ClientProtocolException {
        return (T)this.delegate.execute(target, request, responseHandler);
    }

    public <T> T execute(HttpHost target, HttpRequest request, ResponseHandler<? extends T> responseHandler, HttpContext context) throws IOException, ClientProtocolException {
        return (T)this.delegate.execute(target, request, responseHandler, context);
    }

    public static AbstractHttpEntity getCompressedEntity(byte[] data, ContentResolver resolver) throws IOException {
        ByteArrayEntity entity;
        if ((long)data.length < AndroidHttpClient.getMinGzipSize(resolver)) {
            entity = new ByteArrayEntity(data);
        } else {
            ByteArrayOutputStream arr = new ByteArrayOutputStream();
            GZIPOutputStream zipper = new GZIPOutputStream(arr);
            ((OutputStream)zipper).write(data);
            ((OutputStream)zipper).close();
            entity = new ByteArrayEntity(arr.toByteArray());
            entity.setContentEncoding("gzip");
        }
        return entity;
    }

    public static long getMinGzipSize(ContentResolver resolver) {
        return DEFAULT_SYNC_MIN_GZIP_BYTES;
    }

    public void enableCurlLogging(String name, int level) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (level < 2 || level > 7) {
            throw new IllegalArgumentException("Level is out of range [2..7]");
        }
        this.curlConfiguration = new LoggingConfiguration(name, level);
    }

    public void disableCurlLogging() {
        this.curlConfiguration = null;
    }

    private static String toCurl(HttpUriRequest request, boolean logAuthToken) throws IOException {
        HttpEntityEnclosingRequest entityRequest;
        HttpEntity entity;
        HttpRequest original;
        StringBuilder builder = new StringBuilder();
        builder.append("curl ");
        Header[] headerArray = request.getAllHeaders();
        int n = headerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Header header = headerArray[n2];
            if (logAuthToken || !header.getName().equals("Authorization") && !header.getName().equals("Cookie")) {
                builder.append("--header \"");
                builder.append(header.toString().trim());
                builder.append("\" ");
            }
            ++n2;
        }
        URI uri = request.getURI();
        if (request instanceof RequestWrapper && (original = ((RequestWrapper)request).getOriginal()) instanceof HttpUriRequest) {
            uri = ((HttpUriRequest)original).getURI();
        }
        builder.append("\"");
        builder.append(uri);
        builder.append("\"");
        if (request instanceof HttpEntityEnclosingRequest && (entity = (entityRequest = (HttpEntityEnclosingRequest)request).getEntity()) != null && entity.isRepeatable()) {
            if (entity.getContentLength() < 1024L) {
                ByteArrayOutputStream stream = new ByteArrayOutputStream();
                entity.writeTo((OutputStream)stream);
                String entityString = stream.toString();
                builder.append(" --data-ascii \"").append(entityString).append("\"");
            } else {
                builder.append(" [TOO MUCH DATA TO INCLUDE]");
            }
        }
        return builder.toString();
    }

    public static long parseDate(String dateString) {
        return HttpDateTime.parse(dateString);
    }

    private class CurlLogger
    implements HttpRequestInterceptor {
        private CurlLogger() {
        }

        public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
            LoggingConfiguration configuration = AndroidHttpClient.this.curlConfiguration;
            if (configuration != null && configuration.isLoggable() && request instanceof HttpUriRequest) {
                configuration.println(AndroidHttpClient.toCurl((HttpUriRequest)request, false));
            }
        }
    }

    private static class LoggingConfiguration {
        private final String tag;
        private final int level;

        private LoggingConfiguration(String tag, int level) {
            this.tag = tag;
            this.level = level;
        }

        private boolean isLoggable() {
            return Log.isLoggable((String)this.tag, (int)this.level);
        }

        private void println(String message) {
            Log.println((int)this.level, (String)this.tag, (String)message);
        }
    }
}

