/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.vending.expansion.downloader.impl;

import android.util.Log;
import com.google.android.vending.expansion.downloader.Helpers;

public class DownloadInfo {
    public String mUri;
    public final int mIndex;
    public final String mFileName;
    public String mETag;
    public long mTotalBytes;
    public long mCurrentBytes;
    public long mLastMod;
    public int mStatus;
    public int mControl;
    public int mNumFailed;
    public int mRetryAfter;
    public int mRedirectCount;
    boolean mInitialized;
    public int mFuzz = Helpers.sRandom.nextInt(1001);

    public DownloadInfo(int index, String fileName, String pkg) {
        this.mFileName = fileName;
        this.mIndex = index;
    }

    public void resetDownload() {
        this.mCurrentBytes = 0L;
        this.mETag = "";
        this.mLastMod = 0L;
        this.mStatus = 0;
        this.mControl = 0;
        this.mNumFailed = 0;
        this.mRetryAfter = 0;
        this.mRedirectCount = 0;
    }

    public long restartTime(long now) {
        if (this.mNumFailed == 0) {
            return now;
        }
        if (this.mRetryAfter > 0) {
            return this.mLastMod + (long)this.mRetryAfter;
        }
        return this.mLastMod + (long)(30 * (1000 + this.mFuzz) * (1 << this.mNumFailed - 1));
    }

    public void logVerboseInfo() {
        Log.v((String)"LVLDL", (String)"Service adding new entry");
        Log.v((String)"LVLDL", (String)("FILENAME: " + this.mFileName));
        Log.v((String)"LVLDL", (String)("URI     : " + this.mUri));
        Log.v((String)"LVLDL", (String)("FILENAME: " + this.mFileName));
        Log.v((String)"LVLDL", (String)("CONTROL : " + this.mControl));
        Log.v((String)"LVLDL", (String)("STATUS  : " + this.mStatus));
        Log.v((String)"LVLDL", (String)("FAILED_C: " + this.mNumFailed));
        Log.v((String)"LVLDL", (String)("RETRY_AF: " + this.mRetryAfter));
        Log.v((String)"LVLDL", (String)("REDIRECT: " + this.mRedirectCount));
        Log.v((String)"LVLDL", (String)("LAST_MOD: " + this.mLastMod));
        Log.v((String)"LVLDL", (String)("TOTAL   : " + this.mTotalBytes));
        Log.v((String)"LVLDL", (String)("CURRENT : " + this.mCurrentBytes));
        Log.v((String)"LVLDL", (String)("ETAG    : " + this.mETag));
    }
}

