/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.vending.expansion.downloader.impl;

import android.app.Notification;
import android.app.PendingIntent;
import android.content.Context;
import android.os.Build;
import android.widget.RemoteViews;
import com.android.vending.expansion.downloader.R;
import com.google.android.vending.expansion.downloader.Helpers;
import com.google.android.vending.expansion.downloader.impl.DownloadNotification;

public class V3CustomNotification
implements DownloadNotification.ICustomNotification {
    CharSequence mTitle;
    CharSequence mTicker;
    int mIcon;
    long mTotalBytes = -1L;
    long mCurrentBytes = -1L;
    long mTimeRemaining;
    PendingIntent mPendingIntent;
    Notification mNotification = new Notification();

    @Override
    public void setIcon(int icon) {
        this.mIcon = icon;
    }

    @Override
    public void setTitle(CharSequence title) {
        this.mTitle = title;
    }

    @Override
    public void setTotalBytes(long totalBytes) {
        this.mTotalBytes = totalBytes;
    }

    @Override
    public void setCurrentBytes(long currentBytes) {
        this.mCurrentBytes = currentBytes;
    }

    @Override
    public Notification updateNotification(Context c) {
        Notification n = this.mNotification;
        n.icon = this.mIcon;
        n.flags |= 2;
        if (Build.VERSION.SDK_INT > 10) {
            n.flags |= 8;
        }
        RemoteViews expandedView = new RemoteViews(c.getPackageName(), R.layout.status_bar_ongoing_event_progress_bar);
        expandedView.setTextViewText(R.id.title, this.mTitle);
        expandedView.setViewVisibility(R.id.description, 0);
        expandedView.setTextViewText(R.id.description, (CharSequence)Helpers.getDownloadProgressString(this.mCurrentBytes, this.mTotalBytes));
        expandedView.setViewVisibility(R.id.progress_bar_frame, 0);
        expandedView.setProgressBar(R.id.progress_bar, (int)(this.mTotalBytes >> 8), (int)(this.mCurrentBytes >> 8), this.mTotalBytes <= 0L);
        expandedView.setViewVisibility(R.id.time_remaining, 0);
        expandedView.setTextViewText(R.id.time_remaining, (CharSequence)c.getString(R.string.time_remaining_notification, new Object[]{Helpers.getTimeRemaining(this.mTimeRemaining)}));
        expandedView.setTextViewText(R.id.progress_text, (CharSequence)Helpers.getDownloadProgressPercent(this.mCurrentBytes, this.mTotalBytes));
        expandedView.setImageViewResource(R.id.appIcon, this.mIcon);
        n.contentView = expandedView;
        n.contentIntent = this.mPendingIntent;
        return n;
    }

    @Override
    public void setPendingIntent(PendingIntent contentIntent) {
        this.mPendingIntent = contentIntent;
    }

    @Override
    public void setTicker(CharSequence ticker) {
        this.mTicker = ticker;
    }

    @Override
    public void setTimeRemaining(long timeRemaining) {
        this.mTimeRemaining = timeRemaining;
    }
}

