/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.vending.licensing;

import com.google.android.vending.licensing.Obfuscator;
import com.google.android.vending.licensing.ValidationException;
import com.google.android.vending.licensing.util.Base64;
import com.google.android.vending.licensing.util.Base64DecoderException;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.Key;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

public class AESObfuscator
implements Obfuscator {
    private static final String UTF8 = "UTF-8";
    private static final String KEYGEN_ALGORITHM = "PBEWITHSHAAND256BITAES-CBC-BC";
    private static final String CIPHER_ALGORITHM = "AES/CBC/PKCS5Padding";
    private static final byte[] IV;
    private static final String header = "com.android.vending.licensing.AESObfuscator-1|";
    private Cipher mEncryptor;
    private Cipher mDecryptor;

    static {
        byte[] byArray = new byte[16];
        byArray[0] = 16;
        byArray[1] = 74;
        byArray[2] = 71;
        byArray[3] = -80;
        byArray[4] = 32;
        byArray[5] = 101;
        byArray[6] = -47;
        byArray[7] = 72;
        byArray[8] = 117;
        byArray[9] = -14;
        byArray[11] = -29;
        byArray[12] = 70;
        byArray[13] = 65;
        byArray[14] = -12;
        byArray[15] = 74;
        IV = byArray;
    }

    public AESObfuscator(byte[] salt, String applicationId, String deviceId) {
        try {
            SecretKeyFactory factory = SecretKeyFactory.getInstance(KEYGEN_ALGORITHM);
            PBEKeySpec keySpec = new PBEKeySpec((String.valueOf(applicationId) + deviceId).toCharArray(), salt, 1024, 256);
            SecretKey tmp = factory.generateSecret(keySpec);
            SecretKeySpec secret = new SecretKeySpec(tmp.getEncoded(), "AES");
            this.mEncryptor = Cipher.getInstance(CIPHER_ALGORITHM);
            this.mEncryptor.init(1, (Key)secret, new IvParameterSpec(IV));
            this.mDecryptor = Cipher.getInstance(CIPHER_ALGORITHM);
            this.mDecryptor.init(2, (Key)secret, new IvParameterSpec(IV));
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException("Invalid environment", e);
        }
    }

    @Override
    public String obfuscate(String original, String key) {
        if (original == null) {
            return null;
        }
        try {
            return Base64.encode(this.mEncryptor.doFinal((header + key + original).getBytes(UTF8)));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Invalid environment", e);
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException("Invalid environment", e);
        }
    }

    @Override
    public String unobfuscate(String obfuscated, String key) throws ValidationException {
        if (obfuscated == null) {
            return null;
        }
        try {
            String result = new String(this.mDecryptor.doFinal(Base64.decode(obfuscated)), UTF8);
            int headerIndex = result.indexOf(header + key);
            if (headerIndex != 0) {
                throw new ValidationException("Header not found (invalid data or key):" + obfuscated);
            }
            return result.substring(header.length() + key.length(), result.length());
        }
        catch (Base64DecoderException e) {
            throw new ValidationException(String.valueOf(e.getMessage()) + ":" + obfuscated);
        }
        catch (IllegalBlockSizeException e) {
            throw new ValidationException(String.valueOf(e.getMessage()) + ":" + obfuscated);
        }
        catch (BadPaddingException e) {
            throw new ValidationException(String.valueOf(e.getMessage()) + ":" + obfuscated);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Invalid environment", e);
        }
    }
}

