/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.vending.expansion.downloader.impl;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.os.Messenger;
import com.android.vending.expansion.downloader.R;
import com.google.android.vending.expansion.downloader.DownloadProgressInfo;
import com.google.android.vending.expansion.downloader.DownloaderClientMarshaller;
import com.google.android.vending.expansion.downloader.Helpers;
import com.google.android.vending.expansion.downloader.IDownloaderClient;
import com.google.android.vending.expansion.downloader.impl.CustomNotificationFactory;

public class DownloadNotification
implements IDownloaderClient {
    private int mState = -1;
    private final Context mContext;
    private final NotificationManager mNotificationManager;
    private String mCurrentTitle;
    private IDownloaderClient mClientProxy;
    final ICustomNotification mCustomNotification;
    private Notification mNotification;
    private Notification mCurrentNotification;
    private CharSequence mLabel;
    private String mCurrentText;
    private PendingIntent mContentIntent;
    private DownloadProgressInfo mProgressInfo;
    static final String LOGTAG = "DownloadNotification";
    static final int NOTIFICATION_ID = "DownloadNotification".hashCode();

    public PendingIntent getClientIntent() {
        return this.mContentIntent;
    }

    public void setClientIntent(PendingIntent mClientIntent) {
        this.mContentIntent = mClientIntent;
    }

    public void resendState() {
        if (this.mClientProxy != null) {
            this.mClientProxy.onDownloadStateChanged(this.mState);
        }
    }

    @Override
    public void onDownloadStateChanged(int newState) {
        if (this.mClientProxy != null) {
            this.mClientProxy.onDownloadStateChanged(newState);
        }
        if (newState != this.mState) {
            boolean ongoingEvent;
            int stringDownloadID;
            int iconResource;
            this.mState = newState;
            if (newState == 1 || this.mContentIntent == null) {
                return;
            }
            switch (newState) {
                case 0: {
                    iconResource = 17301642;
                    stringDownloadID = R.string.state_unknown;
                    ongoingEvent = false;
                    break;
                }
                case 4: {
                    iconResource = 0x1080081;
                    stringDownloadID = Helpers.getDownloaderStringResourceIDFromState(newState);
                    ongoingEvent = true;
                    break;
                }
                case 2: 
                case 3: {
                    iconResource = 17301634;
                    stringDownloadID = Helpers.getDownloaderStringResourceIDFromState(newState);
                    ongoingEvent = true;
                    break;
                }
                case 5: 
                case 7: {
                    iconResource = 17301634;
                    stringDownloadID = Helpers.getDownloaderStringResourceIDFromState(newState);
                    ongoingEvent = false;
                    break;
                }
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: {
                    iconResource = 17301642;
                    stringDownloadID = Helpers.getDownloaderStringResourceIDFromState(newState);
                    ongoingEvent = false;
                    break;
                }
                default: {
                    iconResource = 17301642;
                    stringDownloadID = Helpers.getDownloaderStringResourceIDFromState(newState);
                    ongoingEvent = true;
                }
            }
            this.mCurrentText = this.mContext.getString(stringDownloadID);
            this.mCurrentTitle = this.mLabel.toString();
            this.mCurrentNotification.tickerText = this.mLabel + ": " + this.mCurrentText;
            this.mCurrentNotification.icon = iconResource;
            this.mCurrentNotification.setLatestEventInfo(this.mContext, (CharSequence)this.mCurrentTitle, (CharSequence)this.mCurrentText, this.mContentIntent);
            if (ongoingEvent) {
                this.mCurrentNotification.flags |= 2;
            } else {
                this.mCurrentNotification.flags &= 0xFFFFFFFD;
                this.mCurrentNotification.flags |= 0x10;
            }
            this.mNotificationManager.notify(NOTIFICATION_ID, this.mCurrentNotification);
        }
    }

    @Override
    public void onDownloadProgress(DownloadProgressInfo progress) {
        this.mProgressInfo = progress;
        if (this.mClientProxy != null) {
            this.mClientProxy.onDownloadProgress(progress);
        }
        if (progress.mOverallTotal <= 0L) {
            this.mNotification.tickerText = this.mCurrentTitle;
            this.mNotification.icon = 0x1080081;
            this.mNotification.setLatestEventInfo(this.mContext, this.mLabel, (CharSequence)this.mCurrentText, this.mContentIntent);
            this.mCurrentNotification = this.mNotification;
        } else {
            this.mCustomNotification.setCurrentBytes(progress.mOverallProgress);
            this.mCustomNotification.setTotalBytes(progress.mOverallTotal);
            this.mCustomNotification.setIcon(0x1080081);
            this.mCustomNotification.setPendingIntent(this.mContentIntent);
            this.mCustomNotification.setTicker(this.mLabel + ": " + this.mCurrentText);
            this.mCustomNotification.setTitle(this.mLabel);
            this.mCustomNotification.setTimeRemaining(progress.mTimeRemaining);
            this.mCurrentNotification = this.mCustomNotification.updateNotification(this.mContext);
        }
        this.mNotificationManager.notify(NOTIFICATION_ID, this.mCurrentNotification);
    }

    public void setMessenger(Messenger msg) {
        this.mClientProxy = DownloaderClientMarshaller.CreateProxy(msg);
        if (this.mProgressInfo != null) {
            this.mClientProxy.onDownloadProgress(this.mProgressInfo);
        }
        if (this.mState != -1) {
            this.mClientProxy.onDownloadStateChanged(this.mState);
        }
    }

    DownloadNotification(Context ctx, CharSequence applicationLabel) {
        this.mContext = ctx;
        this.mLabel = applicationLabel;
        this.mNotificationManager = (NotificationManager)this.mContext.getSystemService("notification");
        this.mCustomNotification = CustomNotificationFactory.createCustomNotification();
        this.mCurrentNotification = this.mNotification = new Notification();
    }

    @Override
    public void onServiceConnected(Messenger m) {
    }

    public static interface ICustomNotification {
        public void setTitle(CharSequence var1);

        public void setTicker(CharSequence var1);

        public void setPendingIntent(PendingIntent var1);

        public void setTotalBytes(long var1);

        public void setCurrentBytes(long var1);

        public void setIcon(int var1);

        public void setTimeRemaining(long var1);

        public Notification updateNotification(Context var1);
    }
}

