/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.vending.expansion.downloader.impl;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.WifiManager;
import android.os.Handler;
import android.os.IBinder;
import android.os.Messenger;
import android.os.Parcelable;
import android.os.SystemClock;
import android.provider.Settings;
import android.util.Log;
import com.google.android.vending.expansion.downloader.DownloadProgressInfo;
import com.google.android.vending.expansion.downloader.DownloaderServiceMarshaller;
import com.google.android.vending.expansion.downloader.Helpers;
import com.google.android.vending.expansion.downloader.IDownloaderService;
import com.google.android.vending.expansion.downloader.IStub;
import com.google.android.vending.expansion.downloader.impl.CustomIntentService;
import com.google.android.vending.expansion.downloader.impl.DownloadInfo;
import com.google.android.vending.expansion.downloader.impl.DownloadNotification;
import com.google.android.vending.expansion.downloader.impl.DownloadThread;
import com.google.android.vending.expansion.downloader.impl.DownloadsDB;
import com.google.android.vending.licensing.AESObfuscator;
import com.google.android.vending.licensing.APKExpansionPolicy;
import com.google.android.vending.licensing.LicenseChecker;
import com.google.android.vending.licensing.LicenseCheckerCallback;
import com.google.android.vending.licensing.Obfuscator;
import com.google.android.vending.licensing.Policy;
import java.io.File;

public abstract class DownloaderService
extends CustomIntentService
implements IDownloaderService {
    private static final String LOG_TAG = "LVLDL";
    public static final int NETWORK_OK = 1;
    public static final int NETWORK_NO_CONNECTION = 2;
    public static final int NETWORK_UNUSABLE_DUE_TO_SIZE = 3;
    public static final int NETWORK_RECOMMENDED_UNUSABLE_DUE_TO_SIZE = 4;
    public static final int NETWORK_CANNOT_USE_ROAMING = 5;
    public static final int NETWORK_TYPE_DISALLOWED_BY_REQUESTOR = 6;
    public static final String EXTRA_IS_WIFI_REQUIRED = "isWifiRequired";
    public static final String EXTRA_FILE_NAME = "downloadId";
    public static final String EXTRA_STATUS_STATE = "ESS";
    public static final String EXTRA_STATUS_TOTAL_SIZE = "ETS";
    public static final String EXTRA_STATUS_CURRENT_FILE_SIZE = "CFS";
    public static final String EXTRA_STATUS_TOTAL_PROGRESS = "TFP";
    public static final String EXTRA_STATUS_CURRENT_PROGRESS = "CFP";
    public static final String ACTION_DOWNLOADS_CHANGED = "downloadsChanged";
    public static final String ACTION_DOWNLOAD_COMPLETE = "lvldownloader.intent.action.DOWNLOAD_COMPLETE";
    public static final String ACTION_DOWNLOAD_STATUS = "lvldownloader.intent.action.DOWNLOAD_STATUS";
    public static final int STATUS_PENDING = 190;
    public static final int STATUS_RUNNING = 192;
    public static final int STATUS_PAUSED_BY_APP = 193;
    public static final int STATUS_WAITING_TO_RETRY = 194;
    public static final int STATUS_WAITING_FOR_NETWORK = 195;
    public static final int STATUS_QUEUED_FOR_WIFI_OR_CELLULAR_PERMISSION = 196;
    public static final int STATUS_QUEUED_FOR_WIFI = 197;
    public static final int STATUS_SUCCESS = 200;
    public static final int STATUS_FORBIDDEN = 403;
    public static final int STATUS_FILE_DELIVERED_INCORRECTLY = 487;
    public static final int STATUS_FILE_ALREADY_EXISTS_ERROR = 488;
    public static final int STATUS_CANNOT_RESUME = 489;
    public static final int STATUS_CANCELED = 490;
    public static final int STATUS_UNKNOWN_ERROR = 491;
    public static final int STATUS_FILE_ERROR = 492;
    public static final int STATUS_UNHANDLED_REDIRECT = 493;
    public static final int STATUS_UNHANDLED_HTTP_CODE = 494;
    public static final int STATUS_HTTP_DATA_ERROR = 495;
    public static final int STATUS_HTTP_EXCEPTION = 496;
    public static final int STATUS_TOO_MANY_REDIRECTS = 497;
    public static final int STATUS_INSUFFICIENT_SPACE_ERROR = 498;
    public static final int STATUS_DEVICE_NOT_FOUND_ERROR = 499;
    public static final int CONTROL_RUN = 0;
    public static final int CONTROL_PAUSED = 1;
    public static final int VISIBILITY_VISIBLE = 0;
    public static final int VISIBILITY_VISIBLE_NOTIFY_COMPLETED = 1;
    public static final int VISIBILITY_HIDDEN = 2;
    public static final int NETWORK_MOBILE = 1;
    public static final int NETWORK_WIFI = 2;
    private static final String TEMP_EXT = ".tmp";
    private static boolean sIsRunning;
    private boolean mIsConnected;
    private boolean mIsFailover;
    private boolean mIsCellularConnection;
    private boolean mIsRoaming;
    private boolean mIsAtLeast3G;
    private boolean mIsAtLeast4G;
    private boolean mStateChanged;
    private int mControl;
    private int mStatus;
    private ConnectivityManager mConnectivityManager;
    private WifiManager mWifiManager;
    private PackageInfo mPackageInfo;
    long mBytesSoFar;
    long mTotalLength;
    int mFileCount;
    long mBytesAtSample;
    long mMillisecondsAtSample;
    float mAverageDownloadSpeed;
    private BroadcastReceiver mConnReceiver;
    private final IStub mServiceStub = DownloaderServiceMarshaller.CreateStub(this);
    private final Messenger mServiceMessenger = this.mServiceStub.getMessenger();
    private Messenger mClientMessenger;
    private DownloadNotification mNotification;
    private PendingIntent mPendingIntent;
    private PendingIntent mAlarmIntent;
    public static final int NO_DOWNLOAD_REQUIRED = 0;
    public static final int LVL_CHECK_REQUIRED = 1;
    public static final int DOWNLOAD_REQUIRED = 2;
    public static final String EXTRA_PACKAGE_NAME = "EPN";
    public static final String EXTRA_PENDING_INTENT = "EPI";
    public static final String EXTRA_MESSAGE_HANDLER = "EMH";
    private static final float SMOOTHING_FACTOR = 0.005f;

    public DownloaderService() {
        super("LVLDownloadService");
    }

    public static boolean isStatusInformational(int status) {
        return status >= 100 && status < 200;
    }

    public static boolean isStatusSuccess(int status) {
        return status >= 200 && status < 300;
    }

    public static boolean isStatusError(int status) {
        return status >= 400 && status < 600;
    }

    public static boolean isStatusClientError(int status) {
        return status >= 400 && status < 500;
    }

    public static boolean isStatusServerError(int status) {
        return status >= 500 && status < 600;
    }

    public static boolean isStatusCompleted(int status) {
        return status >= 200 && status < 300 || status >= 400 && status < 600;
    }

    @Override
    public IBinder onBind(Intent paramIntent) {
        Log.d((String)LOG_TAG, (String)"Service Bound");
        return this.mServiceMessenger.getBinder();
    }

    public boolean isWiFi() {
        return this.mIsConnected && !this.mIsCellularConnection;
    }

    private void updateNetworkType(int type, int subType) {
        block0 : switch (type) {
            case 1: 
            case 7: 
            case 9: {
                this.mIsCellularConnection = false;
                this.mIsAtLeast3G = false;
                this.mIsAtLeast4G = false;
                break;
            }
            case 6: {
                this.mIsCellularConnection = true;
                this.mIsAtLeast3G = true;
                this.mIsAtLeast4G = true;
                break;
            }
            case 0: {
                this.mIsCellularConnection = true;
                switch (subType) {
                    case 1: 
                    case 2: 
                    case 4: 
                    case 7: 
                    case 11: {
                        this.mIsAtLeast3G = false;
                        this.mIsAtLeast4G = false;
                        break block0;
                    }
                    case 3: 
                    case 5: 
                    case 6: 
                    case 8: 
                    case 9: 
                    case 10: {
                        this.mIsAtLeast3G = true;
                        this.mIsAtLeast4G = false;
                        break block0;
                    }
                    case 13: 
                    case 14: 
                    case 15: {
                        this.mIsAtLeast3G = true;
                        this.mIsAtLeast4G = true;
                        break block0;
                    }
                }
                this.mIsCellularConnection = false;
                this.mIsAtLeast3G = false;
                this.mIsAtLeast4G = false;
            }
        }
    }

    private void updateNetworkState(NetworkInfo info) {
        boolean isConnected = this.mIsConnected;
        boolean isFailover = this.mIsFailover;
        boolean isCellularConnection = this.mIsCellularConnection;
        boolean isRoaming = this.mIsRoaming;
        boolean isAtLeast3G = this.mIsAtLeast3G;
        if (info != null) {
            this.mIsRoaming = info.isRoaming();
            this.mIsFailover = info.isFailover();
            this.mIsConnected = info.isConnected();
            this.updateNetworkType(info.getType(), info.getSubtype());
        } else {
            this.mIsRoaming = false;
            this.mIsFailover = false;
            this.mIsConnected = false;
            this.updateNetworkType(-1, -1);
        }
        this.mStateChanged = this.mStateChanged || isConnected != this.mIsConnected || isFailover != this.mIsFailover || isCellularConnection != this.mIsCellularConnection || isRoaming != this.mIsRoaming || isAtLeast3G != this.mIsAtLeast3G;
    }

    void pollNetworkState() {
        if (this.mConnectivityManager == null) {
            this.mConnectivityManager = (ConnectivityManager)this.getSystemService("connectivity");
        }
        if (this.mWifiManager == null) {
            this.mWifiManager = (WifiManager)this.getSystemService("wifi");
        }
        if (this.mConnectivityManager == null) {
            Log.w((String)LOG_TAG, (String)"couldn't get connectivity manager to poll network state");
        } else {
            NetworkInfo activeInfo = this.mConnectivityManager.getActiveNetworkInfo();
            this.updateNetworkState(activeInfo);
        }
    }

    private static boolean isLVLCheckRequired(DownloadsDB db, PackageInfo pi) {
        return db.mVersionCode != pi.versionCode;
    }

    private static synchronized boolean isServiceRunning() {
        return sIsRunning;
    }

    private static synchronized void setServiceRunning(boolean isRunning) {
        sIsRunning = isRunning;
    }

    public static int startDownloadServiceIfRequired(Context context, Intent intent, Class<?> serviceClass) throws PackageManager.NameNotFoundException {
        PendingIntent pendingIntent = (PendingIntent)intent.getParcelableExtra(EXTRA_PENDING_INTENT);
        return DownloaderService.startDownloadServiceIfRequired(context, pendingIntent, serviceClass);
    }

    public static int startDownloadServiceIfRequired(Context context, PendingIntent pendingIntent, Class<?> serviceClass) throws PackageManager.NameNotFoundException {
        String packageName = context.getPackageName();
        String className = serviceClass.getName();
        return DownloaderService.startDownloadServiceIfRequired(context, pendingIntent, packageName, className);
    }

    public static int startDownloadServiceIfRequired(Context context, PendingIntent pendingIntent, String classPackage, String className) throws PackageManager.NameNotFoundException {
        PackageInfo pi = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
        int status = 0;
        DownloadsDB db = DownloadsDB.getDB(context);
        if (DownloaderService.isLVLCheckRequired(db, pi)) {
            status = 1;
        }
        if (db.mStatus == 0) {
            DownloadInfo[] infos = db.getDownloads();
            if (infos != null) {
                DownloadInfo[] downloadInfoArray = infos;
                int n = infos.length;
                int n2 = 0;
                while (n2 < n) {
                    DownloadInfo info = downloadInfoArray[n2];
                    if (!Helpers.doesFileExist(context, info.mFileName, info.mTotalBytes, true)) {
                        status = 2;
                        db.updateStatus(-1);
                        break;
                    }
                    ++n2;
                }
            }
        } else {
            status = 2;
        }
        switch (status) {
            case 1: 
            case 2: {
                Intent fileIntent = new Intent();
                fileIntent.setClassName(classPackage, className);
                fileIntent.putExtra(EXTRA_PENDING_INTENT, (Parcelable)pendingIntent);
                context.startService(fileIntent);
            }
        }
        return status;
    }

    @Override
    public void requestAbortDownload() {
        this.mControl = 1;
        this.mStatus = 490;
    }

    @Override
    public void requestPauseDownload() {
        this.mControl = 1;
        this.mStatus = 193;
    }

    @Override
    public void setDownloadFlags(int flags) {
        DownloadsDB.getDB((Context)this).updateFlags(flags);
    }

    @Override
    public void requestContinueDownload() {
        if (this.mControl == 1) {
            this.mControl = 0;
        }
        Intent fileIntent = new Intent((Context)this, this.getClass());
        fileIntent.putExtra(EXTRA_PENDING_INTENT, (Parcelable)this.mPendingIntent);
        this.startService(fileIntent);
    }

    public abstract String getPublicKey();

    public abstract byte[] getSALT();

    public abstract String getAlarmReceiverClassName();

    public void updateLVL(Context context) {
        Context c = context.getApplicationContext();
        Handler h = new Handler(c.getMainLooper());
        h.post((Runnable)new LVLRunnable(c, this.mPendingIntent));
    }

    public boolean handleFileUpdated(DownloadsDB db, int index, String filename, long fileSize) {
        String oldFile;
        DownloadInfo di = db.getDownloadInfoByFileName(filename);
        if (di != null && (oldFile = di.mFileName) != null) {
            if (filename.equals(oldFile)) {
                return false;
            }
            String deleteFile = Helpers.generateSaveFileName((Context)this, oldFile);
            File f = new File(deleteFile);
            if (f.exists()) {
                f.delete();
            }
        }
        return !Helpers.doesFileExist((Context)this, filename, fileSize, true);
    }

    private void scheduleAlarm(long wakeUp) {
        AlarmManager alarms = (AlarmManager)this.getSystemService("alarm");
        if (alarms == null) {
            Log.e((String)LOG_TAG, (String)"couldn't get alarm manager");
            return;
        }
        String className = this.getAlarmReceiverClassName();
        Intent intent = new Intent("android.intent.action.DOWNLOAD_WAKEUP");
        intent.putExtra(EXTRA_PENDING_INTENT, (Parcelable)this.mPendingIntent);
        intent.setClassName(this.getPackageName(), className);
        this.mAlarmIntent = PendingIntent.getBroadcast((Context)this, (int)0, (Intent)intent, (int)0x40000000);
        alarms.set(0, System.currentTimeMillis() + wakeUp, this.mAlarmIntent);
    }

    private void cancelAlarms() {
        if (this.mAlarmIntent != null) {
            AlarmManager alarms = (AlarmManager)this.getSystemService("alarm");
            if (alarms == null) {
                Log.e((String)LOG_TAG, (String)"couldn't get alarm manager");
                return;
            }
            alarms.cancel(this.mAlarmIntent);
            this.mAlarmIntent = null;
        }
    }

    @Override
    protected void onHandleIntent(Intent intent) {
        DownloaderService.setServiceRunning(true);
        try {
            DownloadInfo info;
            DownloadsDB db = DownloadsDB.getDB((Context)this);
            PendingIntent pendingIntent = (PendingIntent)intent.getParcelableExtra(EXTRA_PENDING_INTENT);
            if (pendingIntent != null) {
                this.mNotification.setClientIntent(pendingIntent);
                this.mPendingIntent = pendingIntent;
            } else if (this.mPendingIntent != null) {
                this.mNotification.setClientIntent(this.mPendingIntent);
            } else {
                Log.e((String)LOG_TAG, (String)"Downloader started in bad state without notification intent.");
                return;
            }
            if (DownloaderService.isLVLCheckRequired(db, this.mPackageInfo)) {
                this.updateLVL((Context)this);
                return;
            }
            DownloadInfo[] infos = db.getDownloads();
            this.mBytesSoFar = 0L;
            this.mTotalLength = 0L;
            this.mFileCount = infos.length;
            DownloadInfo[] downloadInfoArray = infos;
            int n = infos.length;
            int n2 = 0;
            while (n2 < n) {
                info = downloadInfoArray[n2];
                if (info.mStatus == 200 && !Helpers.doesFileExist((Context)this, info.mFileName, info.mTotalBytes, true)) {
                    info.mStatus = 0;
                    info.mCurrentBytes = 0L;
                }
                this.mTotalLength += info.mTotalBytes;
                this.mBytesSoFar += info.mCurrentBytes;
                ++n2;
            }
            this.pollNetworkState();
            if (this.mConnReceiver == null) {
                this.mConnReceiver = new InnerBroadcastReceiver(this);
                IntentFilter intentFilter = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
                intentFilter.addAction("android.net.wifi.WIFI_STATE_CHANGED");
                this.registerReceiver(this.mConnReceiver, intentFilter);
            }
            downloadInfoArray = infos;
            n = infos.length;
            n2 = 0;
            while (n2 < n) {
                block32: {
                    int notifyStatus;
                    info = downloadInfoArray[n2];
                    long startingCount = info.mCurrentBytes;
                    if (info.mStatus != 200) {
                        DownloadThread dt = new DownloadThread(info, this, this.mNotification);
                        this.cancelAlarms();
                        this.scheduleAlarm(5000L);
                        dt.run();
                        this.cancelAlarms();
                    }
                    db.updateFromDb(info);
                    boolean setWakeWatchdog = false;
                    switch (info.mStatus) {
                        case 403: {
                            this.updateLVL((Context)this);
                            return;
                        }
                        case 200: {
                            this.mBytesSoFar += info.mCurrentBytes - startingCount;
                            db.updateMetadata(this.mPackageInfo.versionCode, 0);
                            break block32;
                        }
                        case 487: {
                            notifyStatus = 13;
                            info.mCurrentBytes = 0L;
                            db.updateDownload(info);
                            setWakeWatchdog = true;
                            break;
                        }
                        case 193: {
                            notifyStatus = 7;
                            break;
                        }
                        case 194: 
                        case 195: {
                            notifyStatus = 6;
                            setWakeWatchdog = true;
                            break;
                        }
                        case 196: 
                        case 197: {
                            if (this.mWifiManager != null && !this.mWifiManager.isWifiEnabled()) {
                                notifyStatus = 8;
                                setWakeWatchdog = true;
                                break;
                            }
                            notifyStatus = 9;
                            setWakeWatchdog = true;
                            break;
                        }
                        case 490: {
                            notifyStatus = 18;
                            setWakeWatchdog = true;
                            break;
                        }
                        case 498: {
                            notifyStatus = 17;
                            setWakeWatchdog = true;
                            break;
                        }
                        case 499: {
                            notifyStatus = 14;
                            setWakeWatchdog = true;
                            break;
                        }
                        default: {
                            notifyStatus = 19;
                        }
                    }
                    if (setWakeWatchdog) {
                        this.scheduleAlarm(60000L);
                    } else {
                        this.cancelAlarms();
                    }
                    this.mNotification.onDownloadStateChanged(notifyStatus);
                    return;
                }
                ++n2;
            }
            this.mNotification.onDownloadStateChanged(5);
        }
        finally {
            DownloaderService.setServiceRunning(false);
        }
    }

    @Override
    public void onDestroy() {
        if (this.mConnReceiver != null) {
            this.unregisterReceiver(this.mConnReceiver);
            this.mConnReceiver = null;
        }
        this.mServiceStub.disconnect((Context)this);
        super.onDestroy();
    }

    public int getNetworkAvailabilityState(DownloadsDB db) {
        if (this.mIsConnected) {
            if (!this.mIsCellularConnection) {
                return 1;
            }
            int flags = db.mFlags;
            if (this.mIsRoaming) {
                return 5;
            }
            if ((flags & 1) != 0) {
                return 1;
            }
            return 6;
        }
        return 2;
    }

    @Override
    public void onCreate() {
        super.onCreate();
        try {
            this.mPackageInfo = this.getPackageManager().getPackageInfo(this.getPackageName(), 0);
            ApplicationInfo ai = this.getApplicationInfo();
            CharSequence applicationLabel = this.getPackageManager().getApplicationLabel(ai);
            this.mNotification = new DownloadNotification((Context)this, applicationLabel);
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
    }

    public String generateTempSaveFileName(String fileName) {
        String path = String.valueOf(Helpers.getSaveFilePath((Context)this)) + File.separator + fileName + TEMP_EXT;
        return path;
    }

    public String generateSaveFile(String filename, long filesize) throws GenerateSaveFileError {
        String path = this.generateTempSaveFileName(filename);
        File expPath = new File(path);
        if (!Helpers.isExternalMediaMounted()) {
            Log.d((String)LOG_TAG, (String)("External media not mounted: " + path));
            throw new GenerateSaveFileError(499, "external media is not yet mounted");
        }
        if (expPath.exists()) {
            Log.d((String)LOG_TAG, (String)("File already exists: " + path));
            throw new GenerateSaveFileError(488, "requested destination file already exists");
        }
        if (Helpers.getAvailableBytes(Helpers.getFilesystemRoot(path)) < filesize) {
            throw new GenerateSaveFileError(498, "insufficient space on external storage");
        }
        return path;
    }

    public String getLogMessageForNetworkError(int networkError) {
        switch (networkError) {
            case 4: {
                return "download size exceeds recommended limit for mobile network";
            }
            case 3: {
                return "download size exceeds limit for mobile network";
            }
            case 2: {
                return "no network connection available";
            }
            case 5: {
                return "download cannot use the current network connection because it is roaming";
            }
            case 6: {
                return "download was requested to not use the current network type";
            }
        }
        return "unknown error with network connectivity";
    }

    public int getControl() {
        return this.mControl;
    }

    public int getStatus() {
        return this.mStatus;
    }

    public void notifyUpdateBytes(long totalBytesSoFar) {
        long timeRemaining;
        long currentTime = SystemClock.uptimeMillis();
        if (0L != this.mMillisecondsAtSample) {
            long timePassed = currentTime - this.mMillisecondsAtSample;
            long bytesInSample = totalBytesSoFar - this.mBytesAtSample;
            float currentSpeedSample = (float)bytesInSample / (float)timePassed;
            this.mAverageDownloadSpeed = 0.0f != this.mAverageDownloadSpeed ? 0.005f * currentSpeedSample + 0.995f * this.mAverageDownloadSpeed : currentSpeedSample;
            timeRemaining = (long)((float)(this.mTotalLength - totalBytesSoFar) / this.mAverageDownloadSpeed);
        } else {
            timeRemaining = -1L;
        }
        this.mMillisecondsAtSample = currentTime;
        this.mBytesAtSample = totalBytesSoFar;
        this.mNotification.onDownloadProgress(new DownloadProgressInfo(this.mTotalLength, totalBytesSoFar, timeRemaining, this.mAverageDownloadSpeed));
    }

    @Override
    protected boolean shouldStop() {
        DownloadsDB db = DownloadsDB.getDB((Context)this);
        return db.mStatus == 0;
    }

    @Override
    public void requestDownloadStatus() {
        this.mNotification.resendState();
    }

    @Override
    public void onClientUpdated(Messenger clientMessenger) {
        this.mClientMessenger = clientMessenger;
        this.mNotification.setMessenger(this.mClientMessenger);
    }

    public static class GenerateSaveFileError
    extends Exception {
        private static final long serialVersionUID = 3465966015408936540L;
        int mStatus;
        String mMessage;

        public GenerateSaveFileError(int status, String message) {
            this.mStatus = status;
            this.mMessage = message;
        }
    }

    private class InnerBroadcastReceiver
    extends BroadcastReceiver {
        final Service mService;

        InnerBroadcastReceiver(Service service) {
            this.mService = service;
        }

        public void onReceive(Context context, Intent intent) {
            DownloaderService.this.pollNetworkState();
            if (DownloaderService.this.mStateChanged && !DownloaderService.isServiceRunning()) {
                Log.d((String)DownloaderService.LOG_TAG, (String)"InnerBroadcastReceiver Called");
                Intent fileIntent = new Intent(context, this.mService.getClass());
                fileIntent.putExtra(DownloaderService.EXTRA_PENDING_INTENT, (Parcelable)DownloaderService.this.mPendingIntent);
                context.startService(fileIntent);
            }
        }
    }

    private class LVLRunnable
    implements Runnable {
        final Context mContext;

        LVLRunnable(Context context, PendingIntent intent) {
            this.mContext = context;
            DownloaderService.this.mPendingIntent = intent;
        }

        @Override
        public void run() {
            DownloaderService.setServiceRunning(true);
            DownloaderService.this.mNotification.onDownloadStateChanged(2);
            String deviceId = Settings.Secure.getString((ContentResolver)this.mContext.getContentResolver(), (String)"android_id");
            final APKExpansionPolicy aep = new APKExpansionPolicy(this.mContext, (Obfuscator)new AESObfuscator(DownloaderService.this.getSALT(), this.mContext.getPackageName(), deviceId));
            aep.resetPolicy();
            LicenseChecker checker = new LicenseChecker(this.mContext, (Policy)aep, DownloaderService.this.getPublicKey());
            checker.checkAccess(new LicenseCheckerCallback(){

                public void allow(int reason) {
                    try {
                        int count = aep.getExpansionURLCount();
                        DownloadsDB db = DownloadsDB.getDB(LVLRunnable.this.mContext);
                        int status = 0;
                        if (count != 0) {
                            int i = 0;
                            while (i < count) {
                                String currentFileName = aep.getExpansionFileName(i);
                                if (currentFileName != null) {
                                    DownloadInfo di = new DownloadInfo(i, currentFileName, LVLRunnable.this.mContext.getPackageName());
                                    long fileSize = aep.getExpansionFileSize(i);
                                    if (DownloaderService.this.handleFileUpdated(db, i, currentFileName, fileSize)) {
                                        di.resetDownload();
                                        di.mUri = aep.getExpansionURL(i);
                                        di.mTotalBytes = fileSize;
                                        di.mStatus = status |= 0xFFFFFFFF;
                                        db.updateDownload(di);
                                    } else {
                                        DownloadInfo dbdi = db.getDownloadInfoByFileName(di.mFileName);
                                        if (dbdi == null) {
                                            Log.d((String)DownloaderService.LOG_TAG, (String)("file " + di.mFileName + " found. Not downloading."));
                                            di.mStatus = 200;
                                            di.mTotalBytes = fileSize;
                                            di.mCurrentBytes = fileSize;
                                            di.mUri = aep.getExpansionURL(i);
                                            db.updateDownload(di);
                                        } else if (dbdi.mStatus != 200) {
                                            dbdi.mUri = aep.getExpansionURL(i);
                                            db.updateDownload(dbdi);
                                            status |= 0xFFFFFFFF;
                                        }
                                    }
                                }
                                ++i;
                            }
                        }
                        try {
                            PackageInfo pi = LVLRunnable.this.mContext.getPackageManager().getPackageInfo(LVLRunnable.this.mContext.getPackageName(), 0);
                            db.updateMetadata(pi.versionCode, status);
                            Class<?> serviceClass = DownloaderService.this.getClass();
                            switch (DownloaderService.startDownloadServiceIfRequired(LVLRunnable.this.mContext, DownloaderService.this.mPendingIntent, serviceClass)) {
                                case 0: {
                                    DownloaderService.this.mNotification.onDownloadStateChanged(5);
                                    break;
                                }
                                case 1: {
                                    Log.e((String)DownloaderService.LOG_TAG, (String)"In LVL checking loop!");
                                    DownloaderService.this.mNotification.onDownloadStateChanged(15);
                                    throw new RuntimeException("Error with LVL checking and database integrity");
                                }
                            }
                        }
                        catch (PackageManager.NameNotFoundException e1) {
                            e1.printStackTrace();
                            throw new RuntimeException("Error with getting information from package name");
                        }
                    }
                    finally {
                        DownloaderService.setServiceRunning(false);
                    }
                }

                public void dontAllow(int reason) {
                    try {
                        switch (reason) {
                            case 561: {
                                DownloaderService.this.mNotification.onDownloadStateChanged(15);
                                break;
                            }
                            case 291: {
                                DownloaderService.this.mNotification.onDownloadStateChanged(16);
                            }
                        }
                    }
                    finally {
                        DownloaderService.setServiceRunning(false);
                    }
                }

                public void applicationError(int errorCode) {
                    try {
                        DownloaderService.this.mNotification.onDownloadStateChanged(16);
                    }
                    finally {
                        DownloaderService.setServiceRunning(false);
                    }
                }
            });
        }
    }
}

