/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.vending.expansion.downloader.impl;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteDoneException;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteOpenHelper;
import android.database.sqlite.SQLiteStatement;
import android.provider.BaseColumns;
import android.util.Log;
import com.google.android.vending.expansion.downloader.impl.DownloadInfo;

public class DownloadsDB {
    private static final String DATABASE_NAME = "DownloadsDB";
    private static final int DATABASE_VERSION = 7;
    public static final String LOG_TAG = DownloadsDB.class.getName();
    final SQLiteOpenHelper mHelper;
    SQLiteStatement mGetDownloadByIndex;
    SQLiteStatement mUpdateCurrentBytes;
    private static DownloadsDB mDownloadsDB;
    long mMetadataRowID = -1L;
    int mVersionCode = -1;
    int mStatus = -1;
    int mFlags;
    private static final String[] DC_PROJECTION;
    private static final int FILENAME_IDX = 0;
    private static final int URI_IDX = 1;
    private static final int ETAG_IDX = 2;
    private static final int TOTALBYTES_IDX = 3;
    private static final int CURRENTBYTES_IDX = 4;
    private static final int LASTMOD_IDX = 5;
    private static final int STATUS_IDX = 6;
    private static final int CONTROL_IDX = 7;
    private static final int NUM_FAILED_IDX = 8;
    private static final int RETRY_AFTER_IDX = 9;
    private static final int REDIRECT_COUNT_IDX = 10;
    private static final int INDEX_IDX = 11;

    static {
        DC_PROJECTION = new String[]{"FN", "URI", "ETAG", "TOTALBYTES", "CURRENTBYTES", "LASTMOD", "STATUS", "CONTROL", "FAILCOUNT", "RETRYAFTER", "REDIRECTCOUNT", "FILEIDX"};
    }

    public static synchronized DownloadsDB getDB(Context paramContext) {
        if (mDownloadsDB == null) {
            return new DownloadsDB(paramContext);
        }
        return mDownloadsDB;
    }

    private SQLiteStatement getDownloadByIndexStatement() {
        if (this.mGetDownloadByIndex == null) {
            this.mGetDownloadByIndex = this.mHelper.getReadableDatabase().compileStatement("SELECT _id FROM DownloadColumns WHERE FILEIDX = ?");
        }
        return this.mGetDownloadByIndex;
    }

    private SQLiteStatement getUpdateCurrentBytesStatement() {
        if (this.mUpdateCurrentBytes == null) {
            this.mUpdateCurrentBytes = this.mHelper.getReadableDatabase().compileStatement("UPDATE DownloadColumns SET CURRENTBYTES = ? WHERE FILEIDX = ?");
        }
        return this.mUpdateCurrentBytes;
    }

    private DownloadsDB(Context paramContext) {
        this.mHelper = new DownloadsContentDBHelper(paramContext);
        SQLiteDatabase sqldb = this.mHelper.getReadableDatabase();
        Cursor cur = sqldb.rawQuery("SELECT APKVERSION,_id,DOWNLOADSTATUS,DOWNLOADFLAGS FROM MetadataColumns LIMIT 1", null);
        if (cur != null && cur.moveToFirst()) {
            this.mVersionCode = cur.getInt(0);
            this.mMetadataRowID = cur.getLong(1);
            this.mStatus = cur.getInt(2);
            this.mFlags = cur.getInt(3);
            cur.close();
        }
        mDownloadsDB = this;
    }

    protected DownloadInfo getDownloadInfoByFileName(String fileName) {
        SQLiteDatabase sqldb = this.mHelper.getReadableDatabase();
        Cursor itemcur = null;
        try {
            itemcur = sqldb.query("DownloadColumns", DC_PROJECTION, "FN = ?", new String[]{fileName}, null, null, null);
            if (itemcur != null && itemcur.moveToFirst()) {
                DownloadInfo downloadInfo = this.getDownloadInfoFromCursor(itemcur);
                return downloadInfo;
            }
        }
        finally {
            if (itemcur != null) {
                itemcur.close();
            }
        }
        return null;
    }

    public long getIDForDownloadInfo(DownloadInfo di) {
        return this.getIDByIndex(di.mIndex);
    }

    public long getIDByIndex(int index) {
        SQLiteStatement downloadByIndex = this.getDownloadByIndexStatement();
        downloadByIndex.clearBindings();
        downloadByIndex.bindLong(1, (long)index);
        try {
            return downloadByIndex.simpleQueryForLong();
        }
        catch (SQLiteDoneException e) {
            return -1L;
        }
    }

    public void updateDownloadCurrentBytes(DownloadInfo di) {
        SQLiteStatement downloadCurrentBytes = this.getUpdateCurrentBytesStatement();
        downloadCurrentBytes.clearBindings();
        downloadCurrentBytes.bindLong(1, di.mCurrentBytes);
        downloadCurrentBytes.bindLong(2, (long)di.mIndex);
        downloadCurrentBytes.execute();
    }

    public void close() {
        this.mHelper.close();
    }

    public boolean updateDownload(DownloadInfo di) {
        ContentValues cv = new ContentValues();
        cv.put("FILEIDX", Integer.valueOf(di.mIndex));
        cv.put("FN", di.mFileName);
        cv.put("URI", di.mUri);
        cv.put("ETAG", di.mETag);
        cv.put("TOTALBYTES", Long.valueOf(di.mTotalBytes));
        cv.put("CURRENTBYTES", Long.valueOf(di.mCurrentBytes));
        cv.put("LASTMOD", Long.valueOf(di.mLastMod));
        cv.put("STATUS", Integer.valueOf(di.mStatus));
        cv.put("CONTROL", Integer.valueOf(di.mControl));
        cv.put("FAILCOUNT", Integer.valueOf(di.mNumFailed));
        cv.put("RETRYAFTER", Integer.valueOf(di.mRetryAfter));
        cv.put("REDIRECTCOUNT", Integer.valueOf(di.mRedirectCount));
        return this.updateDownload(di, cv);
    }

    public boolean updateDownload(DownloadInfo di, ContentValues cv) {
        SQLiteDatabase sqldb;
        block4: {
            long id2 = di == null ? -1L : this.getIDForDownloadInfo(di);
            sqldb = this.mHelper.getWritableDatabase();
            if (id2 == -1L) break block4;
            if (1 != sqldb.update("DownloadColumns", cv, "DownloadColumns._id = " + id2, null)) {
                return false;
            }
        }
        try {
            return -1L != sqldb.insert("DownloadColumns", "URI", cv);
        }
        catch (SQLiteException ex) {
            ex.printStackTrace();
        }
        return false;
    }

    public int getLastCheckedVersionCode() {
        return this.mVersionCode;
    }

    public boolean isDownloadRequired() {
        SQLiteDatabase sqldb = this.mHelper.getReadableDatabase();
        Cursor cur = sqldb.rawQuery("SELECT Count(*) FROM DownloadColumns WHERE STATUS <> 0", null);
        try {
            if (cur != null && cur.moveToFirst()) {
                boolean bl = cur.getInt(0) == 0;
                return bl;
            }
        }
        finally {
            if (cur != null) {
                cur.close();
            }
        }
        return true;
    }

    public int getFlags() {
        return this.mFlags;
    }

    public boolean updateFlags(int flags) {
        if (this.mFlags != flags) {
            ContentValues cv = new ContentValues();
            cv.put("DOWNLOADFLAGS", Integer.valueOf(flags));
            if (this.updateMetadata(cv)) {
                this.mFlags = flags;
                return true;
            }
            return false;
        }
        return true;
    }

    public boolean updateStatus(int status) {
        if (this.mStatus != status) {
            ContentValues cv = new ContentValues();
            cv.put("DOWNLOADSTATUS", Integer.valueOf(status));
            if (this.updateMetadata(cv)) {
                this.mStatus = status;
                return true;
            }
            return false;
        }
        return true;
    }

    public boolean updateMetadata(ContentValues cv) {
        SQLiteDatabase sqldb = this.mHelper.getWritableDatabase();
        if (-1L == this.mMetadataRowID) {
            long newID = sqldb.insert("MetadataColumns", "APKVERSION", cv);
            if (-1L == newID) {
                return false;
            }
            this.mMetadataRowID = newID;
        } else if (sqldb.update("MetadataColumns", cv, "_id = " + this.mMetadataRowID, null) == 0) {
            return false;
        }
        return true;
    }

    public boolean updateMetadata(int apkVersion, int downloadStatus) {
        ContentValues cv = new ContentValues();
        cv.put("APKVERSION", Integer.valueOf(apkVersion));
        cv.put("DOWNLOADSTATUS", Integer.valueOf(downloadStatus));
        if (this.updateMetadata(cv)) {
            this.mVersionCode = apkVersion;
            this.mStatus = downloadStatus;
            return true;
        }
        return false;
    }

    public boolean updateFromDb(DownloadInfo di) {
        SQLiteDatabase sqldb = this.mHelper.getReadableDatabase();
        Cursor cur = null;
        try {
            cur = sqldb.query("DownloadColumns", DC_PROJECTION, "FN= ?", new String[]{di.mFileName}, null, null, null);
            if (cur != null && cur.moveToFirst()) {
                this.setDownloadInfoFromCursor(di, cur);
                return true;
            }
            return false;
        }
        finally {
            if (cur != null) {
                cur.close();
            }
        }
    }

    public void setDownloadInfoFromCursor(DownloadInfo di, Cursor cur) {
        di.mUri = cur.getString(1);
        di.mETag = cur.getString(2);
        di.mTotalBytes = cur.getLong(3);
        di.mCurrentBytes = cur.getLong(4);
        di.mLastMod = cur.getLong(5);
        di.mStatus = cur.getInt(6);
        di.mControl = cur.getInt(7);
        di.mNumFailed = cur.getInt(8);
        di.mRetryAfter = cur.getInt(9);
        di.mRedirectCount = cur.getInt(10);
    }

    public DownloadInfo getDownloadInfoFromCursor(Cursor cur) {
        DownloadInfo di = new DownloadInfo(cur.getInt(11), cur.getString(0), this.getClass().getPackage().getName());
        this.setDownloadInfoFromCursor(di, cur);
        return di;
    }

    public DownloadInfo[] getDownloads() {
        SQLiteDatabase sqldb = this.mHelper.getReadableDatabase();
        Cursor cur = null;
        try {
            cur = sqldb.query("DownloadColumns", DC_PROJECTION, null, null, null, null, null);
            if (cur != null && cur.moveToFirst()) {
                DownloadInfo[] retInfos = new DownloadInfo[cur.getCount()];
                int idx = 0;
                do {
                    DownloadInfo di = this.getDownloadInfoFromCursor(cur);
                    retInfos[idx++] = di;
                } while (cur.moveToNext());
                DownloadInfo[] downloadInfoArray = retInfos;
                return downloadInfoArray;
            }
            return null;
        }
        finally {
            if (cur != null) {
                cur.close();
            }
        }
    }

    public static class DownloadColumns
    implements BaseColumns {
        public static final String INDEX = "FILEIDX";
        public static final String URI = "URI";
        public static final String FILENAME = "FN";
        public static final String ETAG = "ETAG";
        public static final String TOTALBYTES = "TOTALBYTES";
        public static final String CURRENTBYTES = "CURRENTBYTES";
        public static final String LASTMOD = "LASTMOD";
        public static final String STATUS = "STATUS";
        public static final String CONTROL = "CONTROL";
        public static final String NUM_FAILED = "FAILCOUNT";
        public static final String RETRY_AFTER = "RETRYAFTER";
        public static final String REDIRECT_COUNT = "REDIRECTCOUNT";
        public static final String[][] SCHEMA = new String[][]{{"_id", "INTEGER PRIMARY KEY"}, {"FILEIDX", "INTEGER UNIQUE"}, {"URI", "TEXT"}, {"FN", "TEXT UNIQUE"}, {"ETAG", "TEXT"}, {"TOTALBYTES", "INTEGER"}, {"CURRENTBYTES", "INTEGER"}, {"LASTMOD", "INTEGER"}, {"STATUS", "INTEGER"}, {"CONTROL", "INTEGER"}, {"FAILCOUNT", "INTEGER"}, {"RETRYAFTER", "INTEGER"}, {"REDIRECTCOUNT", "INTEGER"}};
        public static final String TABLE_NAME = "DownloadColumns";
        public static final String _ID = "DownloadColumns._id";
    }

    protected static class DownloadsContentDBHelper
    extends SQLiteOpenHelper {
        private static final String[][][] sSchemas = new String[][][]{DownloadColumns.SCHEMA, MetadataColumns.SCHEMA};
        private static final String[] sTables = new String[]{"DownloadColumns", "MetadataColumns"};

        DownloadsContentDBHelper(Context paramContext) {
            super(paramContext, DownloadsDB.DATABASE_NAME, null, 7);
        }

        private String createTableQueryFromArray(String paramString, String[][] paramArrayOfString) {
            StringBuilder localStringBuilder = new StringBuilder();
            localStringBuilder.append("CREATE TABLE ");
            localStringBuilder.append(paramString);
            localStringBuilder.append(" (");
            int i = paramArrayOfString.length;
            int j = 0;
            while (true) {
                if (j >= i) {
                    localStringBuilder.setLength(localStringBuilder.length() - 1);
                    localStringBuilder.append(");");
                    return localStringBuilder.toString();
                }
                String[] arrayOfString = paramArrayOfString[j];
                localStringBuilder.append(' ');
                localStringBuilder.append(arrayOfString[0]);
                localStringBuilder.append(' ');
                localStringBuilder.append(arrayOfString[1]);
                localStringBuilder.append(',');
                ++j;
            }
        }

        private void dropTables(SQLiteDatabase paramSQLiteDatabase) {
            String[] stringArray = sTables;
            int n = sTables.length;
            int n2 = 0;
            while (n2 < n) {
                String table = stringArray[n2];
                try {
                    paramSQLiteDatabase.execSQL("DROP TABLE IF EXISTS " + table);
                }
                catch (Exception localException) {
                    localException.printStackTrace();
                }
                ++n2;
            }
        }

        public void onCreate(SQLiteDatabase paramSQLiteDatabase) {
            int numSchemas = sSchemas.length;
            int i = 0;
            while (i < numSchemas) {
                try {
                    String[][] schema = sSchemas[i];
                    paramSQLiteDatabase.execSQL(this.createTableQueryFromArray(sTables[i], schema));
                }
                catch (Exception localException) {
                    while (true) {
                        localException.printStackTrace();
                    }
                }
                ++i;
            }
        }

        public void onUpgrade(SQLiteDatabase paramSQLiteDatabase, int paramInt1, int paramInt2) {
            Log.w((String)DownloadsContentDBHelper.class.getName(), (String)("Upgrading database from version " + paramInt1 + " to " + paramInt2 + ", which will destroy all old data"));
            this.dropTables(paramSQLiteDatabase);
            this.onCreate(paramSQLiteDatabase);
        }
    }

    public static class MetadataColumns
    implements BaseColumns {
        public static final String APKVERSION = "APKVERSION";
        public static final String DOWNLOAD_STATUS = "DOWNLOADSTATUS";
        public static final String FLAGS = "DOWNLOADFLAGS";
        public static final String[][] SCHEMA = new String[][]{{"_id", "INTEGER PRIMARY KEY"}, {"APKVERSION", "INTEGER"}, {"DOWNLOADSTATUS", "INTEGER"}, {"DOWNLOADFLAGS", "INTEGER"}};
        public static final String TABLE_NAME = "MetadataColumns";
        public static final String _ID = "MetadataColumns._id";
    }
}

