/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova;

import android.os.Message;
import android.util.Log;
import android.webkit.WebView;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.LinkedList;
import org.apache.cordova.CordovaInterface;
import org.apache.cordova.CordovaWebView;
import org.apache.cordova.PluginResult;

public class NativeToJsMessageQueue {
    private static final String LOG_TAG = "JsMessageQueue";
    private static final int DEFAULT_BRIDGE_MODE = 2;
    private static final boolean FORCE_ENCODE_USING_EVAL = false;
    static final boolean ENABLE_LOCATION_CHANGE_EXEC_MODE = false;
    static final boolean DISABLE_EXEC_CHAINING = false;
    private static int MAX_PAYLOAD_SIZE = 524288000;
    private int activeListenerIndex;
    private boolean paused;
    private final LinkedList<JsMessage> queue = new LinkedList();
    private final BridgeMode[] registeredListeners;
    private final CordovaInterface cordova;
    private final CordovaWebView webView;

    public NativeToJsMessageQueue(CordovaWebView webView, CordovaInterface cordova) {
        this.cordova = cordova;
        this.webView = webView;
        this.registeredListeners = new BridgeMode[4];
        this.registeredListeners[0] = null;
        this.registeredListeners[1] = new LoadUrlBridgeMode();
        this.registeredListeners[2] = new OnlineEventsBridgeMode();
        this.registeredListeners[3] = new PrivateApiBridgeMode();
        this.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBridgeMode(int value) {
        if (value < 0 || value >= this.registeredListeners.length) {
            Log.d((String)LOG_TAG, (String)("Invalid NativeToJsBridgeMode: " + value));
        } else if (value != this.activeListenerIndex) {
            Log.d((String)LOG_TAG, (String)("Set native->JS mode to " + value));
            NativeToJsMessageQueue nativeToJsMessageQueue = this;
            synchronized (nativeToJsMessageQueue) {
                this.activeListenerIndex = value;
                BridgeMode activeListener = this.registeredListeners[value];
                if (!this.paused && !this.queue.isEmpty() && activeListener != null) {
                    activeListener.onNativeToJsMessageAvailable();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        NativeToJsMessageQueue nativeToJsMessageQueue = this;
        synchronized (nativeToJsMessageQueue) {
            this.queue.clear();
            this.setBridgeMode(2);
        }
    }

    private int calculatePackedMessageLength(JsMessage message) {
        int messageLen = message.calculateEncodedLength();
        String messageLenStr = String.valueOf(messageLen);
        return messageLenStr.length() + messageLen + 1;
    }

    private void packMessage(JsMessage message, StringBuilder sb) {
        int len = message.calculateEncodedLength();
        sb.append(len).append(' ');
        message.encodeAsMessage(sb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String popAndEncode(boolean fromOnlineEvent) {
        NativeToJsMessageQueue nativeToJsMessageQueue = this;
        synchronized (nativeToJsMessageQueue) {
            block7: {
                this.registeredListeners[this.activeListenerIndex].notifyOfFlush(fromOnlineEvent);
                if (!this.queue.isEmpty()) break block7;
                return null;
            }
            int totalPayloadLen = 0;
            int numMessagesToSend = 0;
            for (JsMessage message : this.queue) {
                int messageSize = this.calculatePackedMessageLength(message);
                if (numMessagesToSend > 0 && totalPayloadLen + messageSize > MAX_PAYLOAD_SIZE && MAX_PAYLOAD_SIZE > 0) break;
                totalPayloadLen += messageSize;
                ++numMessagesToSend;
            }
            StringBuilder sb = new StringBuilder(totalPayloadLen);
            int i = 0;
            while (i < numMessagesToSend) {
                JsMessage message = this.queue.removeFirst();
                this.packMessage(message, sb);
                ++i;
            }
            if (!this.queue.isEmpty()) {
                sb.append('*');
            }
            String ret = sb.toString();
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String popAndEncodeAsJs() {
        NativeToJsMessageQueue nativeToJsMessageQueue = this;
        synchronized (nativeToJsMessageQueue) {
            block10: {
                int length = this.queue.size();
                if (length != 0) break block10;
                return null;
            }
            int totalPayloadLen = 0;
            int numMessagesToSend = 0;
            for (JsMessage message : this.queue) {
                int messageSize = message.calculateEncodedLength() + 50;
                if (numMessagesToSend > 0 && totalPayloadLen + messageSize > MAX_PAYLOAD_SIZE && MAX_PAYLOAD_SIZE > 0) break;
                totalPayloadLen += messageSize;
                ++numMessagesToSend;
            }
            boolean willSendAllMessages = numMessagesToSend == this.queue.size();
            StringBuilder sb = new StringBuilder(totalPayloadLen + (willSendAllMessages ? 0 : 100));
            int i = 0;
            while (i < numMessagesToSend) {
                JsMessage message = this.queue.removeFirst();
                if (willSendAllMessages && i + 1 == numMessagesToSend) {
                    message.encodeAsJsMessage(sb);
                } else {
                    sb.append("try{");
                    message.encodeAsJsMessage(sb);
                    sb.append("}finally{");
                }
                ++i;
            }
            if (!willSendAllMessages) {
                sb.append("window.setTimeout(function(){cordova.require('cordova/plugin/android/polling').pollOnce();},0);");
            }
            i = willSendAllMessages ? 1 : 0;
            while (i < numMessagesToSend) {
                sb.append('}');
                ++i;
            }
            String ret = sb.toString();
            return ret;
        }
    }

    public void addJavaScript(String statement) {
        this.enqueueMessage(new JsMessage(statement));
    }

    public void addPluginResult(PluginResult result, String callbackId) {
        if (callbackId == null) {
            Log.e((String)LOG_TAG, (String)"Got plugin result with no callbackId", (Throwable)new Throwable());
            return;
        }
        boolean noResult = result.getStatus() == PluginResult.Status.NO_RESULT.ordinal();
        boolean keepCallback = result.getKeepCallback();
        if (noResult && keepCallback) {
            return;
        }
        JsMessage message = new JsMessage(result, callbackId);
        this.enqueueMessage(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enqueueMessage(JsMessage message) {
        NativeToJsMessageQueue nativeToJsMessageQueue = this;
        synchronized (nativeToJsMessageQueue) {
            this.queue.add(message);
            if (!this.paused && this.registeredListeners[this.activeListenerIndex] != null) {
                this.registeredListeners[this.activeListenerIndex].onNativeToJsMessageAvailable();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPaused(boolean value) {
        if (this.paused && value) {
            Log.e((String)LOG_TAG, (String)"nested call to setPaused detected.", (Throwable)new Throwable());
        }
        this.paused = value;
        if (!value) {
            NativeToJsMessageQueue nativeToJsMessageQueue = this;
            synchronized (nativeToJsMessageQueue) {
                if (!this.queue.isEmpty() && this.registeredListeners[this.activeListenerIndex] != null) {
                    this.registeredListeners[this.activeListenerIndex].onNativeToJsMessageAvailable();
                }
            }
        }
    }

    public boolean getPaused() {
        return this.paused;
    }

    private abstract class BridgeMode {
        private BridgeMode() {
        }

        abstract void onNativeToJsMessageAvailable();

        void notifyOfFlush(boolean fromOnlineEvent) {
        }
    }

    private static class JsMessage {
        final String jsPayloadOrCallbackId;
        final PluginResult pluginResult;

        JsMessage(String js) {
            if (js == null) {
                throw new NullPointerException();
            }
            this.jsPayloadOrCallbackId = js;
            this.pluginResult = null;
        }

        JsMessage(PluginResult pluginResult, String callbackId) {
            if (callbackId == null || pluginResult == null) {
                throw new NullPointerException();
            }
            this.jsPayloadOrCallbackId = callbackId;
            this.pluginResult = pluginResult;
        }

        int calculateEncodedLength() {
            if (this.pluginResult == null) {
                return this.jsPayloadOrCallbackId.length() + 1;
            }
            int statusLen = String.valueOf(this.pluginResult.getStatus()).length();
            int ret = 2 + statusLen + 1 + this.jsPayloadOrCallbackId.length() + 1;
            switch (this.pluginResult.getMessageType()) {
                case 4: 
                case 5: {
                    ++ret;
                    break;
                }
                case 3: {
                    ret += 1 + this.pluginResult.getMessage().length();
                    break;
                }
                case 1: {
                    ret += 1 + this.pluginResult.getStrMessage().length();
                    break;
                }
                case 7: {
                    ret += 1 + this.pluginResult.getMessage().length();
                    break;
                }
                case 6: {
                    ret += 1 + this.pluginResult.getMessage().length();
                    break;
                }
                default: {
                    ret += this.pluginResult.getMessage().length();
                }
            }
            return ret;
        }

        void encodeAsMessage(StringBuilder sb) {
            if (this.pluginResult == null) {
                sb.append('J').append(this.jsPayloadOrCallbackId);
                return;
            }
            int status = this.pluginResult.getStatus();
            boolean noResult = status == PluginResult.Status.NO_RESULT.ordinal();
            boolean resultOk = status == PluginResult.Status.OK.ordinal();
            boolean keepCallback = this.pluginResult.getKeepCallback();
            sb.append(noResult || resultOk ? (char)'S' : 'F').append(keepCallback ? (char)'1' : '0').append(status).append(' ').append(this.jsPayloadOrCallbackId).append(' ');
            switch (this.pluginResult.getMessageType()) {
                case 4: {
                    sb.append(this.pluginResult.getMessage().charAt(0));
                    break;
                }
                case 5: {
                    sb.append('N');
                    break;
                }
                case 3: {
                    sb.append('n').append(this.pluginResult.getMessage());
                    break;
                }
                case 1: {
                    sb.append('s');
                    sb.append(this.pluginResult.getStrMessage());
                    break;
                }
                case 7: {
                    sb.append('S');
                    sb.append(this.pluginResult.getMessage());
                    break;
                }
                case 6: {
                    sb.append('A');
                    sb.append(this.pluginResult.getMessage());
                    break;
                }
                default: {
                    sb.append(this.pluginResult.getMessage());
                }
            }
        }

        void encodeAsJsMessage(StringBuilder sb) {
            if (this.pluginResult == null) {
                sb.append(this.jsPayloadOrCallbackId);
            } else {
                int status = this.pluginResult.getStatus();
                boolean success = status == PluginResult.Status.OK.ordinal() || status == PluginResult.Status.NO_RESULT.ordinal();
                sb.append("cordova.callbackFromNative('").append(this.jsPayloadOrCallbackId).append("',").append(success).append(",").append(status).append(",[").append(this.pluginResult.getMessage()).append("],").append(this.pluginResult.getKeepCallback()).append(");");
            }
        }
    }

    private class LoadUrlBridgeMode
    extends BridgeMode {
        final Runnable runnable = new Runnable(){

            @Override
            public void run() {
                String js = NativeToJsMessageQueue.this.popAndEncodeAsJs();
                if (js != null) {
                    NativeToJsMessageQueue.this.webView.loadUrlNow("javascript:" + js);
                }
            }
        };

        private LoadUrlBridgeMode() {
        }

        @Override
        void onNativeToJsMessageAvailable() {
            NativeToJsMessageQueue.this.cordova.getActivity().runOnUiThread(this.runnable);
        }
    }

    private class OnlineEventsBridgeMode
    extends BridgeMode {
        boolean online = false;
        final Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (!NativeToJsMessageQueue.this.queue.isEmpty()) {
                    NativeToJsMessageQueue.this.webView.setNetworkAvailable(OnlineEventsBridgeMode.this.online);
                }
            }
        };

        OnlineEventsBridgeMode() {
            NativeToJsMessageQueue.this.webView.setNetworkAvailable(true);
        }

        @Override
        void onNativeToJsMessageAvailable() {
            NativeToJsMessageQueue.this.cordova.getActivity().runOnUiThread(this.runnable);
        }

        @Override
        void notifyOfFlush(boolean fromOnlineEvent) {
            if (fromOnlineEvent) {
                this.online = !this.online;
            }
        }
    }

    private class PrivateApiBridgeMode
    extends BridgeMode {
        private static final int EXECUTE_JS = 194;
        Method sendMessageMethod;
        Object webViewCore;
        boolean initFailed;

        private PrivateApiBridgeMode() {
        }

        private void initReflection() {
            Field f2;
            Object webViewObject = NativeToJsMessageQueue.this.webView;
            Class webViewClass = WebView.class;
            try {
                f2 = webViewClass.getDeclaredField("mProvider");
                f2.setAccessible(true);
                webViewObject = f2.get((Object)NativeToJsMessageQueue.this.webView);
                webViewClass = webViewObject.getClass();
            }
            catch (Throwable f2) {
                // empty catch block
            }
            try {
                f2 = webViewClass.getDeclaredField("mWebViewCore");
                f2.setAccessible(true);
                this.webViewCore = f2.get(webViewObject);
                if (this.webViewCore != null) {
                    this.sendMessageMethod = this.webViewCore.getClass().getDeclaredMethod("sendMessage", Message.class);
                    this.sendMessageMethod.setAccessible(true);
                }
            }
            catch (Throwable e) {
                this.initFailed = true;
                Log.e((String)NativeToJsMessageQueue.LOG_TAG, (String)"PrivateApiBridgeMode failed to find the expected APIs.", (Throwable)e);
            }
        }

        @Override
        void onNativeToJsMessageAvailable() {
            if (this.sendMessageMethod == null && !this.initFailed) {
                this.initReflection();
            }
            if (this.sendMessageMethod != null) {
                String js = NativeToJsMessageQueue.this.popAndEncodeAsJs();
                Message execJsMessage = Message.obtain(null, (int)194, (Object)js);
                try {
                    this.sendMessageMethod.invoke(this.webViewCore, execJsMessage);
                }
                catch (Throwable e) {
                    Log.e((String)NativeToJsMessageQueue.LOG_TAG, (String)"Reflection message bridge failed.", (Throwable)e);
                }
            }
        }
    }
}

