/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp;

import com.squareup.okhttp.ConnectionPool;
import com.squareup.okhttp.Dispatcher;
import com.squareup.okhttp.HttpResponseCache;
import com.squareup.okhttp.OkAuthenticator;
import com.squareup.okhttp.OkResponseCache;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.RouteDatabase;
import com.squareup.okhttp.internal.Util;
import com.squareup.okhttp.internal.http.HttpAuthenticator;
import com.squareup.okhttp.internal.http.HttpURLConnectionImpl;
import com.squareup.okhttp.internal.http.HttpsURLConnectionImpl;
import com.squareup.okhttp.internal.http.OkResponseCacheAdapter;
import com.squareup.okhttp.internal.tls.OkHostnameVerifier;
import java.net.CookieHandler;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.ResponseCache;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OkHttpClient
implements URLStreamHandlerFactory {
    private static final List<String> DEFAULT_TRANSPORTS = Util.immutableList(Arrays.asList("spdy/3", "http/1.1"));
    private final RouteDatabase routeDatabase;
    private final Dispatcher dispatcher;
    private Proxy proxy;
    private List<String> transports;
    private ProxySelector proxySelector;
    private CookieHandler cookieHandler;
    private ResponseCache responseCache;
    private SSLSocketFactory sslSocketFactory;
    private HostnameVerifier hostnameVerifier;
    private OkAuthenticator authenticator;
    private ConnectionPool connectionPool;
    private boolean followProtocolRedirects = true;
    private int connectTimeout;
    private int readTimeout;

    public OkHttpClient() {
        this.routeDatabase = new RouteDatabase();
        this.dispatcher = new Dispatcher();
    }

    private OkHttpClient(OkHttpClient copyFrom) {
        this.routeDatabase = copyFrom.routeDatabase;
        this.dispatcher = copyFrom.dispatcher;
    }

    public void setConnectTimeout(long timeout, TimeUnit unit) {
        if (timeout < 0L) {
            throw new IllegalArgumentException("timeout < 0");
        }
        if (unit == null) {
            throw new IllegalArgumentException("unit == null");
        }
        long millis = unit.toMillis(timeout);
        if (millis > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Timeout too large.");
        }
        this.connectTimeout = (int)millis;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setReadTimeout(long timeout, TimeUnit unit) {
        if (timeout < 0L) {
            throw new IllegalArgumentException("timeout < 0");
        }
        if (unit == null) {
            throw new IllegalArgumentException("unit == null");
        }
        long millis = unit.toMillis(timeout);
        if (millis > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Timeout too large.");
        }
        this.readTimeout = (int)millis;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public OkHttpClient setProxy(Proxy proxy) {
        this.proxy = proxy;
        return this;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public OkHttpClient setProxySelector(ProxySelector proxySelector) {
        this.proxySelector = proxySelector;
        return this;
    }

    public ProxySelector getProxySelector() {
        return this.proxySelector;
    }

    public OkHttpClient setCookieHandler(CookieHandler cookieHandler) {
        this.cookieHandler = cookieHandler;
        return this;
    }

    public CookieHandler getCookieHandler() {
        return this.cookieHandler;
    }

    public OkHttpClient setResponseCache(ResponseCache responseCache) {
        this.responseCache = responseCache;
        return this;
    }

    public ResponseCache getResponseCache() {
        return this.responseCache;
    }

    public OkResponseCache getOkResponseCache() {
        if (this.responseCache instanceof HttpResponseCache) {
            return ((HttpResponseCache)this.responseCache).okResponseCache;
        }
        if (this.responseCache != null) {
            return new OkResponseCacheAdapter(this.responseCache);
        }
        return null;
    }

    public OkHttpClient setSslSocketFactory(SSLSocketFactory sslSocketFactory) {
        this.sslSocketFactory = sslSocketFactory;
        return this;
    }

    public SSLSocketFactory getSslSocketFactory() {
        return this.sslSocketFactory;
    }

    public OkHttpClient setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
        return this;
    }

    public HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    public OkHttpClient setAuthenticator(OkAuthenticator authenticator) {
        this.authenticator = authenticator;
        return this;
    }

    public OkAuthenticator getAuthenticator() {
        return this.authenticator;
    }

    public OkHttpClient setConnectionPool(ConnectionPool connectionPool) {
        this.connectionPool = connectionPool;
        return this;
    }

    public ConnectionPool getConnectionPool() {
        return this.connectionPool;
    }

    public OkHttpClient setFollowProtocolRedirects(boolean followProtocolRedirects) {
        this.followProtocolRedirects = followProtocolRedirects;
        return this;
    }

    public boolean getFollowProtocolRedirects() {
        return this.followProtocolRedirects;
    }

    public RouteDatabase getRoutesDatabase() {
        return this.routeDatabase;
    }

    public OkHttpClient setTransports(List<String> transports) {
        if (!(transports = Util.immutableList(transports)).contains("http/1.1")) {
            throw new IllegalArgumentException("transports doesn't contain http/1.1: " + transports);
        }
        if (transports.contains(null)) {
            throw new IllegalArgumentException("transports must not contain null");
        }
        if (transports.contains("")) {
            throw new IllegalArgumentException("transports contains an empty string");
        }
        this.transports = transports;
        return this;
    }

    public List<String> getTransports() {
        return this.transports;
    }

    void enqueue(Request request, Response.Receiver responseReceiver) {
        this.dispatcher.enqueue(this.copyWithDefaults(), request, responseReceiver);
    }

    void cancel(Object tag) {
        this.dispatcher.cancel(tag);
    }

    public HttpURLConnection open(URL url) {
        return this.open(url, this.proxy);
    }

    HttpURLConnection open(URL url, Proxy proxy) {
        String protocol = url.getProtocol();
        OkHttpClient copy = this.copyWithDefaults();
        copy.proxy = proxy;
        if (protocol.equals("http")) {
            return new HttpURLConnectionImpl(url, copy);
        }
        if (protocol.equals("https")) {
            return new HttpsURLConnectionImpl(url, copy);
        }
        throw new IllegalArgumentException("Unexpected protocol: " + protocol);
    }

    private OkHttpClient copyWithDefaults() {
        OkHttpClient result = new OkHttpClient(this);
        result.proxy = this.proxy;
        result.proxySelector = this.proxySelector != null ? this.proxySelector : ProxySelector.getDefault();
        result.cookieHandler = this.cookieHandler != null ? this.cookieHandler : CookieHandler.getDefault();
        result.responseCache = this.responseCache != null ? this.responseCache : ResponseCache.getDefault();
        result.sslSocketFactory = this.sslSocketFactory != null ? this.sslSocketFactory : HttpsURLConnection.getDefaultSSLSocketFactory();
        result.hostnameVerifier = this.hostnameVerifier != null ? this.hostnameVerifier : OkHostnameVerifier.INSTANCE;
        result.authenticator = this.authenticator != null ? this.authenticator : HttpAuthenticator.SYSTEM_DEFAULT;
        result.connectionPool = this.connectionPool != null ? this.connectionPool : ConnectionPool.getDefault();
        result.followProtocolRedirects = this.followProtocolRedirects;
        result.transports = this.transports != null ? this.transports : DEFAULT_TRANSPORTS;
        result.connectTimeout = this.connectTimeout;
        result.readTimeout = this.readTimeout;
        return result;
    }

    @Override
    public URLStreamHandler createURLStreamHandler(final String protocol) {
        if (!protocol.equals("http") && !protocol.equals("https")) {
            return null;
        }
        return new URLStreamHandler(){

            protected URLConnection openConnection(URL url) {
                return OkHttpClient.this.open(url);
            }

            protected URLConnection openConnection(URL url, Proxy proxy) {
                return OkHttpClient.this.open(url, proxy);
            }

            protected int getDefaultPort() {
                if (protocol.equals("http")) {
                    return 80;
                }
                if (protocol.equals("https")) {
                    return 443;
                }
                throw new AssertionError();
            }
        };
    }
}

