/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp.internal.spdy;

import com.squareup.okhttp.internal.Util;
import com.squareup.okhttp.internal.spdy.ErrorCode;
import com.squareup.okhttp.internal.spdy.FrameReader;
import com.squareup.okhttp.internal.spdy.FrameWriter;
import com.squareup.okhttp.internal.spdy.HeadersMode;
import com.squareup.okhttp.internal.spdy.Hpack;
import com.squareup.okhttp.internal.spdy.Settings;
import com.squareup.okhttp.internal.spdy.Variant;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.List;

final class Http20Draft06
implements Variant {
    private static final byte[] CONNECTION_HEADER;
    static final int TYPE_DATA = 0;
    static final int TYPE_HEADERS = 1;
    static final int TYPE_PRIORITY = 2;
    static final int TYPE_RST_STREAM = 3;
    static final int TYPE_SETTINGS = 4;
    static final int TYPE_PUSH_PROMISE = 5;
    static final int TYPE_PING = 6;
    static final int TYPE_GOAWAY = 7;
    static final int TYPE_WINDOW_UPDATE = 9;
    static final int TYPE_CONTINUATION = 10;
    static final int FLAG_END_STREAM = 1;
    static final int FLAG_END_HEADERS = 4;
    static final int FLAG_PRIORITY = 8;
    static final int FLAG_PONG = 1;
    static final int FLAG_END_FLOW_CONTROL = 1;

    Http20Draft06() {
    }

    public FrameReader newReader(InputStream in, boolean client) {
        return new Reader(in, client);
    }

    public FrameWriter newWriter(OutputStream out, boolean client) {
        return new Writer(out, client);
    }

    static {
        try {
            CONNECTION_HEADER = "PRI * HTTP/2.0\r\n\r\nSM\r\n\r\n".getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class Writer
    implements FrameWriter {
        private final DataOutputStream out;
        private final boolean client;
        private final ByteArrayOutputStream hpackBuffer;
        private final Hpack.Writer hpackWriter;

        Writer(OutputStream out, boolean client) {
            this.out = new DataOutputStream(out);
            this.client = client;
            this.hpackBuffer = new ByteArrayOutputStream();
            this.hpackWriter = new Hpack.Writer(this.hpackBuffer);
        }

        @Override
        public synchronized void flush() throws IOException {
            this.out.flush();
        }

        @Override
        public synchronized void connectionHeader() throws IOException {
            if (!this.client) {
                return;
            }
            this.out.write(CONNECTION_HEADER);
        }

        @Override
        public synchronized void synStream(boolean outFinished, boolean inFinished, int streamId, int associatedStreamId, int priority, int slot, List<String> nameValueBlock) throws IOException {
            if (inFinished) {
                throw new UnsupportedOperationException();
            }
            this.headers(outFinished, streamId, priority, nameValueBlock);
        }

        @Override
        public synchronized void synReply(boolean outFinished, int streamId, List<String> nameValueBlock) throws IOException {
            this.headers(outFinished, streamId, -1, nameValueBlock);
        }

        @Override
        public synchronized void headers(int streamId, List<String> nameValueBlock) throws IOException {
            this.headers(false, streamId, -1, nameValueBlock);
        }

        private void headers(boolean outFinished, int streamId, int priority, List<String> nameValueBlock) throws IOException {
            this.hpackBuffer.reset();
            this.hpackWriter.writeHeaders(nameValueBlock);
            int type = 1;
            int length = this.hpackBuffer.size();
            int flags = 4;
            if (outFinished) {
                flags |= 1;
            }
            if (priority != -1) {
                flags |= 8;
            }
            this.out.writeInt((length & 0xFFFF) << 16 | (type & 0xFF) << 8 | flags & 0xFF);
            this.out.writeInt(streamId & Integer.MAX_VALUE);
            if (priority != -1) {
                this.out.writeInt(priority & Integer.MAX_VALUE);
            }
            this.hpackBuffer.writeTo(this.out);
        }

        @Override
        public synchronized void rstStream(int streamId, ErrorCode errorCode) throws IOException {
            throw new UnsupportedOperationException("TODO");
        }

        @Override
        public void data(boolean outFinished, int streamId, byte[] data) throws IOException {
            this.data(outFinished, streamId, data, 0, data.length);
        }

        @Override
        public synchronized void data(boolean outFinished, int streamId, byte[] data, int offset, int byteCount) throws IOException {
            int type = 0;
            int flags = 0;
            if (outFinished) {
                flags |= 1;
            }
            this.out.writeInt((byteCount & 0xFFFF) << 16 | (type & 0xFF) << 8 | flags & 0xFF);
            this.out.writeInt(streamId & Integer.MAX_VALUE);
            this.out.write(data, offset, byteCount);
        }

        @Override
        public synchronized void settings(Settings settings) throws IOException {
            int type = 4;
            int length = settings.size() * 8;
            int flags = 0;
            int streamId = 0;
            this.out.writeInt((length & 0xFFFF) << 16 | (type & 0xFF) << 8 | flags & 0xFF);
            this.out.writeInt(streamId & Integer.MAX_VALUE);
            for (int i = 0; i < 10; ++i) {
                if (!settings.isSet(i)) continue;
                this.out.writeInt(i & 0xFFFFFF);
                this.out.writeInt(settings.get(i));
            }
        }

        @Override
        public synchronized void noop() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public synchronized void ping(boolean reply, int payload1, int payload2) throws IOException {
        }

        @Override
        public synchronized void goAway(int lastGoodStreamId, ErrorCode errorCode) throws IOException {
        }

        @Override
        public synchronized void windowUpdate(int streamId, int deltaWindowSize) throws IOException {
        }

        @Override
        public void close() throws IOException {
            this.out.close();
        }
    }

    static final class Reader
    implements FrameReader {
        private final DataInputStream in;
        private final boolean client;
        private final Hpack.Reader hpackReader;

        Reader(InputStream in, boolean client) {
            this.in = new DataInputStream(in);
            this.client = client;
            this.hpackReader = new Hpack.Reader(this.in, client);
        }

        public void readConnectionHeader() throws IOException {
            if (this.client) {
                return;
            }
            byte[] connectionHeader = new byte[CONNECTION_HEADER.length];
            this.in.readFully(connectionHeader);
            if (!Arrays.equals(connectionHeader, CONNECTION_HEADER)) {
                throw Reader.ioException("Expected a connection header but was " + Arrays.toString(connectionHeader), new Object[0]);
            }
        }

        public boolean nextFrame(FrameReader.Handler handler) throws IOException {
            int w1;
            try {
                w1 = this.in.readInt();
            }
            catch (IOException e) {
                return false;
            }
            int w2 = this.in.readInt();
            int length = (w1 & 0xFFFF0000) >> 16;
            int type = (w1 & 0xFF00) >> 8;
            int flags = w1 & 0xFF;
            int streamId = w2 & Integer.MAX_VALUE;
            switch (type) {
                case 0: {
                    this.readData(handler, flags, length, streamId);
                    return true;
                }
                case 1: {
                    this.readHeaders(handler, flags, length, streamId);
                    return true;
                }
                case 2: {
                    this.readPriority(handler, flags, length, streamId);
                    return true;
                }
                case 3: {
                    this.readRstStream(handler, flags, length, streamId);
                    return true;
                }
                case 4: {
                    this.readSettings(handler, flags, length, streamId);
                    return true;
                }
                case 5: {
                    this.readPushPromise(handler, flags, length, streamId);
                    return true;
                }
                case 6: {
                    this.readPing(handler, flags, length, streamId);
                    return true;
                }
                case 7: {
                    this.readGoAway(handler, flags, length, streamId);
                    return true;
                }
                case 9: {
                    this.readWindowUpdate(handler, flags, length, streamId);
                    return true;
                }
            }
            throw new UnsupportedOperationException("TODO");
        }

        private void readHeaders(FrameReader.Handler handler, int flags, int length, int streamId) throws IOException {
            int newStreamId;
            if (streamId == 0) {
                throw Reader.ioException("TYPE_HEADERS streamId == 0", new Object[0]);
            }
            boolean inFinished = (flags & 1) != 0;
            do {
                this.hpackReader.readHeaders(length);
                if ((flags & 4) != 0) {
                    this.hpackReader.emitReferenceSet();
                    List<String> namesAndValues = this.hpackReader.getAndReset();
                    int priority = -1;
                    handler.headers(false, inFinished, streamId, -1, priority, namesAndValues, HeadersMode.HTTP_20_HEADERS);
                    return;
                }
                int w1 = this.in.readInt();
                int w2 = this.in.readInt();
                length = (w1 & 0xFFFF0000) >> 16;
                int newType = (w1 & 0xFF00) >> 8;
                flags = w1 & 0xFF;
                inFinished = (flags & 1) != 0;
                newStreamId = w2 & Integer.MAX_VALUE;
                if (newType == 10) continue;
                throw Reader.ioException("TYPE_CONTINUATION didn't have FLAG_END_HEADERS", new Object[0]);
            } while (newStreamId == streamId);
            throw Reader.ioException("TYPE_CONTINUATION streamId changed", new Object[0]);
        }

        private void readData(FrameReader.Handler handler, int flags, int length, int streamId) throws IOException {
            boolean inFinished = (flags & 1) != 0;
            handler.data(inFinished, streamId, this.in, length);
        }

        private void readPriority(FrameReader.Handler handler, int flags, int length, int streamId) throws IOException {
            if (length != 4) {
                throw Reader.ioException("TYPE_PRIORITY length: %d != 4", length);
            }
            if (streamId == 0) {
                throw Reader.ioException("TYPE_PRIORITY streamId == 0", new Object[0]);
            }
            int w1 = this.in.readInt();
            int priority = w1 & Integer.MAX_VALUE;
            handler.priority(streamId, priority);
        }

        private void readRstStream(FrameReader.Handler handler, int flags, int length, int streamId) throws IOException {
            if (length != 4) {
                throw Reader.ioException("TYPE_RST_STREAM length: %d != 4", length);
            }
            if (streamId == 0) {
                throw Reader.ioException("TYPE_RST_STREAM streamId == 0", new Object[0]);
            }
            int errorCodeInt = this.in.readInt();
            ErrorCode errorCode = ErrorCode.fromHttp2(errorCodeInt);
            if (errorCode == null) {
                throw Reader.ioException("TYPE_RST_STREAM unexpected error code: %d", errorCodeInt);
            }
            handler.rstStream(streamId, errorCode);
        }

        private void readSettings(FrameReader.Handler handler, int flags, int length, int streamId) throws IOException {
            if (length % 8 != 0) {
                throw Reader.ioException("TYPE_SETTINGS length %% 8 != 0: %s", length);
            }
            if (streamId != 0) {
                throw Reader.ioException("TYPE_SETTINGS streamId != 0", new Object[0]);
            }
            Settings settings = new Settings();
            for (int i = 0; i < length; i += 8) {
                int w1 = this.in.readInt();
                int value = this.in.readInt();
                int id = w1 & 0xFFFFFF;
                settings.set(id, 0, value);
            }
            handler.settings(false, settings);
        }

        private void readPushPromise(FrameReader.Handler handler, int flags, int length, int streamId) {
        }

        private void readPing(FrameReader.Handler handler, int flags, int length, int streamId) throws IOException {
            if (length != 8) {
                throw Reader.ioException("TYPE_PING length != 8: %s", length);
            }
            if (streamId != 0) {
                throw Reader.ioException("TYPE_PING streamId != 0", new Object[0]);
            }
            int payload1 = this.in.readInt();
            int payload2 = this.in.readInt();
            boolean reply = (flags & 1) != 0;
            handler.ping(reply, payload1, payload2);
        }

        private void readGoAway(FrameReader.Handler handler, int flags, int length, int streamId) throws IOException {
            if (length < 8) {
                throw Reader.ioException("TYPE_GOAWAY length < 8: %s", length);
            }
            int lastStreamId = this.in.readInt();
            int errorCodeInt = this.in.readInt();
            int opaqueDataLength = length - 8;
            ErrorCode errorCode = ErrorCode.fromHttp2(errorCodeInt);
            if (errorCode == null) {
                throw Reader.ioException("TYPE_RST_STREAM unexpected error code: %d", errorCodeInt);
            }
            if (Util.skipByReading(this.in, opaqueDataLength) != (long)opaqueDataLength) {
                throw new IOException("TYPE_GOAWAY opaque data was truncated");
            }
            handler.goAway(lastStreamId, errorCode);
        }

        private void readWindowUpdate(FrameReader.Handler handler, int flags, int length, int streamId) throws IOException {
            int w1 = this.in.readInt();
            int windowSizeIncrement = w1 & Integer.MAX_VALUE;
            boolean endFlowControl = (flags & 1) != 0;
            handler.windowUpdate(streamId, windowSizeIncrement, endFlowControl);
        }

        private static IOException ioException(String message, Object ... args) throws IOException {
            throw new IOException(String.format(message, args));
        }

        public void close() throws IOException {
            this.in.close();
        }
    }
}

