<?php
/**
 *  Snazzy Maps
 *
 * @description: Contains the snazzy maps JSON array
 * @since      :
 * @created    : 4/18/14
 */

?>
[
   {
      "id":1,
      "name":"Pale Dawn",
      "description":"Inspired by CloudMade's style of the same name. Use of subdued colours results in an excellent style for sites with a pastel colour scheme.",
      "url":"http://snazzymaps.com/style/1/pale-dawn",
      "json":"[  { 'featureType': 'water', 'stylers': [{ 'visibility': 'on' },{ 'color': '#acbcc9' } ]  },{ 'featureType': 'landscape', 'stylers': [{ 'color': '#f2e5d4' } ]  },{ 'featureType': 'road.highway', 'elementType': 'geometry', 'stylers': [{ 'color': '#c5c6c6' } ]  },{ 'featureType': 'road.arterial', 'elementType': 'geometry', 'stylers': [{ 'color': '#e4d7c6' } ]  },{ 'featureType': 'road.local', 'elementType': 'geometry', 'stylers': [{ 'color': '#fbfaf7' } ]  },{ 'featureType': 'poi.park', 'elementType': 'geometry', 'stylers': [{ 'color': '#c5dac6' } ]  },{ 'featureType': 'administrative', 'stylers': [{ 'visibility': 'on' },{ 'lightness': 33 } ]  },{ 'featureType': 'road'  },{ 'featureType': 'poi.park', 'elementType': 'labels', 'stylers': [{ 'visibility': 'on' },{ 'lightness': 20 } ]  },{  },{ 'featureType': 'road', 'stylers': [{ 'lightness': 20 } ]  }]",
      "views":18287,
      "createdBy":{
         "name":"Adam Krogh",
         "url":"http://atmist.com"
      },
      "createdOn":"2013-10-24T22:54:34.183"
   },
   {
      "id":15,
      "name":"Subtle Grayscale",
      "description":"A nice, simple grayscale version of the map with color extremes that are never too harsh on the eyes. Originally created for http://barvinssurvins.fr/situer.",
      "url":"http://snazzymaps.com/style/15/subtle-grayscale",
      "json":"[\r\n    {\r\n      featureType: \"landscape\",\r\n      stylers: [\r\n        { saturation: -100 },\r\n        { lightness: 65 },\r\n        { visibility: \"on\" }\r\n      ]\r\n    },{\r\n      featureType: \"poi\",\r\n      stylers: [\r\n        { saturation: -100 },\r\n        { lightness: 51 },\r\n        { visibility: \"simplified\" }\r\n      ]\r\n    },{\r\n      featureType: \"road.highway\",\r\n      stylers: [\r\n        { saturation: -100 },\r\n        { visibility: \"simplified\" }\r\n      ]\r\n    },{\r\n      featureType: \"road.arterial\",\r\n      stylers: [\r\n        { saturation: -100 },\r\n        { lightness: 30 },\r\n        { visibility: \"on\" }\r\n      ]\r\n    },{\r\n      featureType: \"road.local\",\r\n      stylers: [\r\n        { saturation: -100 },\r\n        { lightness: 40 },\r\n        { visibility: \"on\" }\r\n      ]\r\n    },{\r\n      featureType: \"transit\",\r\n      stylers: [\r\n        { saturation: -100 },\r\n        { visibility: \"simplified\" }\r\n      ]\r\n    },{\r\n      featureType: \"administrative.province\",\r\n      stylers: [\r\n        { visibility: \"off\" }\r\n      ]\r\n  /** /\r\n    },{\r\n      featureType: \"administrative.locality\",\r\n      stylers: [\r\n        { visibility: \"off\" }\r\n      ]\r\n    },{\r\n      featureType: \"administrative.neighborhood\",\r\n      stylers: [\r\n        { visibility: \"on\" }\r\n      ]\r\n  /**/\r\n    },{\r\n      featureType: \"water\",\r\n      elementType: \"labels\",\r\n      stylers: [\r\n        { visibility: \"on\" },\r\n        { lightness: -25 },\r\n        { saturation: -100 }\r\n      ]\r\n    },{\r\n      featureType: \"water\",\r\n      elementType: \"geometry\",\r\n      stylers: [\r\n        { hue: \"#ffff00\" },\r\n        { lightness: -25 },\r\n        { saturation: -97 }\r\n      ]\r\n    }\r\n  ]",
      "views":17497,
      "createdBy":{
         "name":"Paulo Ávila",
         "url":"https://github.com/demoive/"
      },
      "createdOn":"2013-10-30T16:37:24.593"
   },
   {
      "id":25,
      "name":"Blue water",
      "description":"A simple map with blue water and roads/landscape in grayscale. ",
      "url":"http://snazzymaps.com/style/25/blue-water",
      "json":"[\r\n\t{\r\n\t\tfeatureType: 'water',\r\n\t\tstylers: [{color:'#46bcec'},{visibility:'on'}]\r\n\t},{\r\n\t\tfeatureType: 'landscape',\r\n\t\tstylers: [{color:'#f2f2f2'}]\r\n\t},{\r\n\t\tfeatureType: 'road',\r\n\t\tstylers: [{saturation: -100},{lightness: 45}]\r\n\t},{\r\n\t\tfeatureType: 'road.highway',\r\n\t\tstylers: [{visibility: 'simplified'}]\r\n\t},{\r\n\t\tfeatureType: 'road.arterial',\r\n\t\telementType: 'labels.icon',\r\n\t\tstylers: [{visibility: 'off'}]\r\n\t},{\r\n\t\tfeatureType: 'administrative',\r\n\t\telementType: 'labels.text.fill',\r\n\t\tstylers: [{color: '#444444'}]\r\n\t},{\r\n\t\tfeatureType: 'transit',\r\n\t\tstylers: [{visibility: 'off'}]\r\n\t},{\r\n\t\tfeatureType: 'poi',\r\n\t\tstylers: [{visibility: 'off'}]\r\n\t}\r\n]",
      "views":11476,
      "createdBy":{
         "name":"Xavier",
         "url":"http://www.xavierfoucrier.fr"
      },
      "createdOn":"2013-11-05T16:09:45.02"
   },
   {
      "id":2,
      "name":"Midnight Commander",
      "description":"Inspired by CloudMade's style of the same name. A dark use of water and 'Tron' like colours results in a very unique style.",
      "url":"http://snazzymaps.com/style/2/midnight-commander",
      "json":"[{'featureType': 'water','stylers': [{ 'color': '#021019' }]},{'featureType': 'landscape','stylers': [{ 'color': '#08304b' }]},{'featureType': 'poi','elementType': 'geometry','stylers': [{ 'color': '#0c4152' },{ 'lightness': 5 }]},{'featureType': 'road.highway','elementType': 'geometry.fill','stylers': [{ 'color': '#000000' }]},{'featureType': 'road.highway','elementType': 'geometry.stroke','stylers': [{ 'color': '#0b434f' },{ 'lightness': 25 }]},{'featureType': 'road.arterial','elementType': 'geometry.fill','stylers': [{ 'color': '#000000' }]},{'featureType': 'road.arterial','elementType': 'geometry.stroke','stylers': [{ 'color': '#0b3d51' },{ 'lightness': 16 }]},{'featureType': 'road.local','elementType': 'geometry','stylers': [{ 'color': '#000000' }]},{'elementType': 'labels.text.fill','stylers': [{ 'color': '#ffffff' }]},{'elementType': 'labels.text.stroke','stylers': [{ 'color': '#000000' },{ 'lightness': 13 }]},{'featureType': 'transit','stylers': [{ 'color': '#146474' }]},{'featureType': 'administrative','elementType': 'geometry.fill','stylers': [{ 'color': '#000000' }]},{'featureType': 'administrative','elementType': 'geometry.stroke','stylers': [{ 'color': '#144b53' },{ 'lightness': 14 },{ 'weight': 1.4 }]}]",
      "views":8783,
      "createdBy":{
         "name":"Adam Krogh",
         "url":"http://atmist.com"
      },
      "createdOn":"2013-10-24T22:54:36.037"
   },
   {
      "id":18,
      "name":"Retro",
      "description":"A retro style map from Google that has a ton of detail. Looks great zoomed in on a city with lots of features.",
      "url":"http://snazzymaps.com/style/18/retro",
      "json":"[{featureType:\"administrative\",stylers:[{visibility:\"off\"}]},\r\n{featureType:\"poi\",stylers:[{visibility:\"simplified\"}]},{featureType:\"road\",elementType:\"labels\",stylers:[{visibility:\"simplified\"}]},{featureType:\"water\",stylers:[{visibility:\"simplified\"}]},{featureType:\"transit\",stylers:[{visibility:\"simplified\"}]},{featureType:\"landscape\",stylers:[{visibility:\"simplified\"}]},{featureType:\"road.highway\",stylers:[{visibility:\"off\"}]},{featureType:\"road.local\",stylers:[{visibility:\"on\"}]},{featureType:\"road.highway\",elementType:\"geometry\",stylers:[{visibility:\"on\"}]},\r\n{featureType:\"water\",stylers:[{color:\"#84afa3\"},{lightness:52}]},{stylers:[{saturation:-17},{gamma:0.36}]},{featureType:\"transit.line\",elementType:\"geometry\",stylers:[{color:\"#3f518c\"}] }]",
      "views":8041,
      "createdBy":{
         "name":"Google",
         "url":"https://embed-dot-more-than-a-map.appspot.com/demos/basemaps/sydney"
      },
      "createdOn":"2013-10-31T15:05:56.073"
   },
   {
      "id":38,
      "name":"Shades of Grey",
      "description":"A map with various shades of grey. Great for a website with a really dark theme. ",
      "url":"http://snazzymaps.com/style/38/shades-of-grey",
      "json":"[\r\n  {\r\n    \"featureType\": \"water\",\r\n    \"elementType\": \"geometry\",\r\n    \"stylers\": [\r\n      { \"color\": \"#000000\" },\r\n      { \"lightness\": 17 }\r\n    ]\r\n  },{\r\n    \"featureType\": \"landscape\",\r\n    \"elementType\": \"geometry\",\r\n    \"stylers\": [\r\n      { \"color\": \"#000000\" },\r\n      { \"lightness\": 20 }\r\n    ]\r\n  },{\r\n    \"featureType\": \"road.highway\",\r\n    \"elementType\": \"geometry.fill\",\r\n    \"stylers\": [\r\n      { \"color\": \"#000000\" },\r\n      { \"lightness\": 17 }\r\n    ]\r\n  },{\r\n    \"featureType\": \"road.highway\",\r\n    \"elementType\": \"geometry.stroke\",\r\n    \"stylers\": [\r\n      { \"color\": \"#000000\" },\r\n      { \"lightness\": 29 },\r\n      { \"weight\": 0.2 }\r\n    ]\r\n  },{\r\n    \"featureType\": \"road.arterial\",\r\n    \"elementType\": \"geometry\",\r\n    \"stylers\": [\r\n      { \"color\": \"#000000\" },\r\n      { \"lightness\": 18 }\r\n    ]\r\n  },{\r\n    \"featureType\": \"road.local\",\r\n    \"elementType\": \"geometry\",\r\n    \"stylers\": [\r\n      { \"color\": \"#000000\" },\r\n      { \"lightness\": 16 }\r\n    ]\r\n  },{\r\n    \"featureType\": \"poi\",\r\n    \"elementType\": \"geometry\",\r\n    \"stylers\": [\r\n      { \"color\": \"#000000\" },\r\n      { \"lightness\": 21 }\r\n    ]\r\n  },{\r\n    \"elementType\": \"labels.text.stroke\",\r\n    \"stylers\": [\r\n      { \"visibility\": \"on\" },\r\n      { \"color\": \"#000000\" },\r\n      { \"lightness\": 16 }\r\n    ]\r\n  },{\r\n    \"elementType\": \"labels.text.fill\",\r\n    \"stylers\": [\r\n      { \"saturation\": 36 },\r\n      { \"color\": \"#000000\" },\r\n      { \"lightness\": 40 }\r\n    ]\r\n  },{\r\n    \"elementType\": \"labels.icon\",\r\n    \"stylers\": [\r\n      { \"visibility\": \"off\" }\r\n    ]\r\n  },{\r\n    \"featureType\": \"transit\",\r\n    \"elementType\": \"geometry\",\r\n    \"stylers\": [\r\n      { \"color\": \"#000000\" },\r\n      { \"lightness\": 19 }\r\n    ]\r\n  },{\r\n    \"featureType\": \"administrative\",\r\n    \"elementType\": \"geometry.fill\",\r\n    \"stylers\": [\r\n      { \"color\": \"#000000\" },\r\n      { \"lightness\": 20 }\r\n    ]\r\n  },{\r\n    \"featureType\": \"administrative\",\r\n    \"elementType\": \"geometry.stroke\",\r\n    \"stylers\": [\r\n      { \"color\": \"#000000\" },\r\n      { \"lightness\": 17 },\r\n      { \"weight\": 1.2 }\r\n    ]\r\n  }\r\n]",
      "views":7532,
      "createdBy":{
         "name":"Adam Krogh",
         "url":"http://atmist.com"
      },
      "createdOn":"2013-11-12T18:21:41.94"
   },
   {
      "id":20,
      "name":"Gowalla",
      "description":"Style as used on the Gowalla (RIP) website, one of the first larger projects to have used custom styled maps. Subtle changes to the water and road color combined with reduced features creates an excellent simplified map style.",
      "url":"http://snazzymaps.com/style/20/gowalla",
      "json":"[\t\t\r\n\t{\r\n\t\tfeatureType: \"road\",\r\n\t\telementType: \"labels\",\r\n\t\tstylers: [ { visibility: \"simplified\" }, { lightness: 20 } ]\r\n\t},{\r\n\t\tfeatureType: \"administrative.land_parcel\",\r\n\t\telementType: \"all\",\r\n\t\tstylers: [ { visibility: \"off\" } ]\r\n\t},{\r\n\t\tfeatureType: \"landscape.man_made\",\r\n\t\telementType: \"all\",\r\n\t\tstylers: [ { visibility: \"off\" } ]\r\n\t},{\r\n\t\tfeatureType: \"transit\",\r\n\t\telementType: \"all\",\r\n\t\tstylers: [ { visibility: \"off\" } ]\r\n\t},{\r\n\t\tfeatureType: \"road.local\",\r\n\t\telementType: \"labels\",\r\n\t\tstylers: [ { visibility: \"simplified\" } ]\r\n\t},{\r\n\t\tfeatureType: \"road.local\",\r\n\t\telementType: \"geometry\",\r\n\t\tstylers: [ { visibility: \"simplified\" } ]\r\n\t},{\r\n\t\tfeatureType: \"road.highway\",\r\n\t\telementType: \"labels\",\r\n\t\tstylers: [ { visibility: \"simplified\" } ]\r\n\t},{\r\n\t\tfeatureType: \"poi\",\r\n\t\telementType: \"labels\",\r\n\t\tstylers: [ { visibility: \"off\" } ]\r\n    },{\r\n\t\tfeatureType: \"road.arterial\",\r\n\t\telementType: \"labels\",\r\n\t\tstylers: [ { visibility: \"off\" } ]\r\n\t},{\r\n\t\tfeatureType: \"water\",\r\n\t\telementType: \"all\",\r\n\t\tstylers: [ { hue: \"#a1cdfc\" },{ saturation: 30 },{ lightness: 49 } ]\r\n\t},{\r\n\t\tfeatureType: \"road.highway\",\r\n\t\telementType: \"geometry\",\r\n\t\tstylers: [ { hue: \"#f49935\" } ]\r\n\t},{\r\n\t\tfeatureType: \"road.arterial\",\r\n\t\telementType: \"geometry\",\r\n\t\tstylers: [ { hue: \"#fad959\" } ]\r\n\t}\r\n]",
      "views":5500,
      "createdBy":{
         "name":"Bramus",
         "url":"http://www.bram.us/"
      },
      "createdOn":"2013-11-02T18:13:19.54"
   },
   {
      "id":29,
      "name":"Light Monochrome",
      "description":"This map style was created for the Streng Design & Advertising website redesign. Used primary as a design element, it needed to be light and subtle but still recognizable.",
      "url":"http://snazzymaps.com/style/29/light-monochrome",
      "json":"[\r\n\t\t\t\t{\r\n\t\t\t\t\tfeatureType: 'water',\r\n\t\t\t\t\telementType: 'all',\r\n\t\t\t\t\tstylers: [\r\n\t\t\t\t\t\t{ hue: '#e9ebed' },\r\n\t\t\t\t\t\t{ saturation: -78 },\r\n\t\t\t\t\t\t{ lightness: 67 },\r\n\t\t\t\t\t\t{ visibility: 'simplified' }\r\n\t\t\t\t\t]\r\n\t\t\t\t},{\r\n\t\t\t\t\tfeatureType: 'landscape',\r\n\t\t\t\t\telementType: 'all',\r\n\t\t\t\t\tstylers: [\r\n\t\t\t\t\t\t{ hue: '#ffffff' },\r\n\t\t\t\t\t\t{ saturation: -100 },\r\n\t\t\t\t\t\t{ lightness: 100 },\r\n\t\t\t\t\t\t{ visibility: 'simplified' }\r\n\t\t\t\t\t]\r\n\t\t\t\t},{\r\n\t\t\t\t\tfeatureType: 'road',\r\n\t\t\t\t\telementType: 'geometry',\r\n\t\t\t\t\tstylers: [\r\n\t\t\t\t\t\t{ hue: '#bbc0c4' },\r\n\t\t\t\t\t\t{ saturation: -93 },\r\n\t\t\t\t\t\t{ lightness: 31 },\r\n\t\t\t\t\t\t{ visibility: 'simplified' }\r\n\t\t\t\t\t]\r\n\t\t\t\t},{\r\n\t\t\t\t\tfeatureType: 'poi',\r\n\t\t\t\t\telementType: 'all',\r\n\t\t\t\t\tstylers: [\r\n\t\t\t\t\t\t{ hue: '#ffffff' },\r\n\t\t\t\t\t\t{ saturation: -100 },\r\n\t\t\t\t\t\t{ lightness: 100 },\r\n\t\t\t\t\t\t{ visibility: 'off' }\r\n\t\t\t\t\t]\r\n\t\t\t\t},{\r\n\t\t\t\t\tfeatureType: 'road.local',\r\n\t\t\t\t\telementType: 'geometry',\r\n\t\t\t\t\tstylers: [\r\n\t\t\t\t\t\t{ hue: '#e9ebed' },\r\n\t\t\t\t\t\t{ saturation: -90 },\r\n\t\t\t\t\t\t{ lightness: -8 },\r\n\t\t\t\t\t\t{ visibility: 'simplified' }\r\n\t\t\t\t\t]\r\n\t\t\t\t},{\r\n\t\t\t\t\tfeatureType: 'transit',\r\n\t\t\t\t\telementType: 'all',\r\n\t\t\t\t\tstylers: [\r\n\t\t\t\t\t\t{ hue: '#e9ebed' },\r\n\t\t\t\t\t\t{ saturation: 10 },\r\n\t\t\t\t\t\t{ lightness: 69 },\r\n\t\t\t\t\t\t{ visibility: 'on' }\r\n\t\t\t\t\t]\r\n\t\t\t\t},{\r\n\t\t\t\t\tfeatureType: 'administrative.locality',\r\n\t\t\t\t\telementType: 'all',\r\n\t\t\t\t\tstylers: [\r\n\t\t\t\t\t\t{ hue: '#2c2e33' },\r\n\t\t\t\t\t\t{ saturation: 7 },\r\n\t\t\t\t\t\t{ lightness: 19 },\r\n\t\t\t\t\t\t{ visibility: 'on' }\r\n\t\t\t\t\t]\r\n\t\t\t\t},{\r\n\t\t\t\t\tfeatureType: 'road',\r\n\t\t\t\t\telementType: 'labels',\r\n\t\t\t\t\tstylers: [\r\n\t\t\t\t\t\t{ hue: '#bbc0c4' },\r\n\t\t\t\t\t\t{ saturation: -93 },\r\n\t\t\t\t\t\t{ lightness: 31 },\r\n\t\t\t\t\t\t{ visibility: 'on' }\r\n\t\t\t\t\t]\r\n\t\t\t\t},{\r\n\t\t\t\t\tfeatureType: 'road.arterial',\r\n\t\t\t\t\telementType: 'labels',\r\n\t\t\t\t\tstylers: [\r\n\t\t\t\t\t\t{ hue: '#bbc0c4' },\r\n\t\t\t\t\t\t{ saturation: -93 },\r\n\t\t\t\t\t\t{ lightness: -2 },\r\n\t\t\t\t\t\t{ visibility: 'simplified' }\r\n\t\t\t\t\t]\r\n\t\t\t\t}\r\n\t\t\t]",
      "views":5148,
      "createdBy":{
         "name":"Derrik Engel",
         "url":"http://www.strengdesign.com"
      },
      "createdOn":"2013-11-07T15:16:34.433"
   },
   {
      "id":39,
      "name":"Paper",
      "description":"A light theme with an excellent contrast between water, parks, and land.",
      "url":"http://snazzymaps.com/style/39/paper",
      "json":"[{featureType:\"administrative\",stylers:[{visibility:\"off\"}]},{featureType:\"poi\",stylers:[{visibility:\"simplified\"}]},{featureType:\"road\",stylers:[{visibility:\"simplified\"}]},{featureType:\"water\",stylers:[{visibility:\"simplified\"}]},{featureType:\"transit\",stylers:[{visibility:\"simplified\"}]},{featureType:\"landscape\",stylers:[{visibility:\"simplified\"}]},{featureType:\"road.highway\",stylers:[{visibility:\"off\"}]},\r\n{featureType:\"road.local\",stylers:[{visibility:\"on\"}]},{featureType:\"road.highway\",elementType:\"geometry\",stylers:[{visibility:\"on\"}]},{featureType:\"road.arterial\",stylers:[{visibility:\"off\"}]},{featureType:\"water\",stylers:[{color:\"#5f94ff\"},{lightness:26},{gamma:5.86}]},{},{featureType:\"road.highway\",stylers:[{weight:0.6},{saturation:-85},{lightness:61}]},{featureType:\"road\"},{},{featureType:\"landscape\",stylers:[{hue:\"#0066ff\"},{saturation:74},{lightness:100}]}]",
      "views":4728,
      "createdBy":{
         "name":"Google",
         "url":"https://embed-dot-more-than-a-map.appspot.com/demos/basemaps/san-francisco"
      },
      "createdOn":"2013-11-19T02:52:19.577"
   },
   {
      "id":5,
      "name":"Greyscale",
      "description":"Example provided by Google showcasing their style API. A really cool greyscale colour scheme that looks great when zoomed in.",
      "url":"http://snazzymaps.com/style/5/greyscale",
      "json":"[{    featureType: 'all',  stylers: [{saturation: -100},{gamma: 0.50}  ]}  ]",
      "views":4705,
      "createdBy":{
         "name":"Google",
         "url":"http://maps-api-tt.appspot.com/apilite/styled/styled.html"
      },
      "createdOn":"2013-10-24T22:54:39.703"
   },
   {
      "id":19,
      "name":"Subtle",
      "description":"A subtle and simple map style perfect for productions using colourful markers, pins or polygons.",
      "url":"http://snazzymaps.com/style/19/subtle",
      "json":"[\r\n\t{\r\n\t\t\"featureType\": \"poi\",\r\n\t\t\"stylers\": [\r\n\t\t\t{ \"visibility\": \"off\" }\r\n\t\t]\r\n\t},{\r\n\t\t\"stylers\": [\r\n\t\t\t{ \"saturation\": -70 },\r\n\t\t\t{ \"lightness\": 37 },\r\n\t\t\t{ \"gamma\": 1.15 }\r\n\t\t]\r\n\t},{\r\n\t\t\"elementType\": \"labels\",\r\n\t\t\"stylers\": [\r\n\t\t\t{ \"gamma\": 0.26 },\r\n\t\t\t{ \"visibility\": \"off\" }\r\n\t\t]\r\n\t},{\r\n\t\t\"featureType\": \"road\",\r\n\t\t\"stylers\": [\r\n\t\t\t{ \"lightness\": 0 },\r\n\t\t\t{ \"saturation\": 0 },\r\n\t\t\t{ \"hue\": \"#ffffff\" },\r\n\t\t\t{ \"gamma\": 0 }\r\n\t\t]\r\n\t},{\r\n\t\t\"featureType\": \"road\",\r\n\t\t\"elementType\": \"labels.text.stroke\",\r\n\t\t\"stylers\": [\r\n\t\t\t{ \"visibility\": \"off\" }\r\n\t\t]\r\n\t},{\r\n\t\t\"featureType\": \"road.arterial\",\r\n\t\t\"elementType\": \"geometry\",\r\n\t\t\"stylers\": [\r\n\t\t\t{ \"lightness\": 20 }\r\n\t\t]\r\n\t},{\r\n\t\t\"featureType\": \"road.highway\",\r\n\t\t\"elementType\": \"geometry\",\r\n\t\t\"stylers\": [\r\n\t\t\t{ \"lightness\": 50 },\r\n\t\t\t{ \"saturation\": 0 },\r\n\t\t\t{ \"hue\": \"#ffffff\" }\r\n\t\t]\r\n\t},{\r\n\t\t\"featureType\": \"administrative.province\",\r\n\t\t\"stylers\": [\r\n\t\t\t{ \"visibility\": \"on\" },\r\n\t\t\t{ \"lightness\": -50 }\r\n\t\t]\r\n\t},{\r\n\t\t\"featureType\": \"administrative.province\",\r\n\t\t\"elementType\": \"labels.text.stroke\",\r\n\t\t\"stylers\": [\r\n\t\t\t{ \"visibility\": \"off\" }\r\n\t\t]\r\n\t},{\r\n\t\t\"featureType\": \"administrative.province\",\r\n\t\t\"elementType\": \"labels.text\",\r\n\t\t\"stylers\": [\r\n\t\t\t{ \"lightness\": 20 }\r\n\t\t]\r\n\t}  \r\n]",
      "views":4499,
      "createdBy":{
         "name":"Søren Larsen Pedersen",
         "url":"http://www.larsenpedersen.com"
      },
      "createdOn":"2013-11-01T02:30:59.14"
   },
   {
      "id":13,
      "name":"Neutral Blue",
      "description":"A variety of deep blue colors provides great contrast whether you are zoomed out looking at countries or zoomed right in on specific roads. ",
      "url":"http://snazzymaps.com/style/13/neutral-blue",
      "json":"[{\"featureType\": \"water\",\"elementType\": \"geometry\",\"stylers\": [{ \"color\": \"#193341\" }]},{\"featureType\": \"landscape\",\"elementType\": \"geometry\",\"stylers\": [{ \"color\": \"#2c5a71\" }]},{\"featureType\": \"road\",\"elementType\": \"geometry\",\"stylers\": [{ \"color\": \"#29768a\" },{ \"lightness\": -37 }]},{\"featureType\": \"poi\",\"elementType\": \"geometry\",\"stylers\": [{ \"color\": \"#406d80\" }]},{\"featureType\": \"transit\",\"elementType\": \"geometry\",\"stylers\": [{ \"color\": \"#406d80\" }]},{\"elementType\": \"labels.text.stroke\",\"stylers\": [{ \"visibility\": \"on\" },{ \"color\": \"#3e606f\" },{ \"weight\": 2 },{ \"gamma\": 0.84 }]},{\"elementType\": \"labels.text.fill\",\"stylers\": [{ \"color\": \"#ffffff\" }]},{\"featureType\": \"administrative\",\"elementType\": \"geometry\",\"stylers\": [{ \"weight\": 0.6 },{ \"color\": \"#1a3541\" }]},{\"elementType\": \"labels.icon\",\"stylers\": [{ \"visibility\": \"off\" }]},{\"featureType\": \"poi.park\",\"elementType\": \"geometry\",\"stylers\": [{ \"color\": \"#2c5a71\" }]}]",
      "views":4050,
      "createdBy":{
         "name":"Adam Krogh",
         "url":"http://atmist.com"
      },
      "createdOn":"2013-10-30T04:22:53.393"
   },
   {
      "id":42,
      "name":"Apple Maps-esque",
      "description":"A theme that largely resembles the Apple Maps theme, albeit somewhat flatter.",
      "url":"http://snazzymaps.com/style/42/apple-maps-esque",
      "json":"[\r\n\r\n    // WATER\r\n\r\n    {\r\n      featureType: 'water',\r\n      elementType: 'geometry',\r\n      stylers: [{\r\n        color: '#a2daf2'\r\n      }]\r\n    },\r\n\r\n    // LANDSCAPE\r\n\r\n    {\r\n      featureType: 'landscape.man_made',\r\n      elementType: 'geometry',\r\n      stylers: [{\r\n        color: '#f7f1df'\r\n      }]\r\n    },\r\n\r\n    {\r\n      featureType: 'landscape.natural',\r\n      elementType: 'geometry',\r\n      stylers: [{\r\n        color: '#d0e3b4'\r\n      }]\r\n    },\r\n\r\n    {\r\n      featureType: 'landscape.natural.terrain',\r\n      elementType: 'geometry',\r\n      stylers: [{\r\n        visibility: 'off'\r\n      }]\r\n    },\r\n\r\n    // POINTS OF INTEREST\r\n\r\n    {\r\n      featureType: 'poi.park',\r\n      elementType: 'geometry',\r\n      stylers: [{\r\n        color: '#bde6ab'\r\n      }]\r\n    },\r\n\r\n    {\r\n      featureType: 'poi',\r\n      elementType: 'labels',\r\n      stylers: [{\r\n        visibility: 'off'\r\n      }]\r\n    },\r\n\r\n    {\r\n      featureType: 'poi.medical',\r\n      elementType: 'geometry',\r\n      stylers: [{\r\n        color: '#fbd3da'\r\n      }]\r\n    },\r\n\r\n    {\r\n      featureType: 'poi.business',\r\n      stylers: [{\r\n        visibility: 'off'\r\n      }]\r\n    },\r\n\r\n    // ROADS\r\n\r\n    {\r\n      featureType: 'road',\r\n      elementType: 'geometry.stroke',\r\n      stylers: [{\r\n        visibility: 'off'\r\n      }]\r\n    },\r\n\r\n    {\r\n      featureType: 'road',\r\n      elementType: 'labels',\r\n      stylers: [{\r\n        visibility: 'off'\r\n      }]\r\n    },\r\n\r\n    {\r\n      featureType: 'road.highway',\r\n      elementType: 'geometry.fill',\r\n      stylers: [{\r\n        color: '#ffe15f'\r\n      }]\r\n    },\r\n\r\n    {\r\n      featureType: 'road.highway',\r\n      elementType: 'geometry.stroke',\r\n      stylers: [{\r\n        color: '#efd151'\r\n      }]\r\n    },\r\n\r\n    {\r\n      featureType: 'road.arterial',\r\n      elementType: 'geometry.fill',\r\n      stylers: [{\r\n        color: '#ffffff'\r\n      }]\r\n    },\r\n\r\n    {\r\n      featureType: 'road.local',\r\n      elementType: 'geometry.fill',\r\n      stylers: [{\r\n        color: 'black'\r\n      }]\r\n    },\r\n\r\n    // TRANSIT\r\n\r\n    {\r\n      featureType: 'transit.station.airport',\r\n      elementType: 'geometry.fill',\r\n      stylers: [{\r\n        color: '#cfb2db'\r\n      }]\r\n    }\r\n\r\n  ]",
      "views":3629,
      "createdBy":{
         "name":"Mike Fowler",
         "url":"http://mikefowler.me"
      },
      "createdOn":"2013-11-20T17:57:23.553"
   },
   {
      "id":27,
      "name":"Shift Worker",
      "description":"Almost grey scale, this style uses subdued tones to display streets with a minimum of distractions. Best used around zoom level 16 to show a local address.",
      "url":"http://snazzymaps.com/style/27/shift-worker",
      "json":"[\r\n  { stylers: [{ saturation: -100 }, { gamma: 1 }] },\r\n  { elementType: \"labels.text.stroke\", stylers: [{ visibility: \"off\" }] },\r\n  { featureType: \"poi.business\", elementType: \"labels.text\", stylers: [{ visibility: \"off\" }] },\r\n  { featureType: \"poi.business\", elementType: \"labels.icon\", stylers: [{ visibility: \"off\" }] },\r\n  { featureType: \"poi.place_of_worship\", elementType: \"labels.text\", stylers: [{ visibility: \"off\" }] },\r\n  { featureType: \"poi.place_of_worship\", elementType: \"labels.icon\", stylers: [{ visibility: \"off\" }] },\r\n  { featureType: \"road\", elementType: \"geometry\", stylers: [{ visibility: \"simplified\" }] },\r\n  { featureType: \"water\", stylers: [{ visibility: \"on\" }, { saturation: 50 }, { gamma: 0 }, { hue: \"#50a5d1\" }] },\r\n  { featureType: \"administrative.neighborhood\", elementType: \"labels.text.fill\", stylers: [{ color: \"#333333\" }] },\r\n  { featureType: \"road.local\", elementType: \"labels.text\", stylers: [{ weight: 0.5 }, { color: \"#333333\" }] },\r\n  { featureType: \"transit.station\", elementType: \"labels.icon\", stylers: [{ gamma: 1 }, { saturation: 50 }] }\r\n]",
      "views":3480,
      "createdBy":{
         "name":"The Factory",
         "url":"http://workthefactory.com/"
      },
      "createdOn":"2013-11-07T15:14:38.813"
   },
   {
      "id":17,
      "name":"Bright & Bubbly",
      "description":"A fun and lively color scheme to match a company's new brand. Very bright colors for the bodies of water to make them stand out - particularly good for lakes and rivers when zoomed into the city detail level. Many \"Points of Interest\" are hidden in order to not clutter the map since custom landmarks and markers are used to highlight the company's own items.",
      "url":"http://snazzymaps.com/style/17/bright-and-bubbly",
      "json":"[\r\n        {\r\n            \"featureType\": \"water\",\r\n            \"stylers\": [\r\n                {\r\n                    \"color\": \"#19a0d8\"\r\n                }\r\n            ]\r\n        },\r\n        {\r\n            \"featureType\": \"administrative\",\r\n            \"elementType\": \"labels.text.stroke\",\r\n            \"stylers\": [\r\n                {\r\n                    \"color\": \"#ffffff\"\r\n                },\r\n                {\r\n                    \"weight\": 6\r\n                }\r\n            ]\r\n        },\r\n        {\r\n            \"featureType\": \"administrative\",\r\n            \"elementType\": \"labels.text.fill\",\r\n            \"stylers\": [\r\n                {\r\n                    \"color\": \"#e85113\"\r\n                }\r\n            ]\r\n        },\r\n        {\r\n            \"featureType\": \"road.highway\",\r\n            \"elementType\": \"geometry.stroke\",\r\n            \"stylers\": [\r\n                {\r\n                    \"color\": \"#efe9e4\"\r\n                },\r\n                {\r\n                    \"lightness\": -40\r\n                }\r\n            ]\r\n        },\r\n        {\r\n            \"featureType\": \"road.arterial\",\r\n            \"elementType\": \"geometry.stroke\",\r\n            \"stylers\": [\r\n                {\r\n                    \"color\": \"#efe9e4\"\r\n                },\r\n                {\r\n                    \"lightness\": -20\r\n                }\r\n            ]\r\n        },\r\n        {\r\n            \"featureType\": \"road\",\r\n            \"elementType\": \"labels.text.stroke\",\r\n            \"stylers\": [\r\n                {\r\n                    \"lightness\": 100\r\n                }\r\n            ]\r\n        },\r\n        {\r\n            \"featureType\": \"road\",\r\n            \"elementType\": \"labels.text.fill\",\r\n            \"stylers\": [\r\n                {\r\n                    \"lightness\": -100\r\n                }\r\n            ]\r\n        },\r\n        {\r\n            \"featureType\": \"road.highway\",\r\n            \"elementType\": \"labels.icon\"\r\n        },\r\n        {\r\n            \"featureType\": \"landscape\",\r\n            \"elementType\": \"labels\",\r\n            \"stylers\": [\r\n                {\r\n                    \"visibility\": \"off\"\r\n                }\r\n            ]\r\n        },\r\n        {\r\n            \"featureType\": \"landscape\",\r\n            \"stylers\": [\r\n                {\r\n                    \"lightness\": 20\r\n                },\r\n                {\r\n                    \"color\": \"#efe9e4\"\r\n                }\r\n            ]\r\n        },\r\n        {\r\n            \"featureType\": \"landscape.man_made\",\r\n            \"stylers\": [\r\n                {\r\n                    \"visibility\": \"off\"\r\n                }\r\n            ]\r\n        },\r\n        {\r\n            \"featureType\": \"water\",\r\n            \"elementType\": \"labels.text.stroke\",\r\n            \"stylers\": [\r\n                {\r\n                    \"lightness\": 100\r\n                }\r\n            ]\r\n        },\r\n        {\r\n            \"featureType\": \"water\",\r\n            \"elementType\": \"labels.text.fill\",\r\n            \"stylers\": [\r\n                {\r\n                    \"lightness\": -100\r\n                }\r\n            ]\r\n        },\r\n        {\r\n            \"featureType\": \"poi\",\r\n            \"elementType\": \"labels.text.fill\",\r\n            \"stylers\": [\r\n                {\r\n                    \"hue\": \"#11ff00\"\r\n                }\r\n            ]\r\n        },\r\n        {\r\n            \"featureType\": \"poi\",\r\n            \"elementType\": \"labels.text.stroke\",\r\n            \"stylers\": [\r\n                {\r\n                    \"lightness\": 100\r\n                }\r\n            ]\r\n        },\r\n        {\r\n            \"featureType\": \"poi\",\r\n            \"elementType\": \"labels.icon\",\r\n            \"stylers\": [\r\n                {\r\n                    \"hue\": \"#4cff00\"\r\n                },\r\n                {\r\n                    \"saturation\": 58\r\n                }\r\n            ]\r\n        },\r\n        {\r\n            \"featureType\": \"poi\",\r\n            \"elementType\": \"geometry\",\r\n            \"stylers\": [\r\n                {\r\n                    \"visibility\": \"on\"\r\n                },\r\n                {\r\n                    \"color\": \"#f0e4d3\"\r\n                }\r\n            ]\r\n        },\r\n        {\r\n            \"featureType\": \"road.highway\",\r\n            \"elementType\": \"geometry.fill\",\r\n            \"stylers\": [\r\n                {\r\n                    \"color\": \"#efe9e4\"\r\n                },\r\n                {\r\n                    \"lightness\": -25\r\n                }\r\n            ]\r\n        },\r\n        {\r\n            \"featureType\": \"road.arterial\",\r\n            \"elementType\": \"geometry.fill\",\r\n            \"stylers\": [\r\n                {\r\n                    \"color\": \"#efe9e4\"\r\n                },\r\n                {\r\n                    \"lightness\": -10\r\n                }\r\n            ]\r\n        },\r\n        // ----- Hides labels for Points of Interests -----\r\n        {\r\n            \"featureType\": \"poi\",\r\n            \"elementType\": \"labels\",\r\n            \"stylers\": [\r\n                {\r\n                    // hides both icon and text\r\n                    //\"visibility\": \"off\"\r\n                    \r\n                    // hides just the text\r\n                    \"visibility\": \"simplified\"\r\n                }\r\n            ]\r\n        },\r\n        // ------------------------------------------------\r\n    ]",
      "views":3322,
      "createdBy":{
         "name":"Paulo Ávila",
         "url":"https://github.com/demoive/"
      },
      "createdOn":"2013-10-30T16:39:17.933"
   },
   {
      "id":44,
      "name":"MapBox",
      "description":"Light blue and grey color scheme for Google Maps, inspired by MapBox's default map color.",
      "url":"http://snazzymaps.com/style/44/mapbox",
      "json":"[\r\n    {\r\n        \"featureType\": \"water\",\r\n        \"stylers\": [\r\n            {\r\n                \"saturation\": 43\r\n            },\r\n            {\r\n                \"lightness\": -11\r\n            },\r\n            {\r\n                \"hue\": \"#0088ff\"\r\n            }\r\n        ]\r\n    },\r\n    {\r\n        \"featureType\": \"road\",\r\n        \"elementType\": \"geometry.fill\",\r\n        \"stylers\": [\r\n            {\r\n                \"hue\": \"#ff0000\"\r\n            },\r\n            {\r\n                \"saturation\": -100\r\n            },\r\n            {\r\n                \"lightness\": 99\r\n            }\r\n        ]\r\n    },\r\n    {\r\n        \"featureType\": \"road\",\r\n        \"elementType\": \"geometry.stroke\",\r\n        \"stylers\": [\r\n            {\r\n                \"color\": \"#808080\"\r\n            },\r\n            {\r\n                \"lightness\": 54\r\n            }\r\n        ]\r\n    },\r\n    {\r\n        \"featureType\": \"landscape.man_made\",\r\n        \"elementType\": \"geometry.fill\",\r\n        \"stylers\": [\r\n            {\r\n                \"color\": \"#ece2d9\"\r\n            }\r\n        ]\r\n    },\r\n    {\r\n        \"featureType\": \"poi.park\",\r\n        \"elementType\": \"geometry.fill\",\r\n        \"stylers\": [\r\n            {\r\n                \"color\": \"#ccdca1\"\r\n            }\r\n        ]\r\n    },\r\n    {\r\n        \"featureType\": \"road\",\r\n        \"elementType\": \"labels.text.fill\",\r\n        \"stylers\": [\r\n            {\r\n                \"color\": \"#767676\"\r\n            }\r\n        ]\r\n    },\r\n    {\r\n        \"featureType\": \"road\",\r\n        \"elementType\": \"labels.text.stroke\",\r\n        \"stylers\": [\r\n            {\r\n                \"color\": \"#ffffff\"\r\n            }\r\n        ]\r\n    },\r\n    {\r\n        \"featureType\": \"poi\",\r\n        \"stylers\": [\r\n            {\r\n                \"visibility\": \"off\"\r\n            }\r\n        ]\r\n    },\r\n    {\r\n        \"featureType\": \"landscape.natural\",\r\n        \"elementType\": \"geometry.fill\",\r\n        \"stylers\": [\r\n            {\r\n                \"visibility\": \"on\"\r\n            },\r\n            {\r\n                \"color\": \"#b8cb93\"\r\n            }\r\n        ]\r\n    },\r\n    {\r\n        \"featureType\": \"poi.park\",\r\n        \"stylers\": [\r\n            {\r\n                \"visibility\": \"on\"\r\n            }\r\n        ]\r\n    },\r\n    {\r\n        \"featureType\": \"poi.sports_complex\",\r\n        \"stylers\": [\r\n            {\r\n                \"visibility\": \"on\"\r\n            }\r\n        ]\r\n    },\r\n    {\r\n        \"featureType\": \"poi.medical\",\r\n        \"stylers\": [\r\n            {\r\n                \"visibility\": \"on\"\r\n            }\r\n        ]\r\n    },\r\n    {\r\n        \"featureType\": \"poi.business\",\r\n        \"stylers\": [\r\n            {\r\n                \"visibility\": \"simplified\"\r\n            }\r\n        ]\r\n    }\r\n]",
      "views":3097,
      "createdBy":{
         "name":"Sam Herbert",
         "url":"http://abearcreative.com/"
      },
      "createdOn":"2013-11-25T16:30:39.307"
   },
   {
      "id":35,
      "name":"Avocado World",
      "description":"A creamy green color palette.  ",
      "url":"http://snazzymaps.com/style/35/avocado-world",
      "json":" [ \r\n\t\t{ \r\n\t\t\tfeatureType: 'water', \r\n\t\t\telementType: 'geometry', \r\n\t\t\tstylers: [ \r\n\t\t\t\t{ \"visibility\": \"on\" }, \r\n\t\t\t\t{ \"color\": \"#aee2e0\" } ] \r\n\t\t\t},\r\n\t\t{ \r\n\t\t\tfeatureType: 'landscape', \r\n\t\t\telementType: 'geometry.fill', \r\n\t\t\tstylers: [ \r\n\t\t\t\t{ color: '#abce83' } ] \r\n\t\t},{ \r\n\t\t\tfeatureType: 'poi', \r\n\t\t\telementType: 'geometry.fill', \r\n\t\t\tstylers: [ \r\n\t\t\t\t{ color: '#769E72' } ] \r\n\t\t},{ \r\n\t\t\tfeatureType: 'poi', \r\n\t\t\telementType: 'labels.text.fill', \r\n\t\t\tstylers: [ \r\n\t\t\t\t{ color: '#7B8758' }, \r\n\t\t\t] \r\n\t\t},{ \r\n\t\t\tfeatureType: 'poi', \r\n\t\t\telementType: 'labels.text.stroke', \r\n\t\t\tstylers: [ \r\n\t\t\t\t{ color: '#EBF4A4' }, \r\n\t\t\t] \t\r\n\t\t},{ \r\n\t\t\tfeatureType: 'poi.park', \r\n\t\t\telementType: 'geometry', \r\n\t\t\tstylers: [ \r\n\t\t\t\t{ visibility: 'simplified' }, \r\n\t\t\t\t{ color: '#8dab68' } \r\n\t\t\t] \r\n\t\t},{\r\n\t\t\tfeatureType: 'road', \r\n\t\t\telementType: 'geometry.fill', \r\n\t\t\tstylers: [ \r\n\t\t\t\t{ visibility: 'simplified' }, \r\n\t\t\t]\r\n\t\t},{\r\n\t\t\tfeatureType: 'road', \r\n\t\t\telementType: 'labels.text.fill', \r\n\t\t\tstylers: [ \r\n\t\t\t\t{ color: '#5B5B3F' } \r\n\t\t\t]\r\n\t\t},{\r\n\t\t\tfeatureType: 'road', \r\n\t\t\telementType: 'labels.text.stroke', \r\n\t\t\tstylers: [ \r\n\t\t\t\t{ color: '#ABCE83' } \r\n\t\t\t]\r\n\t\t},{\r\n\t\t\tfeatureType: 'road', \r\n\t\t\telementType: 'labels.icon', \r\n\t\t\tstylers: [ \r\n\t\t\t\t{ visibility: 'off' } \r\n\t\t\t]\t\r\n\t\t},{  \r\n\t\t\tfeatureType: 'road.local', \r\n\t\t\telementType: 'geometry', \r\n\t\t\tstylers: [ \r\n\t\t\t\t{ color: '#A4C67D' }, \r\n\t\t\t]\r\n\t\t},{ \r\n\t\t\tfeatureType: 'road.arterial', \r\n\t\t\telementType: 'geometry', \r\n\t\t\tstylers: [  \r\n\t\t\t\t{ color: '#9BBF72' } \r\n\t\t\t] \r\n\t\t},{ \r\n\t\t\tfeatureType: 'road.highway', \r\n\t\t\telementType: 'geometry', \r\n\t\t\tstylers: [ \r\n\t\t\t\t{ color: '#EBF4A4' } \r\n\t\t\t] \r\n\t\t},{  \r\n\t\t\tfeatureType: 'transit', \r\n\t\t\tstylers: [  \r\n\t\t\t\t{ visibility: 'off' } \r\n\t\t\t] \t \r\n\t\t},{ \r\n\t\t\tfeatureType: 'administrative', \r\n\t\t\telementType: 'geometry.stroke', \r\n\t\t\tstylers: [ \r\n\t\t\t\t{ visibility: 'on' }, \r\n\t\t\t\t{ color: '#87ae79' } \r\n\t\t\t] \r\n\t\t},{ \r\n\t\t\tfeatureType: 'administrative', \r\n\t\t\telementType: 'geometry.fill', \r\n\t\t\tstylers: [ \r\n\t\t\t\t{ color: '#7f2200' }, \r\n\t\t\t\t{ visibility: 'off' } \r\n\t\t\t] \r\n\t\t},{ \r\n\t\t\tfeatureType: 'administrative', \r\n\t\t\telementType: 'labels.text.stroke', \r\n\t\t\tstylers: [ \r\n\t\t\t\t{ color: '#ffffff' }, \r\n\t\t\t\t{ visibility: 'on' }, \r\n\t\t\t\t{ weight: 4.1 } \r\n\t\t\t] \r\n\t\t},{ \r\n\t\t\tfeatureType: 'administrative', \r\n\t\t\telementType: 'labels.text.fill', \r\n\t\t\tstylers: [ \r\n\t\t\t\t{ color: '#495421' }, \r\n\t\t\t] \t\t\t\r\n\t\t},{ \r\n\t\t\tfeatureType: 'administrative.neighborhood', \r\n\t\t\telementType: 'labels', \r\n\t\t\tstylers: [ { visibility: 'off' } ] \r\n\t\t} \r\n\t]",
      "views":3034,
      "createdBy":{
         "name":"Tracy Elliott",
         "url":"http://www.glowfruit.com"
      },
      "createdOn":"2013-11-09T18:04:34.34"
   },
   {
      "id":6,
      "name":"Countries",
      "description":"Example provided by Google showcasing their style API. Great for highlighting countries when zoomed all the way out.",
      "url":"http://snazzymaps.com/style/6/countries",
      "json":"[{  featureType: 'all',  stylers: [{visibility: 'off'}  ]},{  featureType: 'water',  stylers: [{visibility: 'on'},{lightness: -100 }  ]}  ]",
      "views":2818,
      "createdBy":{
         "name":"Google",
         "url":"http://maps-api-tt.appspot.com/apilite/styled/styled.html"
      },
      "createdOn":"2013-10-24T22:54:40.863"
   },
   {
      "id":37,
      "name":"Lunar Landscape",
      "description":"A cool style with inverted lightness. The dark grey-blue water color contrasts well with blacks and greys. Great for dark websites with a bit of color.",
      "url":"http://snazzymaps.com/style/37/lunar-landscape",
      "json":"\r\n[\r\n\t{\r\n\t        stylers: [\r\n\t\t\t{ hue: '#ff1a00' },\r\n\t\t\t{ invert_lightness: true },\r\n\t\t\t{ saturation: -100  },\r\n\t\t\t{ lightness: 33 },\r\n\t\t\t{ gamma: 0.5 }\r\n\t        ]\r\n\t},{\r\n\t\tfeatureType: 'water',\r\n\t\telementType: 'geometry',\r\n\t\tstylers: [\r\n\t\t\t{ color: '#2D333C' }\r\n\t\t]\r\n\t}\r\n    ]",
      "views":2773,
      "createdBy":{
         "name":"Veit Stumpf",
         "url":"http://www.osteopathie-stumpf.de/"
      },
      "createdOn":"2013-11-12T18:14:40.277"
   },
   {
      "id":54,
      "name":"RouteXL",
      "description":"Clear, light map with little details, to put accent on road itineraries. Included are roads and administrative elements, like cities, states and countries. Landscape elements are simple, but points of interest and transits are excluded.",
      "url":"http://snazzymaps.com/style/54/routexl",
      "json":"[ \r\n\t{ featureType: \"administrative\", elementType: \"all\", stylers: [ { visibility: \"on\" }, { saturation: -100 }, { lightness: 20 } ] },\r\n\t{ featureType: \"road\", elementType: \"all\", stylers: [ { visibility: \"on\" }, { saturation: -100 }, { lightness: 40 } ] },\r\n\t{ featureType: \"water\", elementType: \"all\", stylers: [ { visibility: \"on\" }, { saturation: -10 }, { lightness: 30 } ] },\r\n\t{ featureType: \"landscape.man_made\", elementType: \"all\", stylers: [ { visibility: \"simplified\" }, { saturation: -60 }, { lightness: 10 } ] },\r\n\t{ featureType: \"landscape.natural\", elementType: \"all\", stylers: [ { visibility: \"simplified\" }, { saturation: -60 }, { lightness: 60 } ] },\r\n\t{ featureType: \"poi\", elementType: \"all\", stylers: [ { visibility: \"off\" }, { saturation: -100 }, { lightness: 60 } ] }, \r\n\t{ featureType: \"transit\", elementType: \"all\", stylers: [ { visibility: \"off\" }, { saturation: -100 }, { lightness: 60 } ] }\r\n]",
      "views":2638,
      "createdBy":{
         "name":"RouteXL",
         "url":"http://www.routexl.com"
      },
      "createdOn":"2014-01-06T19:39:45.387"
   },
   {
      "id":12,
      "name":"Snazzy Maps",
      "description":"A colour scheme using the colours from this very website! Bright green land contrasted with dark grey water. Varying shades of green for roads, white labels, and thin borders results in a very Snazzy Map!",
      "url":"http://snazzymaps.com/style/12/snazzy-maps",
      "json":"[{\"featureType\": \"water\",\"elementType\": \"geometry\",\"stylers\": [{ \"color\": \"#333739\" }]},{\"featureType\": \"landscape\",\"elementType\": \"geometry\",\"stylers\": [{ \"color\": \"#2ecc71\" }]},{\"featureType\": \"poi\",\"stylers\": [{ \"color\": \"#2ecc71\" },{ \"lightness\": -7 }]},{\"featureType\": \"road.highway\",\"elementType\": \"geometry\",\"stylers\": [{ \"color\": \"#2ecc71\" },{ \"lightness\": -28 }]},{\"featureType\": \"road.arterial\",\"elementType\": \"geometry\",\"stylers\": [{ \"color\": \"#2ecc71\" },{ \"visibility\": \"on\" },{ \"lightness\": -15 }]},{\"featureType\": \"road.local\",\"elementType\": \"geometry\",\"stylers\": [{ \"color\": \"#2ecc71\" },{ \"lightness\": -18 }]},{\"elementType\": \"labels.text.fill\",\"stylers\": [{ \"color\": \"#ffffff\" }]},{\"elementType\": \"labels.text.stroke\",\"stylers\": [{ \"visibility\": \"off\" }]},{\"featureType\": \"transit\",\"elementType\": \"geometry\",\"stylers\": [{ \"color\": \"#2ecc71\" },{ \"lightness\": -34 }]},{\"featureType\": \"administrative\",\"elementType\": \"geometry\",\"stylers\": [{ \"visibility\": \"on\" },{ \"color\": \"#333739\" },{ \"weight\": 0.8 }]},{\"featureType\": \"poi.park\",\"stylers\": [{ \"color\": \"#2ecc71\" }]},{\"featureType\": \"road\",\"elementType\": \"geometry.stroke\",\"stylers\": [{ \"color\": \"#333739\" },{ \"weight\": 0.3 },{ \"lightness\": 10 }]}]",
      "views":2621,
      "createdBy":{
         "name":"Adam Krogh",
         "url":"http://atmist.com"
      },
      "createdOn":"2013-10-25T05:31:16.67"
   },
   {
      "id":53,
      "name":"Flat Map",
      "description":"A flat, minimal, colourful map without any labels.",
      "url":"http://snazzymaps.com/style/53/flat-map",
      "json":"[{\r\n        \"stylers\": [{\r\n            \"visibility\": \"off\"\r\n        }]\r\n    }, {\r\n        \"featureType\": \"road\",\r\n            \"stylers\": [{\r\n            \"visibility\": \"on\"\r\n        }, {\r\n            \"color\": \"#ffffff\"\r\n        }]\r\n    }, {\r\n        \"featureType\": \"road.arterial\",\r\n            \"stylers\": [{\r\n            \"visibility\": \"on\"\r\n        }, {\r\n            \"color\": \"#fee379\"\r\n        }]\r\n    }, {\r\n        \"featureType\": \"road.highway\",\r\n            \"stylers\": [{\r\n            \"visibility\": \"on\"\r\n        }, {\r\n            \"color\": \"#fee379\"\r\n        }]\r\n    }, {\r\n        \"featureType\": \"landscape\",\r\n            \"stylers\": [{\r\n            \"visibility\": \"on\"\r\n        }, {\r\n            \"color\": \"#f3f4f4\"\r\n        }]\r\n    }, {\r\n        \"featureType\": \"water\",\r\n            \"stylers\": [{\r\n            \"visibility\": \"on\"\r\n        }, {\r\n            \"color\": \"#7fc8ed\"\r\n        }]\r\n    }, {}, {\r\n        \"featureType\": \"road\",\r\n            \"elementType\": \"labels\",\r\n            \"stylers\": [{\r\n            \"visibility\": \"off\"\r\n        }]\r\n    }, {\r\n        \"featureType\": \"poi.park\",\r\n            \"elementType\": \"geometry.fill\",\r\n            \"stylers\": [{\r\n            \"visibility\": \"on\"\r\n        }, {\r\n            \"color\": \"#83cead\"\r\n        }]\r\n    }, {\r\n        \"elementType\": \"labels\",\r\n            \"stylers\": [{\r\n            \"visibility\": \"off\"\r\n        }]\r\n    }, {\r\n        \"featureType\": \"landscape.man_made\",\r\n            \"elementType\": \"geometry\",\r\n            \"stylers\": [{\r\n            \"weight\": 0.9\r\n        }, {\r\n            \"visibility\": \"off\"\r\n        }]\r\n    }]",
      "views":2584,
      "createdBy":{
         "name":"Sergio Behrends",
         "url":"http://snazzymaps.com"
      },
      "createdOn":"2014-01-06T19:38:52.737"
   },
   {
      "id":22,
      "name":"Old Timey",
      "description":"An old timey color scheme provided by Google on their Maps API home page. Pure awesomeness in subtle browns and greys.",
      "url":"http://snazzymaps.com/style/22/old-timey",
      "json":"[{featureType:\"administrative\",stylers:[{visibility:\"off\"}]},{featureType:\"poi\",stylers:[{visibility:\"simplified\"}]},{featureType:\"road\",stylers:[{visibility:\"simplified\"}]},{featureType:\"water\",\r\nstylers:[{visibility:\"simplified\"}]},{featureType:\"transit\",stylers:[{visibility:\"simplified\"}]},{featureType:\"landscape\",stylers:[{visibility:\"simplified\"}]},{featureType:\"road.highway\",stylers:[{visibility:\"off\"}]},{featureType:\"road.local\",stylers:[{visibility:\"on\"}]},{featureType:\"road.highway\",elementType:\"geometry\",stylers:[{visibility:\"on\"}]},{featureType:\"water\",stylers:[{color:\"#84afa3\"},{lightness:52}]},{stylers:[{saturation:-77}]},{featureType:\"road\"}]",
      "views":2566,
      "createdBy":{
         "name":"Google",
         "url":"https://embed-dot-more-than-a-map.appspot.com/demos/basemaps/tokyo"
      },
      "createdOn":"2013-11-04T03:36:27.687"
   },
   {
      "id":43,
      "name":"Bentley",
      "description":"A subtle style reminiscent of old paper printed road maps.",
      "url":"http://snazzymaps.com/style/43/bentley",
      "json":"[\r\n\t{\r\n\t\t\"featureType\": \"landscape\",\r\n\t\t\"stylers\": [\r\n\t\t\t{\r\n\t\t\t\t\"hue\": \"#F1FF00\"\r\n\t\t\t},\r\n\t\t\t{\r\n\t\t\t\t\"saturation\": -27.4\r\n\t\t\t},\r\n\t\t\t{\r\n\t\t\t\t\"lightness\": 9.4\r\n\t\t\t},\r\n\t\t\t{\r\n\t\t\t\t\"gamma\": 1\r\n\t\t\t}\r\n\t\t]\r\n\t},\r\n\t{\r\n\t\t\"featureType\": \"road.highway\",\r\n\t\t\"stylers\": [\r\n\t\t\t{\r\n\t\t\t\t\"hue\": \"#0099FF\"\r\n\t\t\t},\r\n\t\t\t{\r\n\t\t\t\t\"saturation\": -20\r\n\t\t\t},\r\n\t\t\t{\r\n\t\t\t\t\"lightness\": 36.4\r\n\t\t\t},\r\n\t\t\t{\r\n\t\t\t\t\"gamma\": 1\r\n\t\t\t}\r\n\t\t]\r\n\t},\r\n\t{\r\n\t\t\"featureType\": \"road.arterial\",\r\n\t\t\"stylers\": [\r\n\t\t\t{\r\n\t\t\t\t\"hue\": \"#00FF4F\"\r\n\t\t\t},\r\n\t\t\t{\r\n\t\t\t\t\"saturation\": 0\r\n\t\t\t},\r\n\t\t\t{\r\n\t\t\t\t\"lightness\": 0\r\n\t\t\t},\r\n\t\t\t{\r\n\t\t\t\t\"gamma\": 1\r\n\t\t\t}\r\n\t\t]\r\n\t},\r\n\t{\r\n\t\t\"featureType\": \"road.local\",\r\n\t\t\"stylers\": [\r\n\t\t\t{\r\n\t\t\t\t\"hue\": \"#FFB300\"\r\n\t\t\t},\r\n\t\t\t{\r\n\t\t\t\t\"saturation\": -38\r\n\t\t\t},\r\n\t\t\t{\r\n\t\t\t\t\"lightness\": 11.2\r\n\t\t\t},\r\n\t\t\t{\r\n\t\t\t\t\"gamma\": 1\r\n\t\t\t}\r\n\t\t]\r\n\t},\r\n\t{\r\n\t\t\"featureType\": \"water\",\r\n\t\t\"stylers\": [\r\n\t\t\t{\r\n\t\t\t\t\"hue\": \"#00B6FF\"\r\n\t\t\t},\r\n\t\t\t{\r\n\t\t\t\t\"saturation\": 4.2\r\n\t\t\t},\r\n\t\t\t{\r\n\t\t\t\t\"lightness\": -63.4\r\n\t\t\t},\r\n\t\t\t{\r\n\t\t\t\t\"gamma\": 1\r\n\t\t\t}\r\n\t\t]\r\n\t},\r\n\t{\r\n\t\t\"featureType\": \"poi\",\r\n\t\t\"stylers\": [\r\n\t\t\t{\r\n\t\t\t\t\"hue\": \"#9FFF00\"\r\n\t\t\t},\r\n\t\t\t{\r\n\t\t\t\t\"saturation\": 0\r\n\t\t\t},\r\n\t\t\t{\r\n\t\t\t\t\"lightness\": 0\r\n\t\t\t},\r\n\t\t\t{\r\n\t\t\t\t\"gamma\": 1\r\n\t\t\t}\r\n\t\t]\r\n\t}\r\n]",
      "views":2396,
      "createdBy":{
         "name":"Ian Thompson",
         "url":"http://it-architecture.net"
      },
      "createdOn":"2013-11-25T16:29:24.297"
   },
   {
      "id":7,
      "name":"Icy Blue",
      "description":"A simple light blue theme that looks great at any zoom level.",
      "url":"http://snazzymaps.com/style/7/icy-blue",
      "json":"[{stylers:[{hue:'#2c3e50'},{saturation:250}]},{featureType:'road',elementType:'geometry',stylers:[{lightness:50},{visibility:'simplified'}]},{featureType:'road',elementType:'labels',stylers:[{visibility:'off'}]}]",
      "views":2381,
      "createdBy":{
         "name":"Sahir Memon",
         "url":"http://trendylists.com"
      },
      "createdOn":"2013-10-24T22:54:41.913"
   },
   {
      "id":21,
      "name":"Hopper",
      "description":"Based upon Edward Hopper's paintings",
      "url":"http://snazzymaps.com/style/21/hopper",
      "json":"[\r\n\t{\r\n\t\tfeatureType: 'water',\r\n\t\telementType: 'geometry',\r\n\t\tstylers: [\r\n\t\t\t{ hue: '#165c64' },\r\n\t\t\t{ saturation: 34 },\r\n\t\t\t{ lightness: -69 },\r\n\t\t\t{ visibility: 'on' }\r\n\t\t]\r\n\t},{\r\n\t\tfeatureType: 'landscape',\r\n\t\telementType: 'geometry',\r\n\t\tstylers: [\r\n\t\t\t{ hue: '#b7caaa' },\r\n\t\t\t{ saturation: -14 },\r\n\t\t\t{ lightness: -18 },\r\n\t\t\t{ visibility: 'on' }\r\n\t\t]\r\n\t},{\r\n\t\tfeatureType: 'landscape.man_made',\r\n\t\telementType: 'all',\r\n\t\tstylers: [\r\n\t\t\t{ hue: '#cbdac1' },\r\n\t\t\t{ saturation: -6 },\r\n\t\t\t{ lightness: -9 },\r\n\t\t\t{ visibility: 'on' }\r\n\t\t]\r\n\t},{\r\n\t\tfeatureType: 'road',\r\n\t\telementType: 'geometry',\r\n\t\tstylers: [\r\n\t\t\t{ hue: '#8d9b83' },\r\n\t\t\t{ saturation: -89 },\r\n\t\t\t{ lightness: -12 },\r\n\t\t\t{ visibility: 'on' }\r\n\t\t]\r\n\t},{\r\n\t\tfeatureType: 'road.highway',\r\n\t\telementType: 'geometry',\r\n\t\tstylers: [\r\n\t\t\t{ hue: '#d4dad0' },\r\n\t\t\t{ saturation: -88 },\r\n\t\t\t{ lightness: 54 },\r\n\t\t\t{ visibility: 'simplified' }\r\n\t\t]\r\n\t},{\r\n\t\tfeatureType: 'road.arterial',\r\n\t\telementType: 'geometry',\r\n\t\tstylers: [\r\n\t\t\t{ hue: '#bdc5b6' },\r\n\t\t\t{ saturation: -89 },\r\n\t\t\t{ lightness: -3 },\r\n\t\t\t{ visibility: 'simplified' }\r\n\t\t]\r\n\t},{\r\n\t\tfeatureType: 'road.local',\r\n\t\telementType: 'geometry',\r\n\t\tstylers: [\r\n\t\t\t{ hue: '#bdc5b6' },\r\n\t\t\t{ saturation: -89 },\r\n\t\t\t{ lightness: -26 },\r\n\t\t\t{ visibility: 'on' }\r\n\t\t]\r\n\t},{\r\n\t\tfeatureType: 'poi',\r\n\t\telementType: 'geometry',\r\n\t\tstylers: [\r\n\t\t\t{ hue: '#c17118' },\r\n\t\t\t{ saturation: 61 },\r\n\t\t\t{ lightness: -45 },\r\n\t\t\t{ visibility: 'on' }\r\n\t\t]\r\n\t},{\r\n\t\tfeatureType: 'poi.park',\r\n\t\telementType: 'all',\r\n\t\tstylers: [\r\n\t\t\t{ hue: '#8ba975' },\r\n\t\t\t{ saturation: -46 },\r\n\t\t\t{ lightness: -28 },\r\n\t\t\t{ visibility: 'on' }\r\n\t\t]\r\n\t},{\r\n\t\tfeatureType: 'transit',\r\n\t\telementType: 'geometry',\r\n\t\tstylers: [\r\n\t\t\t{ hue: '#a43218' },\r\n\t\t\t{ saturation: 74 },\r\n\t\t\t{ lightness: -51 },\r\n\t\t\t{ visibility: 'simplified' }\r\n\t\t]\r\n\t},{\r\n\t\tfeatureType: 'administrative.province',\r\n\t\telementType: 'all',\r\n\t\tstylers: [\r\n\t\t\t{ hue: '#ffffff' },\r\n\t\t\t{ saturation: 0 },\r\n\t\t\t{ lightness: 100 },\r\n\t\t\t{ visibility: 'simplified' }\r\n\t\t]\r\n\t},{\r\n\t\tfeatureType: 'administrative.neighborhood',\r\n\t\telementType: 'all',\r\n\t\tstylers: [\r\n\t\t\t{ hue: '#ffffff' },\r\n\t\t\t{ saturation: 0 },\r\n\t\t\t{ lightness: 100 },\r\n\t\t\t{ visibility: 'off' }\r\n\t\t]\r\n\t},{\r\n\t\tfeatureType: 'administrative.locality',\r\n\t\telementType: 'labels',\r\n\t\tstylers: [\r\n\t\t\t{ hue: '#ffffff' },\r\n\t\t\t{ saturation: 0 },\r\n\t\t\t{ lightness: 100 },\r\n\t\t\t{ visibility: 'off' }\r\n\t\t]\r\n\t},{\r\n\t\tfeatureType: 'administrative.land_parcel',\r\n\t\telementType: 'all',\r\n\t\tstylers: [\r\n\t\t\t{ hue: '#ffffff' },\r\n\t\t\t{ saturation: 0 },\r\n\t\t\t{ lightness: 100 },\r\n\t\t\t{ visibility: 'off' }\r\n\t\t]\r\n\t},{\r\n\t\tfeatureType: 'administrative',\r\n\t\telementType: 'all',\r\n\t\tstylers: [\r\n\t\t\t{ hue: '#3a3935' },\r\n\t\t\t{ saturation: 5 },\r\n\t\t\t{ lightness: -57 },\r\n\t\t\t{ visibility: 'off' }\r\n\t\t]\r\n\t},{\r\n\t\tfeatureType: 'poi.medical',\r\n\t\telementType: 'geometry',\r\n\t\tstylers: [\r\n\t\t\t{ hue: '#cba923' },\r\n\t\t\t{ saturation: 50 },\r\n\t\t\t{ lightness: -46 },\r\n\t\t\t{ visibility: 'on' }\r\n\t\t]\r\n\t}\r\n]\r\n",
      "views":2080,
      "createdBy":{
         "name":"Holly Valero",
         "url":"http://hollyworks.com"
      },
      "createdOn":"2013-11-03T16:56:48.357"
   },
   {
      "id":30,
      "name":"Cobalt",
      "description":"Deep blue style with dark ground elements and highlighted roads.",
      "url":"http://snazzymaps.com/style/30/cobalt",
      "json":"[\r\n\t{\r\n\t\tfeatureType: \"all\",\r\n\t\telementType: \"all\",\r\n\t\tstylers: [\r\n\t\t{\r\n\t\t\tinvert_lightness: true\r\n\t\t},\r\n\t\t{\r\n\t\t\tsaturation: 10\r\n\t\t},\r\n\r\n\t\t{\r\n\t\t\tlightness: 30\r\n\t\t},\r\n\r\n\t\t{\r\n\t\t\tgamma: 0.5\r\n\t\t},\r\n\r\n\t\t{\r\n\t\t\thue: \"#435158\"\r\n\t\t}\r\n\t\t]\r\n\t}\r\n\t]",
      "views":1833,
      "createdBy":{
         "name":"macodev",
         "url":"http://macodev.com"
      },
      "createdOn":"2013-11-07T15:17:05.343"
   },
   {
      "id":55,
      "name":"Subtle Greyscale Map",
      "description":"A subtle greyscale color scheme that works great for website/architectural design use. It is built by Google Map Customizer, which allows you to customize the colors on a Google Map and get large, high resolution images.",
      "url":"http://snazzymaps.com/style/55/subtle-greyscale-map",
      "json":"[\r\n\t{\r\n\t\tfeatureType: 'poi',\r\n\t\telementType: 'all',\r\n\t\tstylers: [\r\n\t\t\t{ hue: '#000000' },\r\n\t\t\t{ saturation: -100 },\r\n\t\t\t{ lightness: -100 },\r\n\t\t\t{ visibility: 'off' }\r\n\t\t]\r\n\t},{\r\n\t\tfeatureType: 'poi',\r\n\t\telementType: 'all',\r\n\t\tstylers: [\r\n\t\t\t{ hue: '#000000' },\r\n\t\t\t{ saturation: -100 },\r\n\t\t\t{ lightness: -100 },\r\n\t\t\t{ visibility: 'off' }\r\n\t\t]\r\n\t},{\r\n\t\tfeatureType: 'administrative',\r\n\t\telementType: 'all',\r\n\t\tstylers: [\r\n\t\t\t{ hue: '#000000' },\r\n\t\t\t{ saturation: 0 },\r\n\t\t\t{ lightness: -100 },\r\n\t\t\t{ visibility: 'off' }\r\n\t\t]\r\n\t},{\r\n\t\tfeatureType: 'road',\r\n\t\telementType: 'labels',\r\n\t\tstylers: [\r\n\t\t\t{ hue: '#ffffff' },\r\n\t\t\t{ saturation: -100 },\r\n\t\t\t{ lightness: 100 },\r\n\t\t\t{ visibility: 'off' }\r\n\t\t]\r\n\t},{\r\n\t\tfeatureType: 'water',\r\n\t\telementType: 'labels',\r\n\t\tstylers: [\r\n\t\t\t{ hue: '#000000' },\r\n\t\t\t{ saturation: -100 },\r\n\t\t\t{ lightness: -100 },\r\n\t\t\t{ visibility: 'off' }\r\n\t\t]\r\n\t},{\r\n\t\tfeatureType: 'road.local',\r\n\t\telementType: 'all',\r\n\t\tstylers: [\r\n\t\t\t{ hue: '#ffffff' },\r\n\t\t\t{ saturation: -100 },\r\n\t\t\t{ lightness: 100 },\r\n\t\t\t{ visibility: 'on' }\r\n\t\t]\r\n\t},{\r\n\t\tfeatureType: 'water',\r\n\t\telementType: 'geometry',\r\n\t\tstylers: [\r\n\t\t\t{ hue: '#ffffff' },\r\n\t\t\t{ saturation: -100 },\r\n\t\t\t{ lightness: 100 },\r\n\t\t\t{ visibility: 'on' }\r\n\t\t]\r\n\t},{\r\n\t\tfeatureType: 'transit',\r\n\t\telementType: 'labels',\r\n\t\tstylers: [\r\n\t\t\t{ hue: '#000000' },\r\n\t\t\t{ saturation: 0 },\r\n\t\t\t{ lightness: -100 },\r\n\t\t\t{ visibility: 'off' }\r\n\t\t]\r\n\t},{\r\n\t\tfeatureType: 'landscape',\r\n\t\telementType: 'labels',\r\n\t\tstylers: [\r\n\t\t\t{ hue: '#000000' },\r\n\t\t\t{ saturation: -100 },\r\n\t\t\t{ lightness: -100 },\r\n\t\t\t{ visibility: 'off' }\r\n\t\t]\r\n\t},{\r\n\t\tfeatureType: 'road',\r\n\t\telementType: 'geometry',\r\n\t\tstylers: [\r\n\t\t\t{ hue: '#bbbbbb' },\r\n\t\t\t{ saturation: -100 },\r\n\t\t\t{ lightness: 26 },\r\n\t\t\t{ visibility: 'on' }\r\n\t\t]\r\n\t},{\r\n\t\tfeatureType: 'landscape',\r\n\t\telementType: 'geometry',\r\n\t\tstylers: [\r\n\t\t\t{ hue: '#dddddd' },\r\n\t\t\t{ saturation: -100 },\r\n\t\t\t{ lightness: -3 },\r\n\t\t\t{ visibility: 'on' }\r\n\t\t]\r\n\t}\r\n]",
      "views":1798,
      "createdBy":{
         "name":"Aaron Cheng",
         "url":"http://www.chengfolio.com"
      },
      "createdOn":"2014-01-06T19:40:06.227"
   },
   {
      "id":3,
      "name":"Red Alert",
      "description":"Inspired by CloudMade's style of the same name. Bold orange and reds contrast great with the unique water colour. Contrasting road colours makes it easy to read even when zoomed in.",
      "url":"http://snazzymaps.com/style/3/red-alert",
      "json":"[{'featureType': 'water','elementType': 'geometry','stylers': [{ 'color': '#ffdfa6' }]},{'featureType': 'landscape','elementType': 'geometry','stylers': [{ 'color': '#b52127' }]},{'featureType': 'poi','elementType': 'geometry','stylers': [{ 'color': '#c5531b' }]},{'featureType': 'road.highway','elementType': 'geometry.fill','stylers': [{ 'color': '#74001b' },{ 'lightness': -10 }]},{'featureType': 'road.highway','elementType': 'geometry.stroke','stylers': [{ 'color': '#da3c3c' }]},{'featureType': 'road.arterial','elementType': 'geometry.fill','stylers': [{ 'color': '#74001b' }]},{'featureType': 'road.arterial','elementType': 'geometry.stroke','stylers': [{ 'color': '#da3c3c' }]},{'featureType': 'road.local','elementType': 'geometry.fill','stylers': [{ 'color': '#990c19' }]},{'elementType': 'labels.text.fill','stylers': [{ 'color': '#ffffff' }]},{'elementType': 'labels.text.stroke','stylers': [{ 'color': '#74001b' },{ 'lightness': -8 }]},{'featureType': 'transit','elementType': 'geometry','stylers': [{ 'color': '#6a0d10' },{ 'visibility': 'on' }]},{'featureType': 'administrative','elementType': 'geometry','stylers': [{ 'color': '#ffdfa6' },{ 'weight': 0.4 }]},{'featureType': 'road.local','elementType': 'geometry.stroke','stylers': [{ 'visibility': 'off' }]}]",
      "views":1770,
      "createdBy":{
         "name":"Adam Krogh",
         "url":"http://atmist.com"
      },
      "createdOn":"2013-10-24T22:54:37.223"
   },
   {
      "id":8,
      "name":"Turquoise Water",
      "description":"A simple colour theme highlighted by bright turquoise water and subtle tinted land.",
      "url":"http://snazzymaps.com/style/8/turquoise-water",
      "json":"[{stylers:[{hue:'#16a085'},{saturation:0}]},{featureType:'road',elementType:'geometry',stylers:[{lightness:100},{visibility:'simplified'}]},{featureType:'road',elementType:'labels',stylers:[{visibility:'off'}]}]",
      "views":1699,
      "createdBy":{
         "name":"Sahir Memon",
         "url":"http://trendylists.com"
      },
      "createdOn":"2013-10-24T22:54:43.277"
   },
   {
      "id":16,
      "name":"Unimposed Topography",
      "description":"Originally noticed on a http://swnext.co/ page, this style is a neutral yet detailed view of the world. Good for anonymous, natural views of the globe without indications of humans.",
      "url":"http://snazzymaps.com/style/16/unimposed-topography",
      "json":"[\r\n    {\r\n        featureType: 'administrative',\r\n        elementType: 'all',\r\n        stylers: [\r\n            {\r\n                visibility: 'off'\r\n            }\r\n        ]\r\n    }, {\r\n        featureType: 'poi',\r\n        elementType: 'all',\r\n        stylers: [\r\n            {\r\n                visibility: 'off'\r\n            }\r\n        ]\r\n    }, {\r\n        featureType: 'road',\r\n        elementType: 'all',\r\n        stylers: [\r\n            {\r\n                visibility: 'off'\r\n            }\r\n        ]\r\n    }, {\r\n        featureType: 'transit',\r\n        elementType: 'all',\r\n        stylers: [\r\n            {\r\n                visibility: 'off'\r\n            }\r\n        ]\r\n    }, {\r\n        featureType: 'landscape',\r\n        elementType: 'all',\r\n        stylers: [\r\n            {\r\n                hue: '#727D82'\r\n            }, {\r\n                lightness: -30\r\n            }, {\r\n                saturation: -80\r\n            }\r\n        ]\r\n    }, {\r\n        featureType: 'water',\r\n        elementType: 'all',\r\n        stylers: [\r\n            {\r\n                visibility: 'simplified'\r\n            }, {\r\n                hue: '#F3F4F4'\r\n            }, {\r\n                lightness: 80\r\n            }, {\r\n                saturation: -80\r\n            }\r\n        ]\r\n    }\r\n]",
      "views":1699,
      "createdBy":{
         "name":"Paulo Ávila",
         "url":"https://github.com/demoive/"
      },
      "createdOn":"2013-10-30T16:38:03.443"
   },
   {
      "id":36,
      "name":"Flat green",
      "description":"This green style is inspired by Flat Design and works very well on contact pages of colorful websites.",
      "url":"http://snazzymaps.com/style/36/flat-green",
      "json":"[{ \"stylers\": [ { \"hue\": \"#bbff00\" }, { \"weight\": 0.5 }, { \"gamma\": 0.5 } ] },{ \"elementType\": \"labels\", \"stylers\": [ { \"visibility\": \"off\" } ] },{ \"featureType\": \"landscape.natural\", \"stylers\": [ { \"color\": \"#a4cc48\" } ] },{ \"featureType\": \"road\", \"elementType\": \"geometry\", \"stylers\": [ { \"color\": \"#ffffff\" }, { \"visibility\": \"on\" }, { \"weight\": 1 } ] },{ \"featureType\": \"administrative\", \"elementType\": \"labels\", \"stylers\": [ { \"visibility\": \"on\" } ] },{ \"featureType\": \"road.highway\", \"elementType\": \"labels\", \"stylers\": [ { \"visibility\": \"simplified\" }, { \"gamma\": 1.14 }, { \"saturation\": -18 } ] },{ \"featureType\": \"road.highway.controlled_access\", \"elementType\": \"labels\", \"stylers\": [ { \"saturation\": 30 }, { \"gamma\": 0.76 } ] },{ \"featureType\": \"road.local\", \"stylers\": [ { \"visibility\": \"simplified\" }, { \"weight\": 0.4 }, { \"lightness\": -8 } ] },{ \"featureType\": \"water\", \"stylers\": [ { \"color\": \"#4aaecc\" } ] },{ \"featureType\": \"landscape.man_made\", \"stylers\": [ { \"color\": \"#718e32\" } ] },{ \"featureType\": \"poi.business\", \"stylers\": [ { \"saturation\": 68 }, { \"lightness\": -61 } ] },{ \"featureType\": \"administrative.locality\", \"elementType\": \"labels.text.stroke\", \"stylers\": [ { \"weight\": 2.7 }, { \"color\": \"#f4f9e8\" } ] },{ \"featureType\": \"road.highway.controlled_access\", \"elementType\": \"geometry.stroke\", \"stylers\": [ { \"weight\": 1.5 }, { \"color\": \"#e53013\" }, { \"saturation\": -42 }, { \"lightness\": 28 } ] }]",
      "views":1635,
      "createdBy":{
         "name":"Jasper",
         "url":"http://www.keywebdesign.nl"
      },
      "createdOn":"2013-11-12T18:11:20.233"
   },
   {
      "id":31,
      "name":"Red Hues",
      "description":"A simple map styled with red hues.",
      "url":"http://snazzymaps.com/style/31/red-hues",
      "json":"[\r\n\t\t\t\t\t\t{\r\n\t\t\t\t\t\t\t// Style the map with the custom hue\r\n\t\t\t\t\t\t\tstylers: [\r\n\t\t\t\t\t\t\t\t{ \"hue\":\"#dd0d0d\" }\r\n\t\t\t\t\t\t\t]\r\n\t\t\t\t\t\t},\r\n\t\t\t\t\t\t{\r\n\t\t\t\t\t\t\t// Remove road labels\r\n\t\t\t\t\t\t\tfeatureType:\"road\",\r\n\t\t\t\t\t\t\telementType:\"labels\",\r\n\t\t\t\t\t\t\tstylers: [\r\n\t\t\t\t\t\t\t\t{ \"visibility\":\"off\" }\r\n\t\t\t\t\t\t\t]\r\n\t\t\t\t\t\t},\r\n\t\t\t\t\t\t{\r\n\t\t\t\t\t\t\t// Style the road\r\n\t\t\t\t\t\t\tfeatureType:\"road\",\r\n\t\t\t\t\t\t\telementType:\"geometry\",\r\n\t\t\t\t\t\t\tstylers: [\r\n\t\t\t\t\t\t\t\t{ \"lightness\":100 },\r\n\t\t\t\t\t\t\t\t{ \"visibility\":\"simplified\" }\r\n\t\t\t\t\t\t\t]\r\n\t\t\t\t\t\t}\r\n\t\t\t\t\t]",
      "views":1573,
      "createdBy":{
         "name":"Daniel Morris",
         "url":"http://www.dannymorris.org.uk"
      },
      "createdOn":"2013-11-09T17:57:07.057"
   },
   {
      "id":60,
      "name":"Blue Gray",
      "description":"A light blue gray take on the default map style. ",
      "url":"http://snazzymaps.com/style/60/blue-gray",
      "json":"[\r\n    {\r\n        \"featureType\": \"water\",\r\n        \"stylers\": [\r\n            {\r\n                \"visibility\": \"on\"\r\n            },\r\n            {\r\n                \"color\": \"#b5cbe4\"\r\n            }\r\n        ]\r\n    },\r\n    {\r\n        \"featureType\": \"landscape\",\r\n        \"stylers\": [\r\n            {\r\n                \"color\": \"#efefef\"\r\n            }\r\n        ]\r\n    },\r\n    {\r\n        \"featureType\": \"road.highway\",\r\n        \"elementType\": \"geometry\",\r\n        \"stylers\": [\r\n            {\r\n                \"color\": \"#83a5b0\"\r\n            }\r\n        ]\r\n    },\r\n    {\r\n        \"featureType\": \"road.arterial\",\r\n        \"elementType\": \"geometry\",\r\n        \"stylers\": [\r\n            {\r\n                \"color\": \"#bdcdd3\"\r\n            }\r\n        ]\r\n    },\r\n    {\r\n        \"featureType\": \"road.local\",\r\n        \"elementType\": \"geometry\",\r\n        \"stylers\": [\r\n            {\r\n                \"color\": \"#ffffff\"\r\n            }\r\n        ]\r\n    },\r\n    {\r\n        \"featureType\": \"poi.park\",\r\n        \"elementType\": \"geometry\",\r\n        \"stylers\": [\r\n            {\r\n                \"color\": \"#e3eed3\"\r\n            }\r\n        ]\r\n    },\r\n    {\r\n        \"featureType\": \"administrative\",\r\n        \"stylers\": [\r\n            {\r\n                \"visibility\": \"on\"\r\n            },\r\n            {\r\n                \"lightness\": 33\r\n            }\r\n        ]\r\n    },\r\n    {\r\n        \"featureType\": \"road\"\r\n    },\r\n    {\r\n        \"featureType\": \"poi.park\",\r\n        \"elementType\": \"labels\",\r\n        \"stylers\": [\r\n            {\r\n                \"visibility\": \"on\"\r\n            },\r\n            {\r\n                \"lightness\": 20\r\n            }\r\n        ]\r\n    },\r\n    {},\r\n    {\r\n        \"featureType\": \"road\",\r\n        \"stylers\": [\r\n            {\r\n                \"lightness\": 20\r\n            }\r\n        ]\r\n    }\r\n]",
      "views":1522,
      "createdBy":{
         "name":"Grace",
         "url":"http://snazzymaps.com"
      },
      "createdOn":"2014-01-28T15:17:37.06"
   },
   {
      "id":47,
      "name":"Nature",
      "description":"A nature inspired style with green features on a grey landscape.",
      "url":"http://snazzymaps.com/style/47/nature",
      "json":"[\r\n\t{\r\n\t\t\"featureType\": \"landscape\",\r\n\t\t\"stylers\": [\r\n\t\t\t{\r\n\t\t\t\t\"hue\": \"#FFA800\"\r\n\t\t\t},\r\n\t\t\t{\r\n\t\t\t\t\"saturation\": 0\r\n\t\t\t},\r\n\t\t\t{\r\n\t\t\t\t\"lightness\": 0\r\n\t\t\t},\r\n\t\t\t{\r\n\t\t\t\t\"gamma\": 1\r\n\t\t\t}\r\n\t\t]\r\n\t},\r\n\t{\r\n\t\t\"featureType\": \"road.highway\",\r\n\t\t\"stylers\": [\r\n\t\t\t{\r\n\t\t\t\t\"hue\": \"#53FF00\"\r\n\t\t\t},\r\n\t\t\t{\r\n\t\t\t\t\"saturation\": -73\r\n\t\t\t},\r\n\t\t\t{\r\n\t\t\t\t\"lightness\": 40\r\n\t\t\t},\r\n\t\t\t{\r\n\t\t\t\t\"gamma\": 1\r\n\t\t\t}\r\n\t\t]\r\n\t},\r\n\t{\r\n\t\t\"featureType\": \"road.arterial\",\r\n\t\t\"stylers\": [\r\n\t\t\t{\r\n\t\t\t\t\"hue\": \"#FBFF00\"\r\n\t\t\t},\r\n\t\t\t{\r\n\t\t\t\t\"saturation\": 0\r\n\t\t\t},\r\n\t\t\t{\r\n\t\t\t\t\"lightness\": 0\r\n\t\t\t},\r\n\t\t\t{\r\n\t\t\t\t\"gamma\": 1\r\n\t\t\t}\r\n\t\t]\r\n\t},\r\n\t{\r\n\t\t\"featureType\": \"road.local\",\r\n\t\t\"stylers\": [\r\n\t\t\t{\r\n\t\t\t\t\"hue\": \"#00FFFD\"\r\n\t\t\t},\r\n\t\t\t{\r\n\t\t\t\t\"saturation\": 0\r\n\t\t\t},\r\n\t\t\t{\r\n\t\t\t\t\"lightness\": 30\r\n\t\t\t},\r\n\t\t\t{\r\n\t\t\t\t\"gamma\": 1\r\n\t\t\t}\r\n\t\t]\r\n\t},\r\n\t{\r\n\t\t\"featureType\": \"water\",\r\n\t\t\"stylers\": [\r\n\t\t\t{\r\n\t\t\t\t\"hue\": \"#00BFFF\"\r\n\t\t\t},\r\n\t\t\t{\r\n\t\t\t\t\"saturation\": 6\r\n\t\t\t},\r\n\t\t\t{\r\n\t\t\t\t\"lightness\": 8\r\n\t\t\t},\r\n\t\t\t{\r\n\t\t\t\t\"gamma\": 1\r\n\t\t\t}\r\n\t\t]\r\n\t},\r\n\t{\r\n\t\t\"featureType\": \"poi\",\r\n\t\t\"stylers\": [\r\n\t\t\t{\r\n\t\t\t\t\"hue\": \"#679714\"\r\n\t\t\t},\r\n\t\t\t{\r\n\t\t\t\t\"saturation\": 33.4\r\n\t\t\t},\r\n\t\t\t{\r\n\t\t\t\t\"lightness\": -25.4\r\n\t\t\t},\r\n\t\t\t{\r\n\t\t\t\t\"gamma\": 1\r\n\t\t\t}\r\n\t\t]\r\n\t}\r\n\r\n]",
      "views":1484,
      "createdBy":{
         "name":"Tanja Lederer",
         "url":"http://www.ergotherapie-lederer.de/"
      },
      "createdOn":"2013-12-09T22:08:05.067"
   },
   {
      "id":14,
      "name":"Vintage",
      "description":"A dark two-tone map with a striking red color against a dark grey.",
      "url":"http://snazzymaps.com/style/14/vintage",
      "json":"[{\"stylers\": [{ \"visibility\": \"off\" }]},{\"featureType\": \"water\",\"stylers\": [{ \"visibility\": \"on\" },{ \"color\": \"#2f343b\" }]},{\"featureType\": \"landscape\",\"stylers\": [{ \"visibility\": \"on\" },{ \"color\": \"#703030\" }]},{\"featureType\": \"administrative\",\"elementType\": \"geometry.stroke\",\"stylers\": [{ \"visibility\": \"on\" },{ \"color\": \"#2f343b\" },{ \"weight\": 1 }]}]",
      "views":1471,
      "createdBy":{
         "name":"Adam Krogh",
         "url":"http://atmist.com"
      },
      "createdOn":"2013-10-30T04:27:54.58"
   },
   {
      "id":28,
      "name":"Bluish",
      "description":"It's a light and simple blue map. With reduced labels.",
      "url":"http://snazzymaps.com/style/28/bluish",
      "json":"[ {\r\n\t\t\t\"stylers\": [\r\n\t\t\t  { \"hue\": \"#007fff\" },\r\n\t\t\t  { \"saturation\": 89 }\r\n\t\t\t]\r\n\t\t  },{\r\n\t\t\t\"featureType\": \"water\",\r\n\t\t\t\"stylers\": [\r\n\t\t\t  { \"color\": \"#ffffff\" }\r\n\t\t\t]\r\n\t\t  },{\r\n\t\t\t\"featureType\": \"administrative.country\",\r\n\t\t\t\"elementType\": \"labels\",\r\n\t\t\t\"stylers\": [\r\n\t\t\t  { \"visibility\": \"off\" }\r\n\t\t\t]\r\n\t\t  }\r\n]",
      "views":1381,
      "createdBy":{
         "name":"Stefan",
         "url":"http://perfekterholzschutz.de"
      },
      "createdOn":"2013-11-07T15:15:36.32"
   },
   {
      "id":61,
      "name":"Blue Essence",
      "description":"A light blue style that helps you focus on content on the map.\r\nGreat if you use lots of pins and want to have highlighted transportation systems.",
      "url":"http://snazzymaps.com/style/61/blue-essence",
      "json":"[\r\n    {\r\n        featureType: \"landscape.natural\",\r\n        elementType: \"geometry.fill\",\r\n        stylers: [\r\n            { \"visibility\": \"on\" },\r\n            { \"color\": \"#e0efef\" }\r\n        ]\r\n    },{\r\n        featureType: \"poi\",\r\n        elementType: \"geometry.fill\",\r\n        stylers: [\r\n            { \"visibility\": \"on\" },\r\n            { \"hue\": \"#1900ff\" },\r\n            { \"color\": \"#c0e8e8\" }\r\n        ]\r\n    },{\r\n        //buildings\r\n        featureType: \"landscape.man_made\",\r\n        elementType: \"geometry.fill\"\r\n    },{\r\n        featureType: \"road\",\r\n        elementType: \"geometry\",\r\n            stylers: [\r\n                { lightness: 100 },\r\n                { visibility: \"simplified\" }\r\n            ]\r\n    },{\r\n        featureType: \"road\",\r\n        elementType: \"labels\",\r\n        stylers: [\r\n            { visibility: \"off\" }\r\n        ]\r\n    },{\r\n        featureType: 'water',\r\n        stylers: [\r\n            { color: '#7dcdcd' }\r\n        ]\r\n    },{\r\n        featureType: 'transit.line',\r\n        elementType: 'geometry',\r\n        stylers: [\r\n            { visibility: 'on' },\r\n            { lightness: 700 }\r\n        ]\r\n    }\r\n]",
      "views":1217,
      "createdBy":{
         "name":"Evo",
         "url":"http://reactorio.github.io"
      },
      "createdOn":"2014-01-28T20:24:12.717"
   },
   {
      "id":52,
      "name":"Souldisco",
      "description":"A nice, clean and simple gray & green map that is cool for the eyes.",
      "url":"http://snazzymaps.com/style/52/souldisco",
      "json":"[ { \"stylers\": [ { \"saturation\": -100 }, { \"gamma\": 0.8 }, { \"lightness\": 4 }, { \"visibility\": \"on\" } ] },{ \"featureType\": \"landscape.natural\", \"stylers\": [ { \"visibility\": \"on\" }, { \"color\": \"#5dff00\" }, { \"gamma\": 4.97 }, { \"lightness\": -5 }, { \"saturation\": 100 } ] } ]",
      "views":1167,
      "createdBy":{
         "name":"Codespacing",
         "url":"http://www.codespacing.com/"
      },
      "createdOn":"2014-01-06T19:36:28.403"
   },
   {
      "id":9,
      "name":"Chilled",
      "description":"Example provided by Google showcasing their style API.",
      "url":"http://snazzymaps.com/style/9/chilled",
      "json":"[{  featureType: 'road',  elementType: 'geometry',  stylers: [{'visibility': 'simplified'}]}, {  featureType: 'road.arterial',  stylers: [   {hue: 149},   {saturation: -78},   {lightness: 0}  ]}, {  featureType: 'road.highway',  stylers: [{hue: -31},{saturation: -40},{lightness: 2.8}  ]}, {  featureType: 'poi',  elementType: 'label',  stylers: [{'visibility': 'off'}]}, {  featureType: 'landscape',  stylers: [{hue: 163},{saturation: -26},{lightness: -1.1}  ]}, {  featureType: 'transit',  stylers: [{'visibility': 'off'}]}, {  featureType: 'water',stylers: [{hue: 3},{saturation: -24.24},{lightness: -38.57}  ]}  ]",
      "views":1161,
      "createdBy":{
         "name":"Google",
         "url":"http://maps-api-tt.appspot.com/apilite/styled/styled.html"
      },
      "createdOn":"2013-10-24T22:54:44.31"
   },
   {
      "id":26,
      "name":"Vintage Blue",
      "description":"A cool style that hides all those pesky roads in favour of a simple contrasting blue/grey/yellow color scheme.",
      "url":"http://snazzymaps.com/style/26/vintage-blue",
      "json":"[\r\n  {\r\n    \"featureType\": \"road\",\r\n    \"stylers\": [\r\n      { \"visibility\": \"off\" }\r\n    ]\r\n  },\r\n  {\r\n    \"featureType\": \"transit\",\r\n    \"stylers\": [\r\n      { \"visibility\": \"off\" }\r\n    ]\r\n  },\r\n  {\r\n    \"featureType\": \"administrative.province\",\r\n    \"stylers\": [\r\n      { \"visibility\": \"off\" }\r\n    ]\r\n  },\r\n  {\r\n    \"featureType\": \"poi.park\",\r\n    \"elementType\": \"geometry\",\r\n    \"stylers\": [\r\n      { \"visibility\": \"off\" }\r\n    ]\r\n  },\r\n  {\r\n    \"featureType\": \"water\",\r\n    \"stylers\": [\r\n      { \"color\": \"#004b76\" }\r\n    ]\r\n  },\r\n  {\r\n    \"featureType\": \"landscape.natural\",\r\n    \"stylers\": [\r\n      { \"visibility\": \"on\" },\r\n      { \"color\": \"#fff6cb\" }\r\n    ]\r\n  },\r\n  {\r\n    \"featureType\": \"administrative.country\",\r\n    \"elementType\": \"geometry.stroke\",\r\n    \"stylers\": [\r\n      { \"visibility\": \"on\" },\r\n      { \"color\": \"#7f7d7a\" },\r\n      { \"lightness\": 10 },\r\n      { \"weight\": 1 }\r\n    ]\r\n  }\r\n]",
      "views":1136,
      "createdBy":{
         "name":"onespacemedia",
         "url":"http://www.africauncovered.com"
      },
      "createdOn":"2013-11-05T20:32:04.443"
   },
   {
      "id":24,
      "name":"Hot Pink",
      "description":"Could a Google Map theme be naughty?!\r\n\r\nGreat for website with dark themes.",
      "url":"http://snazzymaps.com/style/24/hot-pink",
      "json":"[\r\n\t{\r\n\t\t\"stylers\": [\r\n\t\t\t{ \"hue\": \"#ff61a6\" },\r\n\t\t\t{ \"visibility\": \"on\" },\r\n\t\t\t{ \"invert_lightness\": true },\r\n\t\t\t{ \"saturation\": 40 },\r\n\t\t\t{ \"lightness\": 10 }\r\n\t\t]\r\n\t}\r\n]",
      "views":1072,
      "createdBy":{
         "name":"Gregory Pratt",
         "url":"https://www.goingoutapp.co.uk"
      },
      "createdOn":"2013-11-05T16:07:42.847"
   },
   {
      "id":4,
      "name":"Tripitty",
      "description":"A two-tone map with no labels. Best viewed when zoomed out to display continents and oceans.",
      "url":"http://snazzymaps.com/style/4/tripitty",
      "json":"[ { featureType: 'water', elementType: 'all', stylers: [ { color: '#193a70' }, { visibility: 'on' } ] }, { featureType: 'road', stylers: [ { 'visibility': 'off' } ] }, { featureType: 'transit', stylers: [ { 'visibility': 'off' } ] },{ featureType: 'administrative', stylers: [ { 'visibility': 'off' } ] }, { featureType: 'landscape', elementType: 'all', stylers: [ { 'color': '#2c5ca5' } ] },{ featureType: 'poi', stylers: [ { 'color': '#2c5ca5' } ] }, { elementType: 'labels', stylers: [ { 'visibility': 'off' } ] } ]",
      "views":1033,
      "createdBy":{
         "name":"Adam Krogh",
         "url":"http://tripitty.com"
      },
      "createdOn":"2013-10-24T22:54:38.407"
   },
   {
      "id":74,
      "name":"becomeadinosaur",
      "description":"A clean and flat style.",
      "url":"http://snazzymaps.com/style/74/becomeadinosaur",
      "json":"[\r\n  {\r\n    \"elementType\": \"labels.text\",\r\n    \"stylers\": [\r\n      { \"visibility\": \"off\" }\r\n    ]\r\n  },{\r\n    \"featureType\": \"landscape.natural\",\r\n    \"elementType\": \"geometry.fill\",\r\n    \"stylers\": [\r\n      { \"color\": \"#f5f5f2\" },\r\n      { \"visibility\": \"on\" }\r\n    ]\r\n  },{\r\n    \"featureType\": \"administrative\",\r\n    \"stylers\": [\r\n      { \"visibility\": \"off\" }\r\n    ]\r\n  },{\r\n    \"featureType\": \"transit\",\r\n    \"stylers\": [\r\n      { \"visibility\": \"off\" }\r\n    ]\r\n  },{\r\n    \"featureType\": \"poi.attraction\",\r\n    \"stylers\": [\r\n      { \"visibility\": \"off\" }\r\n    ]\r\n  },{\r\n    \"featureType\": \"landscape.man_made\",\r\n    \"elementType\": \"geometry.fill\",\r\n    \"stylers\": [\r\n      { \"color\": \"#ffffff\" },\r\n      { \"visibility\": \"on\" }\r\n    ]\r\n  },{\r\n    \"featureType\": \"poi.business\",\r\n    \"stylers\": [\r\n      { \"visibility\": \"off\" }\r\n    ]\r\n  },{\r\n    \"featureType\": \"poi.medical\",\r\n    \"stylers\": [\r\n      { \"visibility\": \"off\" }\r\n    ]\r\n  },{\r\n    \"featureType\": \"poi.place_of_worship\",\r\n    \"stylers\": [\r\n      { \"visibility\": \"off\" }\r\n    ]\r\n  },{\r\n    \"featureType\": \"poi.school\",\r\n    \"stylers\": [\r\n      { \"visibility\": \"off\" }\r\n    ]\r\n  },{\r\n    \"featureType\": \"poi.sports_complex\",\r\n    \"stylers\": [\r\n      { \"visibility\": \"off\" }\r\n    ]\r\n  },{\r\n    \"featureType\": \"road.highway\",\r\n    \"elementType\": \"geometry\",\r\n    \"stylers\": [\r\n      { \"color\": \"#ffffff\" },\r\n      { \"visibility\": \"simplified\" }\r\n    ]\r\n  },{\r\n    \"featureType\": \"road.arterial\",\r\n    \"stylers\": [\r\n      { \"visibility\": \"simplified\" },\r\n      { \"color\": \"#ffffff\" }\r\n    ]\r\n  },{\r\n    \"featureType\": \"road.highway\",\r\n    \"elementType\": \"labels.icon\",\r\n    \"stylers\": [\r\n      { \"color\": \"#ffffff\" },\r\n      { \"visibility\": \"off\" }\r\n    ]\r\n  },{\r\n    \"featureType\": \"road.highway\",\r\n    \"elementType\": \"labels.icon\",\r\n    \"stylers\": [\r\n      { \"visibility\": \"off\" }\r\n    ]\r\n  },{\r\n    \"featureType\": \"road.arterial\",\r\n    \"stylers\": [\r\n      { \"color\": \"#ffffff\" }\r\n    ]\r\n  },{\r\n    \"featureType\": \"road.local\",\r\n    \"stylers\": [\r\n      { \"color\": \"#ffffff\" }\r\n    ]\r\n  },{\r\n    \"featureType\": \"poi.park\",\r\n    \"elementType\": \"labels.icon\",\r\n    \"stylers\": [\r\n      { \"visibility\": \"off\" }\r\n    ]\r\n  },{\r\n    \"featureType\": \"poi\",\r\n    \"elementType\": \"labels.icon\",\r\n    \"stylers\": [\r\n      { \"visibility\": \"off\" }\r\n    ]\r\n  },{\r\n    \"featureType\": \"water\",\r\n    \"stylers\": [\r\n      { \"color\": \"#71c8d4\" }\r\n    ]\r\n  },{\r\n    \"featureType\": \"landscape\",\r\n    \"stylers\": [\r\n      { \"color\": \"#e5e8e7\" }\r\n    ]\r\n  },{\r\n    \"featureType\": \"poi.park\",\r\n    \"stylers\": [\r\n      { \"color\": \"#8ba129\" }\r\n    ]\r\n  },{\r\n    \"featureType\": \"road\",\r\n    \"stylers\": [\r\n      { \"color\": \"#ffffff\" }\r\n    ]\r\n  },{\r\n    \"featureType\": \"poi.sports_complex\",\r\n    \"elementType\": \"geometry\",\r\n    \"stylers\": [\r\n      { \"color\": \"#c7c7c7\" },\r\n      { \"visibility\": \"off\" }\r\n    ]\r\n  },{\r\n    \"featureType\": \"water\",\r\n    \"stylers\": [\r\n      { \"color\": \"#a0d3d3\" }\r\n    ]\r\n  },{\r\n    \"featureType\": \"poi.park\",\r\n    \"stylers\": [\r\n      { \"color\": \"#91b65d\" }\r\n    ]\r\n  },{\r\n    \"featureType\": \"poi.park\",\r\n    \"stylers\": [\r\n      { \"gamma\": 1.51 }\r\n    ]\r\n  },{\r\n    \"featureType\": \"road.local\",\r\n    \"stylers\": [\r\n      { \"visibility\": \"off\" }\r\n    ]\r\n  },{\r\n    \"featureType\": \"road.local\",\r\n    \"elementType\": \"geometry\",\r\n    \"stylers\": [\r\n      { \"visibility\": \"on\" }\r\n    ]\r\n  },{\r\n    \"featureType\": \"poi.government\",\r\n    \"elementType\": \"geometry\",\r\n    \"stylers\": [\r\n      { \"visibility\": \"off\" }\r\n    ]\r\n  },{\r\n    \"featureType\": \"landscape\",\r\n    \"stylers\": [\r\n      { \"visibility\": \"off\" }\r\n    ]\r\n  },{\r\n    \"featureType\": \"road\",\r\n    \"elementType\": \"labels\",\r\n    \"stylers\": [\r\n      { \"visibility\": \"off\" }\r\n    ]\r\n  },{\r\n    \"featureType\": \"road.arterial\",\r\n    \"elementType\": \"geometry\",\r\n    \"stylers\": [\r\n      { \"visibility\": \"simplified\" }\r\n    ]\r\n  },{\r\n    \"featureType\": \"road.local\",\r\n    \"stylers\": [\r\n      { \"visibility\": \"simplified\" }\r\n    ]\r\n  },{\r\n    \"featureType\": \"road\"  },{\r\n    \"featureType\": \"road\"  },{\r\n  },{\r\n    \"featureType\": \"road.highway\"  }\r\n]",
      "views":1024,
      "createdBy":{
         "name":"becomeadinosaur",
         "url":"http://snazzymaps.com"
      },
      "createdOn":"2014-02-28T15:11:28.38"
   },
   {
      "id":46,
      "name":"Homage to Toner",
      "description":"A high-contrast B&W style similar to the Stamen-designed \"Toner\" basemap",
      "url":"http://snazzymaps.com/style/46/homage-to-toner",
      "json":"[\r\n                {\r\n                    featureType: 'water',\r\n                    elementType: 'all',\r\n                    stylers: [\r\n                        { hue: '#000000' },\r\n                        { saturation: -100 },\r\n                        { lightness: -100 },\r\n                        { visibility: 'simplified' }\r\n                    ]\r\n                },{\r\n                    featureType: 'landscape',\r\n                    elementType: 'all',\r\n                    stylers: [\r\n                        { hue: '#FFFFFF' },\r\n                        { saturation: -100 },\r\n                        { lightness: 100 },\r\n                        { visibility: 'simplified' }\r\n                    ]\r\n                },{\r\n                    featureType: 'landscape.man_made',\r\n                    elementType: 'all',\r\n                    stylers: [\r\n\r\n                    ]\r\n                },{\r\n                    featureType: 'landscape.natural',\r\n                    elementType: 'all',\r\n                    stylers: [\r\n\r\n                    ]\r\n                },{\r\n                    featureType: 'poi.park',\r\n                    elementType: 'geometry',\r\n                    stylers: [\r\n                        { hue: '#ffffff' },\r\n                        { saturation: -100 },\r\n                        { lightness: 100 },\r\n                        { visibility: 'off' }\r\n                    ]\r\n                },{\r\n                    featureType: 'road',\r\n                    elementType: 'all',\r\n                    stylers: [\r\n                        { hue: '#333333' },\r\n                        { saturation: -100 },\r\n                        { lightness: -69 },\r\n                        { visibility: 'simplified' }\r\n                    ]\r\n                },{\r\n                    featureType: 'poi.attraction',\r\n                    elementType: 'geometry',\r\n                    stylers: [\r\n                        { hue: '#ffffff' },\r\n                        { saturation: -100 },\r\n                        { lightness: 100 },\r\n                        { visibility: 'off' }\r\n                    ]\r\n                },{\r\n                    featureType: 'administrative.locality',\r\n                    elementType: 'geometry',\r\n                    stylers: [\r\n                        { hue: '#ffffff' },\r\n                        { saturation: 0 },\r\n                        { lightness: 100 },\r\n                        { visibility: 'off' }\r\n                    ]\r\n                },{\r\n                    featureType: 'poi.government',\r\n                    elementType: 'geometry',\r\n                    stylers: [\r\n                        { hue: '#ffffff' },\r\n                        { saturation: -100 },\r\n                        { lightness: 100 },\r\n                        { visibility: 'off' }\r\n                    ]\r\n                }\r\n            ]",
      "views":1009,
      "createdBy":{
         "name":"Bill Morris",
         "url":"http://geosprocket.io"
      },
      "createdOn":"2013-12-02T15:37:35.36"
   },
   {
      "id":41,
      "name":"Hints of Gold",
      "description":"Shades of grey with subtle hints of golden tags.",
      "url":"http://snazzymaps.com/style/41/hints-of-gold",
      "json":"[\r\n\t\t\t{\r\n\t\t\t\tfeatureType: 'water',\r\n\t\t\t\telementType: 'all',\r\n\t\t\t\tstylers: [\r\n\t\t\t\t\t{ hue: '#252525' },\r\n\t\t\t\t\t{ saturation: -100 },\r\n\t\t\t\t\t{ lightness: -81 },\r\n\t\t\t\t\t{ visibility: 'on' }\r\n\t\t\t\t]\r\n\t\t\t},{\r\n\t\t\t\tfeatureType: 'landscape',\r\n\t\t\t\telementType: 'all',\r\n\t\t\t\tstylers: [\r\n\t\t\t\t\t{ hue: '#666666' },\r\n\t\t\t\t\t{ saturation: -100 },\r\n\t\t\t\t\t{ lightness: -55 },\r\n\t\t\t\t\t{ visibility: 'on' }\r\n\t\t\t\t]\r\n\t\t\t},{\r\n\t\t\t\tfeatureType: 'poi',\r\n\t\t\t\telementType: 'geometry',\r\n\t\t\t\tstylers: [\r\n\t\t\t\t\t{ hue: '#555555' },\r\n\t\t\t\t\t{ saturation: -100 },\r\n\t\t\t\t\t{ lightness: -57 },\r\n\t\t\t\t\t{ visibility: 'on' }\r\n\t\t\t\t]\r\n\t\t\t},{\r\n\t\t\t\tfeatureType: 'road',\r\n\t\t\t\telementType: 'all',\r\n\t\t\t\tstylers: [\r\n\t\t\t\t\t{ hue: '#777777' },\r\n\t\t\t\t\t{ saturation: -100 },\r\n\t\t\t\t\t{ lightness: -6 },\r\n\t\t\t\t\t{ visibility: 'on' }\r\n\t\t\t\t]\r\n\t\t\t},{\r\n\t\t\t\tfeatureType: 'administrative',\r\n\t\t\t\telementType: 'all',\r\n\t\t\t\tstylers: [\r\n\t\t\t\t\t{ hue: '#cc9900' },\r\n\t\t\t\t\t{ saturation: 100 },\r\n\t\t\t\t\t{ lightness: -22 },\r\n\t\t\t\t\t{ visibility: 'on' }\r\n\t\t\t\t]\r\n\t\t\t},{\r\n\t\t\t\tfeatureType: 'transit',\r\n\t\t\t\telementType: 'all',\r\n\t\t\t\tstylers: [\r\n\t\t\t\t\t{ hue: '#444444' },\r\n\t\t\t\t\t{ saturation: 0 },\r\n\t\t\t\t\t{ lightness: -64 },\r\n\t\t\t\t\t{ visibility: 'off' }\r\n\t\t\t\t]\r\n\t\t\t},{\r\n\t\t\t\tfeatureType: 'poi',\r\n\t\t\t\telementType: 'labels',\r\n\t\t\t\tstylers: [\r\n\t\t\t\t\t{ hue: '#555555' },\r\n\t\t\t\t\t{ saturation: -100 },\r\n\t\t\t\t\t{ lightness: -57 },\r\n\t\t\t\t\t{ visibility: 'off' }\r\n\t\t\t\t]\r\n\t\t\t}\r\n\t\t]",
      "views":1006,
      "createdBy":{
         "name":"Johnathan Miller",
         "url":"http://johnathanmiller.com"
      },
      "createdOn":"2013-11-20T17:56:28.173"
   },
   {
      "id":58,
      "name":"Simple Labels",
      "description":"A simple and clean map. Removed elements include all street names, points of interest icons and text, and public transit labels. ",
      "url":"http://snazzymaps.com/style/58/simple-labels",
      "json":"[\r\n  {\r\n    \"featureType\": \"road\",\r\n    \"elementType\": \"labels\",\r\n    \"stylers\": [\r\n      { \"visibility\": \"off\" }\r\n    ]\r\n  },{\r\n    \"featureType\": \"poi\",\r\n    \"elementType\": \"labels\",\r\n    \"stylers\": [\r\n      { \"visibility\": \"off\" }\r\n    ]\r\n  },{\r\n    \"featureType\": \"transit\",\r\n    \"elementType\": \"labels.text\",\r\n    \"stylers\": [\r\n      { \"visibility\": \"off\" }\r\n    ]\r\n  }\r\n]",
      "views":886,
      "createdBy":{
         "name":"wjw",
         "url":"http://snazzymaps.com"
      },
      "createdOn":"2014-01-28T15:15:04.87"
   },
   {
      "id":10,
      "name":"Mixed",
      "description":"Example provided by Google showcasing their style API.",
      "url":"http://snazzymaps.com/style/10/mixed",
      "json":"[{  featureType: 'landscape',  stylers: [{hue: '#00dd00'}]}, {  featureType: 'road',  stylers: [{hue: '#dd0000'}]}, {  featureType: 'water',  stylers: [{hue: '#000040'}]}, {  featureType: 'poi.park',  stylers: [{visibility: 'off'}]}, {  featureType: 'road.arterial',  stylers: [{hue: '#ffff00'}]}, {  featureType: 'road.local',  stylers: [{visibility: 'off'}]}  ]",
      "views":878,
      "createdBy":{
         "name":"Google",
         "url":"http://maps-api-tt.appspot.com/apilite/styled/styled.html"
      },
      "createdOn":"2013-10-24T22:54:45.353"
   },
   {
      "id":48,
      "name":"Hard edges",
      "description":"Hard Black and White palette, with a hint of color on the smaller scales.",
      "url":"http://snazzymaps.com/style/48/hard-edges",
      "json":"[\r\n  {\r\n    \"featureType\": \"landscape.natural\",\r\n    \"stylers\": [\r\n      { \"saturation\": -100 },\r\n      { \"lightness\": 100 }\r\n    ]\r\n  },{\r\n    \"featureType\": \"water\",\r\n    \"stylers\": [\r\n      { \"saturation\": -100 },\r\n      { \"lightness\": -86 }\r\n    ]\r\n  },{\r\n    \"elementType\": \"labels.text.stroke\",\r\n    \"stylers\": [\r\n      { \"saturation\": -100 },\r\n      { \"lightness\": 100 }\r\n    ]\r\n  },{\r\n    \"featureType\": \"road\",\r\n    \"elementType\": \"geometry.stroke\",\r\n    \"stylers\": [\r\n      { \"saturation\": -100 },\r\n      { \"lightness\": -75 }\r\n    ]\r\n  },{\r\n    \"featureType\": \"road\",\r\n    \"elementType\": \"geometry.fill\",\r\n    \"stylers\": [\r\n      { \"saturation\": -100 },\r\n      { \"lightness\": 97 }\r\n    ]\r\n  },{\r\n    \"featureType\": \"poi.park\",\r\n    \"stylers\": [\r\n      { \"saturation\": -100 },\r\n      { \"lightness\": -100 }\r\n    ]\r\n  },{\r\n    \"featureType\": \"poi.park\",\r\n    \"elementType\": \"labels.text.fill\",\r\n    \"stylers\": [\r\n      { \"saturation\": -100 },\r\n      { \"lightness\": 100 }\r\n    ]\r\n  },{\r\n    \"featureType\": \"road\",\r\n    \"elementType\": \"labels\",\r\n    \"stylers\": [\r\n      { \"visibility\": \"on\" }\r\n    ]\r\n  },{\r\n    \"featureType\": \"landscape.man_made\",\r\n    \"stylers\": [\r\n      { \"saturation\": -100 },\r\n      { \"lightness\": -68 }\r\n    ]\r\n  },{\r\n    \"featureType\": \"administrative\",\r\n    \"elementType\": \"labels.text.fill\",\r\n    \"stylers\": [\r\n      { \"saturation\": -100 },\r\n      { \"lightness\": 100 }\r\n    ]\r\n  },{\r\n    \"featureType\": \"administrative\",\r\n    \"elementType\": \"labels.text.stroke\",\r\n    \"stylers\": [\r\n      { \"saturation\": -100 },\r\n      { \"lightness\": -100 }\r\n    ]\r\n  },{\r\n    \"featureType\": \"poi\",\r\n    \"stylers\": [\r\n      { \"saturation\": -100 },\r\n      { \"lightness\": 91 }\r\n    ]\r\n  },{\r\n    \"featureType\": \"poi\",\r\n    \"elementType\": \"labels.text.fill\",\r\n    \"stylers\": [\r\n      { \"saturation\": -100 },\r\n      { \"lightness\": -100 }\r\n    ]\r\n  },{\r\n    \"featureType\": \"transit.station\",\r\n    \"stylers\": [\r\n      { \"saturation\": -100 },\r\n      { \"lightness\": -22 }\r\n    ]\r\n  },{\r\n    \"featureType\": \"landscape.man_made\",\r\n    \"elementType\": \"geometry.stroke\",\r\n    \"stylers\": [\r\n      { \"hue\": \"#ff004c\" },\r\n      { \"saturation\": -100 },\r\n      { \"lightness\": 44 }\r\n    ]\r\n  },{\r\n    \"elementType\": \"labels.text.fill\",\r\n    \"stylers\": [\r\n      { \"saturation\": 1 },\r\n      { \"lightness\": -100 }\r\n    ]\r\n  },{\r\n    \"elementType\": \"labels.text.stroke\",\r\n    \"stylers\": [\r\n      { \"saturation\": -100 },\r\n      { \"lightness\": 100 }\r\n    ]\r\n  },{\r\n    \"featureType\": \"administrative.locality\",\r\n    \"elementType\": \"labels\",\r\n    \"stylers\": [\r\n      { \"visibility\": \"off\" }\r\n    ]\r\n  },{\r\n    \"featureType\": \"water\",\r\n    \"elementType\": \"labels\",\r\n    \"stylers\": [\r\n      { \"visibility\": \"off\" }\r\n    ]\r\n  },\r\n{\r\n    \"featureType\": \"administrative.locality\",\r\n    \"elementType\": \"labels\",\r\n    \"stylers\": [\r\n      { \"visibility\": \"on\" }\r\n    ]\r\n  },{\r\n    \"featureType\": \"water\",\r\n    \"elementType\": \"labels\",\r\n    \"stylers\": [\r\n      { \"visibility\": \"on\" }\r\n    ]\r\n  }\r\n]",
      "views":872,
      "createdBy":{
         "name":"Marco Buetikfoer",
         "url":"http://www.postcom.name"
      },
      "createdOn":"2013-12-09T22:08:35.93"
   },
   {
      "id":40,
      "name":"Vitamin C",
      "description":"Inspired by the Adobe Kuler theme of the same name. Highlighted highways in bright orange on a blue and turquoise background.",
      "url":"http://snazzymaps.com/style/40/vitamin-c",
      "json":"[\r\n  {\r\n    \"featureType\": \"water\",\r\n    \"elementType\": \"geometry\",\r\n    \"stylers\": [\r\n      { \"color\": \"#004358\" }\r\n    ]\r\n  },{\r\n    \"featureType\": \"landscape\",\r\n    \"elementType\": \"geometry\",\r\n    \"stylers\": [\r\n      { \"color\": \"#1f8a70\" }\r\n    ]\r\n  },{\r\n    \"featureType\": \"poi\",\r\n    \"elementType\": \"geometry\",\r\n    \"stylers\": [\r\n      { \"color\": \"#1f8a70\" }\r\n    ]\r\n  },{\r\n    \"featureType\": \"road.highway\",\r\n    \"elementType\": \"geometry\",\r\n    \"stylers\": [\r\n      { \"color\": \"#fd7400\" }\r\n    ]\r\n  },{\r\n    \"featureType\": \"road.arterial\",\r\n    \"elementType\": \"geometry\",\r\n    \"stylers\": [\r\n      { \"color\": \"#1f8a70\" },\r\n      { \"lightness\": -20 }\r\n    ]\r\n  },{\r\n    \"featureType\": \"road.local\",\r\n    \"elementType\": \"geometry\",\r\n    \"stylers\": [\r\n      { \"color\": \"#1f8a70\" },\r\n      { \"lightness\": -17 }\r\n    ]\r\n  },{\r\n    \"elementType\": \"labels.text.stroke\",\r\n    \"stylers\": [\r\n      { \"color\": \"#ffffff\" },\r\n      { \"visibility\": \"on\" },\r\n      { \"weight\": 0.9 }\r\n    ]\r\n  },{\r\n    \"elementType\": \"labels.text.fill\",\r\n    \"stylers\": [\r\n      { \"visibility\": \"on\" },\r\n      { \"color\": \"#ffffff\" }\r\n    ]\r\n  },{\r\n    \"featureType\": \"poi\",\r\n    \"elementType\": \"labels\",\r\n    \"stylers\": [\r\n      { \"visibility\": \"simplified\" }\r\n    ]\r\n  },{\r\n    \"elementType\": \"labels.icon\",\r\n    \"stylers\": [\r\n      { \"visibility\": \"off\" }\r\n    ]\r\n  },{\r\n    \"featureType\": \"transit\",\r\n    \"elementType\": \"geometry\",\r\n    \"stylers\": [\r\n      { \"color\": \"#1f8a70\" },\r\n      { \"lightness\": -10 }\r\n    ]\r\n  },{\r\n  },{\r\n    \"featureType\": \"administrative\",\r\n    \"elementType\": \"geometry\",\r\n    \"stylers\": [\r\n      { \"color\": \"#1f8a70\" },\r\n      { \"weight\": 0.7 }\r\n    ]\r\n  }\r\n]",
      "views":834,
      "createdBy":{
         "name":"Adam Krogh",
         "url":"http://atmist.com"
      },
      "createdOn":"2013-11-19T02:52:40.237"
   },
   {
      "id":34,
      "name":"Neon World",
      "description":"A map with all elements at maxed out saturation. Neon and bright features are best visible when zoomed in.",
      "url":"http://snazzymaps.com/style/34/neon-world",
      "json":"[\r\n  {\r\n    \"stylers\": [\r\n      { \"saturation\": 100 },\r\n      { \"gamma\": 0.6 }\r\n    ]\r\n  }\r\n]",
      "views":815,
      "createdBy":{
         "name":"Adam Krogh",
         "url":"http://atmistlabs.com"
      },
      "createdOn":"2013-11-09T18:03:06.017"
   },
   {
      "id":11,
      "name":"Blue",
      "description":"Example provided by Google showcasing their style API.",
      "url":"http://snazzymaps.com/style/11/blue",
      "json":"[{  featureType: 'all',  stylers: [{hue: '#0000b0'},{invert_lightness: 'true'},{saturation: -30}  ]}  ]",
      "views":811,
      "createdBy":{
         "name":"Google",
         "url":"http://maps-api-tt.appspot.com/apilite/styled/styled.html"
      },
      "createdOn":"2013-10-24T22:54:46.133"
   },
   {
      "id":50,
      "name":"The Endless Atlas",
      "description":"Minimal style used in The Endless Atlas Project at www.endlessatlas.com. White sea, all the shades of gray, no state name and no boundaries. \r\nCome on, we are all humans!",
      "url":"http://snazzymaps.com/style/50/the-endless-atlas",
      "json":"[\r\n\t{\r\n    \t\tfeatureType: 'all',\r\n\t\telementType: 'labels.text.stroke',\r\n    \t\tstylers: [\r\n      \t\t\t{ hue: '#000000' },\r\n\t\t\t{ saturation: -100 },\r\n\t\t\t{ lightness: 100 },\r\n\t\t\t{ visibility: 'off' }\r\n    \t\t]\r\n  \t},{\r\n    \t\tfeatureType: 'all',\r\n\t\telementType: 'labels.icon',\r\n    \t\tstylers: [\r\n     \t\t\t{ hue: '#000000' },\r\n\t\t\t{ saturation: -100 },\r\n\t\t\t{ lightness: 100 },\r\n\t\t\t{ visibility: 'off' }\r\n   \t \t]\r\n  \t},{\r\n\t\tfeatureType: 'water',\r\n\t\telementType: 'all',\r\n\t\tstylers: [\r\n\t\t\t{ hue: '#000000' },\r\n\t\t\t{ saturation: -100 },\r\n\t\t\t{ lightness: 100 },\r\n\t\t\t{ visibility: 'on' }\r\n\t\t]\r\n\t},{\r\n\t\tfeatureType: 'landscape',\r\n\t\telementType: 'geometry',\r\n\t\tstylers: [\r\n\t\t\t{ hue: '#D1D3D4' },\r\n\t\t\t{ saturation: -88 },\r\n\t\t\t{ lightness: -7 },\r\n\t\t\t{ visibility: 'on' }\r\n\t\t]\r\n\t},{\r\n\t\tfeatureType: 'landscape',\r\n\t\telementType: 'labels',\r\n\t\tstylers: [\r\n\t\t\t{ hue: '#939598' },\r\n\t\t\t{ saturation: -91 },\r\n\t\t\t{ lightness: -34 },\r\n\t\t\t{ visibility: 'on' }\r\n\t\t]\r\n\t},{\r\n\t\tfeatureType: 'road',\r\n\t\telementType: 'geometry',\r\n\t\tstylers: [\r\n\t\t\t{ hue: '#414042' },\r\n\t\t\t{ saturation: -98 },\r\n\t\t\t{ lightness: -60 },\r\n\t\t\t{ visibility: 'on' }\r\n\t\t]\r\n\t},{\r\n\t\tfeatureType: 'poi',\r\n\t\telementType: 'all',\r\n\t\tstylers: [\r\n\t\t\t{ hue: '#E3EBE5' },\r\n\t\t\t{ saturation: -61 },\r\n\t\t\t{ lightness: 57 },\r\n\t\t\t{ visibility: 'off' }\r\n\t\t]\r\n\t},{\r\n\t\tfeatureType: 'poi.park',\r\n\t\telementType: 'geometry',\r\n\t\tstylers: [\r\n\t\t\t{ hue: '#E3EBE5' },\r\n\t\t\t{ saturation: -100 },\r\n\t\t\t{ lightness: 57 },\r\n\t\t\t{ visibility: 'on' }\r\n\t\t]\r\n\t},{\r\n        \tfeatureType: \"administrative\",\r\n        \telementType: \"geometry.fill\",\r\n        \tstylers: [\r\n          \t{ visibility: \"off\" }\r\n        \t]\r\n      \t},{\r\n\t\tfeatureType: 'administrative.country',\r\n\t\telementType: 'all',\r\n\t\tstylers: [\r\n\t\t\t{ hue: '#E3EBE5' },\r\n\t\t\t{ saturation: -100 },\r\n\t\t\t{ lightness: 81 },\r\n\t\t\t{ visibility: 'off' }\r\n\t\t]\r\n\t},{\r\n\t\tfeatureType: 'administrative.province',\r\n\t\telementType: 'all',\r\n\t\tstylers: [\r\n\t\t\t{ hue: '#E3EBE5' },\r\n\t\t\t{ saturation: -100 },\r\n\t\t\t{ lightness: 81 },\r\n\t\t\t{ visibility: 'off' }\r\n\t\t]\r\n\t},{\r\n\t\tfeatureType: 'administrative.locality',\r\n\t\telementType: 'geometry',\r\n\t\tstylers: [\r\n\t\t\t{ hue: '#FFFFFF' },\r\n\t\t\t{ saturation: 0 },\r\n\t\t\t{ lightness: 100 },\r\n\t\t\t{ visibility: 'on' }\r\n\t\t]\r\n\t},{\r\n\t\tfeatureType: 'administrative.locality',\r\n\t\telementType: 'labels',\r\n\t\tstylers: [\r\n\t\t\t{ hue: '#939598' },\r\n\t\t\t{ saturation: 2 },\r\n\t\t\t{ lightness: 59 },\r\n\t\t\t{ visibility: 'on' }\r\n\t\t]\r\n\t},{\r\n\t\tfeatureType: 'administrative.neighborhood',\r\n\t\telementType: 'labels',\r\n\t\tstylers: [\r\n\t\t\t{ hue: '#939598' },\r\n\t\t\t{ saturation: -100 },\r\n\t\t\t{ lightness: 16 },\r\n\t\t\t{ visibility: 'on' }\r\n\t\t]\r\n\t},{\r\n\t\tfeatureType: 'administrative.neighborhood',\r\n\t\telementType: 'all',\r\n\t\tstylers: [\r\n\t\t\t{ hue: '#939598' },\r\n\t\t\t{ saturation: -100 },\r\n\t\t\t{ lightness: 16 },\r\n\t\t\t{ visibility: 'on' }\r\n\t\t]\r\n\t},{\r\n\t\tfeatureType: 'administrative.land_parcel',\r\n\t\telementType: 'all',\r\n\t\tstylers: [\r\n\t\t\t{ hue: '#939598' },\r\n\t\t\t{ saturation: -100 },\r\n\t\t\t{ lightness: 16 },\r\n\t\t\t{ visibility: 'simplified' }\r\n\t\t]\r\n\t},{\r\n\t\tfeatureType: 'road.highway',\r\n\t\telementType: 'geometry',\r\n\t\tstylers: [\r\n\t\t\t{ hue: '#939598' },\r\n\t\t\t{ saturation: -98 },\r\n\t\t\t{ lightness: -8 },\r\n\t\t\t{ visibility: 'on' }\r\n\t\t]\r\n\t},{\r\n\t\tfeatureType: 'road.highway',\r\n\t\telementType: 'labels',\r\n\t\tstylers: [\r\n\t\t\t{ hue: '#FFFFFF' },\r\n\t\t\t{ saturation: -100 },\r\n\t\t\t{ lightness: 100 },\r\n\t\t\t{ visibility: 'off' }\r\n\t\t]\r\n\t},{\r\n\t\tfeatureType: 'road.arterial',\r\n\t\telementType: 'geometry',\r\n\t\tstylers: [\r\n\t\t\t{ hue: '#6D6E71' },\r\n\t\t\t{ saturation: -98 },\r\n\t\t\t{ lightness: -43 },\r\n\t\t\t{ visibility: 'on' }\r\n\t\t]\r\n\t},{\r\n\t\tfeatureType: 'road.arterial',\r\n\t\telementType: 'labels',\r\n\t\tstylers: [\r\n\t\t\t{ hue: '#FFFFFF' },\r\n\t\t\t{ saturation: -100 },\r\n\t\t\t{ lightness: 100 },\r\n\t\t\t{ visibility: 'off' }\r\n\t\t]\r\n\t},{\r\n\t\tfeatureType: 'road.local',\r\n\t\telementType: 'geometry',\r\n\t\tstylers: [\r\n\t\t\t{ hue: '#000000' },\r\n\t\t\t{ saturation: -100 },\r\n\t\t\t{ lightness: -100 },\r\n\t\t\t{ visibility: 'on' }\r\n\t\t]\r\n\t},{\r\n\t\tfeatureType: 'road.local',\r\n\t\telementType: 'labels',\r\n\t\tstylers: [\r\n\t\t\t{ hue: '#FFFFFF' },\r\n\t\t\t{ saturation: -100 },\r\n\t\t\t{ lightness: 100 },\r\n\t\t\t{ visibility: 'off' }\r\n\t\t]\r\n\t}\r\n]",
      "views":713,
      "createdBy":{
         "name":"Antonello Colaps",
         "url":"http://www.dopolavoro.org"
      },
      "createdOn":"2014-01-06T19:35:01.703"
   },
   {
      "id":77,
      "name":"Clean Cut",
      "description":"A clean and simple style for customizing your Google maps.",
      "url":"http://snazzymaps.com/style/77/clean-cut",
      "json":"[\r\n  {\r\n    featureType: \"road\",\r\n    elementType: \"geometry\",\r\n    stylers: [\r\n      { lightness: 100 },\r\n      { visibility: \"simplified\" }\r\n    ]\r\n  },{\r\n   \"featureType\": \"water\",\r\n        \"elementType\": \"geometry\",\r\n        \"stylers\": [\r\n            {\r\n                \"visibility\": \"on\"\r\n            },\r\n            {\r\n                \"color\": \"#C6E2FF\",\r\n            }\r\n        ]\r\n    }, {\r\n        \"featureType\": \"poi\",\r\n        \"elementType\": \"geometry.fill\",\r\n        \"stylers\": [\r\n            {\r\n                \"color\": \"#C5E3BF\"\r\n            }\r\n        ]\r\n    },{\r\n        \"featureType\": \"road\",\r\n        \"elementType\": \"geometry.fill\",\r\n        \"stylers\": [\r\n            {\r\n                \"color\": \"#D1D1B8\"\r\n            }\r\n        ]\r\n    }\r\n]",
      "views":709,
      "createdBy":{
         "name":"Scott Marshall",
         "url":"http://marshall-design.com"
      },
      "createdOn":"2014-02-28T15:15:48.527"
   },
   {
      "id":23,
      "name":"Bates Green",
      "description":"A nice, simple green version of the map.",
      "url":"http://snazzymaps.com/style/23/bates-green",
      "json":" [{\r\n\t\tfeatureType: 'water',\r\n\t\telementType: 'all',\r\n\t\tstylers: [{\r\n\t\t\thue: '#1CB2BD'\r\n\t\t}, {\r\n\t\t\tsaturation: 53\r\n\t\t}, {\r\n\t\t\tlightness: -44\r\n\t\t}, {\r\n\t\t\tvisibility: 'on'\r\n\t\t}]\r\n\t}, {\r\n\t\tfeatureType: \"road\",\r\n\t\telementType: \"all\",\r\n\t\tstylers: [{\r\n\t\t\thue: \"#1CB2BD\"\r\n\t\t}, {\r\n\t\t\tsaturation: 40\r\n\t\t}]\r\n\t}, {\r\n\t\tfeatureType: 'landscape',\r\n\t\telementType: 'all',\r\n\t\tstylers: [{\r\n\t\t\thue: '#BBDC00'\r\n\t\t}, {\r\n\t\t\tsaturation: 80\r\n\t\t}, {\r\n\t\t\tlightness: -20\r\n\t\t}, {\r\n\t\t\tvisibility: 'on'\r\n\t\t}]\r\n\t}, {\r\n\t\tfeatureType: 'road.highway',\r\n\t\telementType: 'all',\r\n\t\tstylers: [{\r\n\t\t\tvisibility: 'on'\r\n\t\t}]\r\n\t}]",
      "views":688,
      "createdBy":{
         "name":"Ozgur Coruhlu",
         "url":"http://www.batescreative.com"
      },
      "createdOn":"2013-11-05T16:07:07.43"
   },
   {
      "id":45,
      "name":"Candy Colours ",
      "description":"A bright map with prominent pink on a light background.",
      "url":"http://snazzymaps.com/style/45/candy-colours",
      "json":"[\r\n\t{\r\n\t\t\"featureType\": \"landscape\",\r\n\t\t\"stylers\": [\r\n\t\t\t{\r\n\t\t\t\t\"hue\": \"#FFE100\"\r\n\t\t\t},\r\n\t\t\t{\r\n\t\t\t\t\"saturation\": 34.48275862068968\r\n\t\t\t},\r\n\t\t\t{\r\n\t\t\t\t\"lightness\": -1.490196078431353\r\n\t\t\t},\r\n\t\t\t{\r\n\t\t\t\t\"gamma\": 1\r\n\t\t\t}\r\n\t\t]\r\n\t},\r\n\t{\r\n\t\t\"featureType\": \"road.highway\",\r\n\t\t\"stylers\": [\r\n\t\t\t{\r\n\t\t\t\t\"hue\": \"#FF009A\"\r\n\t\t\t},\r\n\t\t\t{\r\n\t\t\t\t\"saturation\": -2.970297029703005\r\n\t\t\t},\r\n\t\t\t{\r\n\t\t\t\t\"lightness\": -17.815686274509815\r\n\t\t\t},\r\n\t\t\t{\r\n\t\t\t\t\"gamma\": 1\r\n\t\t\t}\r\n\t\t]\r\n\t},\r\n\t{\r\n\t\t\"featureType\": \"road.arterial\",\r\n\t\t\"stylers\": [\r\n\t\t\t{\r\n\t\t\t\t\"hue\": \"#FFE100\"\r\n\t\t\t},\r\n\t\t\t{\r\n\t\t\t\t\"saturation\": 8.600000000000009\r\n\t\t\t},\r\n\t\t\t{\r\n\t\t\t\t\"lightness\": -4.400000000000006\r\n\t\t\t},\r\n\t\t\t{\r\n\t\t\t\t\"gamma\": 1\r\n\t\t\t}\r\n\t\t]\r\n\t},\r\n\t{\r\n\t\t\"featureType\": \"road.local\",\r\n\t\t\"stylers\": [\r\n\t\t\t{\r\n\t\t\t\t\"hue\": \"#00C3FF\"\r\n\t\t\t},\r\n\t\t\t{\r\n\t\t\t\t\"saturation\": 29.31034482758622\r\n\t\t\t},\r\n\t\t\t{\r\n\t\t\t\t\"lightness\": -38.980392156862735\r\n\t\t\t},\r\n\t\t\t{\r\n\t\t\t\t\"gamma\": 1\r\n\t\t\t}\r\n\t\t]\r\n\t},\r\n\t{\r\n\t\t\"featureType\": \"water\",\r\n\t\t\"stylers\": [\r\n\t\t\t{\r\n\t\t\t\t\"hue\": \"#0078FF\"\r\n\t\t\t},\r\n\t\t\t{\r\n\t\t\t\t\"saturation\": 0\r\n\t\t\t},\r\n\t\t\t{\r\n\t\t\t\t\"lightness\": 0\r\n\t\t\t},\r\n\t\t\t{\r\n\t\t\t\t\"gamma\": 1\r\n\t\t\t}\r\n\t\t]\r\n\t},\r\n\t{\r\n\t\t\"featureType\": \"poi\",\r\n\t\t\"stylers\": [\r\n\t\t\t{\r\n\t\t\t\t\"hue\": \"#00FF19\"\r\n\t\t\t},\r\n\t\t\t{\r\n\t\t\t\t\"saturation\": -30.526315789473685\r\n\t\t\t},\r\n\t\t\t{\r\n\t\t\t\t\"lightness\": -22.509803921568633\r\n\t\t\t},\r\n\t\t\t{\r\n\t\t\t\t\"gamma\": 1\r\n\t\t\t}\r\n\t\t]\r\n\t}\r\n]",
      "views":642,
      "createdBy":{
         "name":"Daniela",
         "url":"http://popovadesign.com"
      },
      "createdOn":"2013-12-02T15:35:56.237"
   },
   {
      "id":65,
      "name":"Just places",
      "description":"Do you remember those ultra-tidy historical atlas backgrounds? This map shows only place labels, their circle markers and a couple of borders. Wonderful for thematic overlaying at zoom levels up to 10.",
      "url":"http://snazzymaps.com/style/65/just-places",
      "json":"[\r\n  {\r\n    \"featureType\": \"road\",\r\n    \"elementType\": \"geometry\",\r\n    \"stylers\": [\r\n      { \"visibility\": \"off\" }\r\n    ]\r\n  },{\r\n    \"featureType\": \"poi\",\r\n    \"elementType\": \"geometry\",\r\n    \"stylers\": [\r\n      { \"visibility\": \"off\" }\r\n    ]\r\n  },{\r\n    \"featureType\": \"landscape\",\r\n    \"elementType\": \"geometry\",\r\n    \"stylers\": [\r\n      { \"color\": \"#fffffa\" }\r\n    ]\r\n  },{\r\n    \"featureType\": \"water\",\r\n    \"stylers\": [\r\n      { \"lightness\": 50 }\r\n    ]\r\n  },{\r\n    \"featureType\": \"road\",\r\n    \"elementType\": \"labels\",\r\n    \"stylers\": [\r\n      { \"visibility\": \"off\" }\r\n    ]\r\n  },{\r\n    \"featureType\": \"transit\",\r\n    \"stylers\": [\r\n      { \"visibility\": \"off\" }\r\n    ]\r\n  },{\r\n    \"featureType\": \"administrative\",\r\n    \"elementType\": \"geometry\",\r\n    \"stylers\": [\r\n      { \"lightness\": 40 }\r\n    ]\r\n  }\r\n]",
      "views":599,
      "createdBy":{
         "name":"Tony",
         "url":"http://snazzymaps.com"
      },
      "createdOn":"2014-02-20T03:10:48.637"
   },
   {
      "id":68,
      "name":"Aqua",
      "description":"A cool two tone map that looks great when zoomed in.",
      "url":"http://snazzymaps.com/style/68/aqua",
      "json":"[\r\n  {\r\n    \"featureType\":\"landscape\",\r\n    \"stylers\":[\r\n      {\r\n        \"color\":\"#6c8080\"\r\n      },\r\n      {\r\n        \"visibility\":\"simplified\"\r\n      }\r\n    ]\r\n  },\r\n  {\r\n    \"featureType\":\"administrative\",\r\n    \"elementType\":\"labels.text\",\r\n    \"stylers\":[\r\n      {\r\n        \"visibility\":\"off\"\r\n      }\r\n    ]\r\n  },\r\n  {\r\n    \"featureType\":\"road\",\r\n    \"stylers\":[\r\n      {\r\n        \"visibility\":\"simplified\"\r\n      }\r\n    ]\r\n  },\r\n  {\r\n    \"featureType\":\"poi\",\r\n    \"stylers\":[\r\n      {\r\n        \"visibility\":\"off\"\r\n      }\r\n    ]\r\n  },\r\n  {\r\n    \"featureType\":\"road.highway\",\r\n    \"elementType\":\"labels\",\r\n    \"stylers\":[\r\n      {\r\n        \"visibility\":\"off\"\r\n      }\r\n    ]\r\n  },\r\n  {\r\n    \"featureType\":\"road.highway\",\r\n    \"elementType\":\"labels\",\r\n    \"stylers\":[\r\n      {\r\n        \"visibility\":\"off\"\r\n      }\r\n    ]\r\n  },\r\n  {\r\n    \"featureType\":\"road\",\r\n    \"elementType\":\"labels.icon\",\r\n    \"stylers\":[\r\n      {\r\n        \"visibility\":\"off\"\r\n      }\r\n    ]\r\n  },\r\n  {\r\n    \"featureType\":\"transit\",\r\n    \"elementType\":\"labels\",\r\n    \"stylers\":[\r\n      {\r\n        \"visibility\":\"off\"\r\n      }\r\n    ]\r\n  },\r\n  {\r\n    \"elementType\":\"labels\",\r\n    \"stylers\":[\r\n      {\r\n        \"visibility\":\"off\"\r\n      }\r\n    ]\r\n  },\r\n  {\r\n    \"featureType\":\"road.highway\",\r\n    \"stylers\":[\r\n      {\r\n        \"color\":\"#d98080\"\r\n      },\r\n      {\r\n        \"hue\":\"#eeff00\"\r\n      },\r\n      {\r\n        \"lightness\":100\r\n      },\r\n      {\r\n        \"weight\":1.5\r\n      }\r\n    ]\r\n  }\r\n]",
      "views":578,
      "createdBy":{
         "name":"Anonymous",
         "url":"http://snazzymaps.com"
      },
      "createdOn":"2014-02-20T03:19:01.813"
   },
   {
      "id":59,
      "name":"Light Green",
      "description":"A light map with a green hue simplified by removing all roads, transit, and labels.",
      "url":"http://snazzymaps.com/style/59/light-green",
      "json":"[\r\n      {\"stylers\":[\r\n         { \"hue\":\"#baf4c4\" },\r\n         { \"saturation\":10 }\r\n      ]},\r\n       {\r\n         \"featureType\":\"water\",\r\n          \"stylers\":[{\r\n                \"color\":\"#effefd\"\r\n           }]\r\n         },\r\n                    {\r\n                        \"featureType\":\"all\",\r\n                        \"elementType\":\"labels\",\r\n                        \"stylers\":[{\r\n                            \"visibility\":\"off\"\r\n                        }]\r\n                    },\r\n                    {\r\n                        featureType:\"administrative\",\r\n                        elementType:\"labels\",\r\n                        stylers:[\r\n                            {visibility:\"on\"}\r\n                        ]\r\n                    },\r\n                    {\r\n                        featureType:\"road\",\r\n                        elementType:\"all\",\r\n                        stylers:[\r\n                            {visibility:\"off\"}\r\n                        ]\r\n                    },\r\n                    {\r\n                        featureType:\"transit\",\r\n                        elementType:\"all\",\r\n                        stylers:[\r\n                            {visibility:\"off\"}\r\n                        ]\r\n                    }\r\n       \r\n                ]",
      "views":564,
      "createdBy":{
         "name":"naoyashiga",
         "url":"https://github.com/naoyashiga"
      },
      "createdOn":"2014-01-28T15:15:27.887"
   },
   {
      "id":32,
      "name":"Deep Green",
      "description":"Bold and vibrant! We have used our brand colors to create a map that is in sync with our website theme. ",
      "url":"http://snazzymaps.com/style/32/deep-green",
      "json":" [\r\n{ \"featureType\": \"administrative\", \"elementType\": \"geometry\", \"stylers\": [ { \"visibility\": \"off\" } ] },{ \"featureType\": \"landscape.man_made\", \"stylers\": [ { \"visibility\": \"simplified\" }, { \"color\": \"#ffe24d\" } ] },{ \"featureType\": \"road\", \"stylers\": [ { \"visibility\": \"simplified\" }, { \"color\": \"#158c28\" } ] },{ \"featureType\": \"landscape.natural\", \"stylers\": [ { \"visibility\": \"simplified\" }, { \"color\": \"#37b34a\" } ] },{ \"featureType\": \"water\", \"stylers\": [ { \"color\": \"#ffe24d\" } ] },{ \"featureType\": \"poi\", \"stylers\": [ { \"visibility\": \"simplified\" }, { \"color\": \"#8bc53f\" } ] },{ \"elementType\": \"labels.text.stroke\", \"stylers\": [ { \"color\": \"#808080\" }, { \"gamma\": 9.91 }, { \"visibility\": \"off\" } ] },{ \"elementType\": \"labels.text.fill\", \"stylers\": [ { \"color\": \"#ffffff\" }, { \"lightness\": 100 }, { \"visibility\": \"on\" } ] },{\"elementType\": \"labels.icon\",\"stylers\": [ { \"visibility\": \"off\" }] }]",
      "views":550,
      "createdBy":{
         "name":"Pixel Garage",
         "url":"http://www.pixelgarage.in"
      },
      "createdOn":"2013-11-09T17:57:46.48"
   },
   {
      "id":33,
      "name":"Jane Iredale",
      "description":"A funky map with a lot of color.",
      "url":"http://snazzymaps.com/style/33/jane-iredale",
      "json":"[\r\n\t{\r\n\t\tfeatureType: 'water',\r\n\t\telementType: 'all',\r\n\t\tstylers: [\r\n\t\t\t{ hue: '#87bcba' },\r\n\t\t\t{ saturation: -37 },\r\n\t\t\t{ lightness: -17 },\r\n\t\t\t{ visibility: 'on' }\r\n\t\t]\r\n\t},{\r\n\t\tfeatureType: 'landscape',\r\n\t\telementType: 'all',\r\n\t\tstylers: [\r\n\r\n\t\t]\r\n\t},{\r\n\t\tfeatureType: 'landscape.man_made',\r\n\t\telementType: 'all',\r\n\t\tstylers: [\r\n\t\t\t{ hue: '#4f6b46' },\r\n\t\t\t{ saturation: -23 },\r\n\t\t\t{ lightness: -61 },\r\n\t\t\t{ visibility: 'on' }\r\n\t\t]\r\n\t},{\r\n\t\tfeatureType: 'road',\r\n\t\telementType: 'all',\r\n\t\tstylers: [\r\n\t\t\t{ hue: '#d38bc8' },\r\n\t\t\t{ saturation: -55 },\r\n\t\t\t{ lightness: 13 },\r\n\t\t\t{ visibility: 'on' }\r\n\t\t]\r\n\t},{\r\n\t\tfeatureType: 'road.highway',\r\n\t\telementType: 'all',\r\n\t\tstylers: [\r\n\t\t\t{ hue: '#ffa200' },\r\n\t\t\t{ saturation: 100 },\r\n\t\t\t{ lightness: -22 },\r\n\t\t\t{ visibility: 'on' }\r\n\t\t]\r\n\t},{\r\n\t\tfeatureType: 'road.local',\r\n\t\telementType: 'all',\r\n\t\tstylers: [\r\n\t\t\t{ hue: '#d38bc8' },\r\n\t\t\t{ saturation: -55 },\r\n\t\t\t{ lightness: -31 },\r\n\t\t\t{ visibility: 'on' }\r\n\t\t]\r\n\t},{\r\n\t\tfeatureType: 'transit',\r\n\t\telementType: 'all',\r\n\t\tstylers: [\r\n\t\t\t{ hue: '#f69d94' },\r\n\t\t\t{ saturation: 84 },\r\n\t\t\t{ lightness: 9 },\r\n\t\t\t{ visibility: 'on' }\r\n\t\t]\r\n\t},{\r\n\t\tfeatureType: 'administrative',\r\n\t\telementType: 'all',\r\n\t\tstylers: [\r\n\t\t\t{ hue: '#d38bc8' },\r\n\t\t\t{ saturation: 45 },\r\n\t\t\t{ lightness: 36 },\r\n\t\t\t{ visibility: 'on' }\r\n\t\t]\r\n\t},{\r\n\t\tfeatureType: 'administrative.country',\r\n\t\telementType: 'all',\r\n\t\tstylers: [\r\n\t\t\t{ hue: '#d38bc8' },\r\n\t\t\t{ saturation: 45 },\r\n\t\t\t{ lightness: 36 },\r\n\t\t\t{ visibility: 'on' }\r\n\t\t]\r\n\t},{\r\n\t\tfeatureType: 'administrative.land_parcel',\r\n\t\telementType: 'all',\r\n\t\tstylers: [\r\n\t\t\t{ hue: '#d38bc8' },\r\n\t\t\t{ saturation: 45 },\r\n\t\t\t{ lightness: 36 },\r\n\t\t\t{ visibility: 'on' }\r\n\t\t]\r\n\t},{\r\n\t\tfeatureType: 'poi.government',\r\n\t\telementType: 'all',\r\n\t\tstylers: [\r\n\t\t\t{ hue: '#d38bc8' },\r\n\t\t\t{ saturation: 35 },\r\n\t\t\t{ lightness: -19 },\r\n\t\t\t{ visibility: 'on' }\r\n\t\t]\r\n\t},{\r\n\t\tfeatureType: 'poi.school',\r\n\t\telementType: 'all',\r\n\t\tstylers: [\r\n\t\t\t{ hue: '#d38bc8' },\r\n\t\t\t{ saturation: -6 },\r\n\t\t\t{ lightness: -17 },\r\n\t\t\t{ visibility: 'on' }\r\n\t\t]\r\n\t},{\r\n\t\tfeatureType: 'poi.park',\r\n\t\telementType: 'all',\r\n\t\tstylers: [\r\n\t\t\t{ hue: '#b2ba70' },\r\n\t\t\t{ saturation: -19 },\r\n\t\t\t{ lightness: -25 },\r\n\t\t\t{ visibility: 'on' }\r\n\t\t]\r\n\t}\r\n]",
      "views":492,
      "createdBy":{
         "name":"Keri Segalla",
         "url":"http://www.janeiredale.com"
      },
      "createdOn":"2013-11-09T17:59:56.383"
   },
   {
      "id":70,
      "name":"Unsaturated Browns",
      "description":"A subtle, low saturation map, using a light brown as the base colour with pleasant blues and greens as highlights.",
      "url":"http://snazzymaps.com/style/70/unsaturated-browns",
      "json":"[\r\n{\r\n    \"elementType\": \"geometry\",\r\n    \"stylers\": [\r\n      { \"hue\": \"#ff4400\" },\r\n      { \"saturation\": -68 },\r\n      { \"lightness\": -4 },\r\n      { \"gamma\": 0.72 }\r\n    ]\r\n  },{\r\n    \"featureType\": \"road\",\r\n    \"elementType\": \"labels.icon\"  },{\r\n    \"featureType\": \"landscape.man_made\",\r\n    \"elementType\": \"geometry\",\r\n    \"stylers\": [\r\n      { \"hue\": \"#0077ff\" },\r\n      { \"gamma\": 3.1 }\r\n    ]\r\n  },{\r\n    \"featureType\": \"water\",\r\n    \"stylers\": [\r\n      { \"hue\": \"#00ccff\" },\r\n      { \"gamma\": 0.44 },\r\n      { \"saturation\": -33 }\r\n    ]\r\n  },{\r\n    \"featureType\": \"poi.park\",\r\n    \"stylers\": [\r\n      { \"hue\": \"#44ff00\" },\r\n      { \"saturation\": -23 }\r\n    ]\r\n  },{\r\n    \"featureType\": \"water\",\r\n    \"elementType\": \"labels.text.fill\",\r\n    \"stylers\": [\r\n      { \"hue\": \"#007fff\" },\r\n      { \"gamma\": 0.77 },\r\n      { \"saturation\": 65 },\r\n      { \"lightness\": 99 }\r\n    ]\r\n  },{\r\n    \"featureType\": \"water\",\r\n    \"elementType\": \"labels.text.stroke\",\r\n    \"stylers\": [\r\n      { \"gamma\": 0.11 },\r\n      { \"weight\": 5.6 },\r\n      { \"saturation\": 99 },\r\n      { \"hue\": \"#0091ff\" },\r\n      { \"lightness\": -86 }\r\n    ]\r\n  },{\r\n    \"featureType\": \"transit.line\",\r\n    \"elementType\": \"geometry\",\r\n    \"stylers\": [\r\n      { \"lightness\": -48 },\r\n      { \"hue\": \"#ff5e00\" },\r\n      { \"gamma\": 1.2 },\r\n      { \"saturation\": -23 }\r\n    ]\r\n  },{\r\n    \"featureType\": \"transit\",\r\n    \"elementType\": \"labels.text.stroke\",\r\n    \"stylers\": [\r\n      { \"saturation\": -64 },\r\n      { \"hue\": \"#ff9100\" },\r\n      { \"lightness\": 16 },\r\n      { \"gamma\": 0.47 },\r\n      { \"weight\": 2.7 }\r\n    ]\r\n  }\r\n]",
      "views":486,
      "createdBy":{
         "name":"Simon Goellner",
         "url":"http://simey.me"
      },
      "createdOn":"2014-02-20T03:23:32.237"
   },
   {
      "id":51,
      "name":"Roadtrip At Night",
      "description":"A dark map with bright white roads and labels.",
      "url":"http://snazzymaps.com/style/51/roadtrip-at-night",
      "json":"\r\n   [\r\n    {\r\n        \"stylers\": [\r\n            {\r\n                \"hue\": \"#ff1a00\"\r\n            },\r\n            {\r\n                \"invert_lightness\": true\r\n            },\r\n            {\r\n                \"saturation\": -100\r\n            },\r\n            {\r\n                \"lightness\": 33\r\n            },\r\n            {\r\n                \"gamma\": 0.5\r\n            }\r\n        ]\r\n    },{\r\n        \"featureType\": \"water\",\r\n        \"elementType\": \"geometry\",\r\n        \"stylers\": [\r\n            {\r\n                \"color\": \"#2D333C\"\r\n            }\r\n        ]\r\n    },{\r\n        \"featureType\": \"road\",\r\n        \"elementType\": \"geometry\",\r\n        \"stylers\": [\r\n            {\r\n                \"color\": \"#eeeeee\"\r\n            },\r\n\t    {\r\n\t\t\"visibility\": \"simplified\"\r\n\t    }\r\n        ]\r\n    },{\r\n        \"featureType\": \"road\",\r\n        \"elementType\": \"labels.text.stroke\",\r\n        \"stylers\": [\r\n            {\r\n                \"visibility\": \"off\"\r\n            }\r\n        ]\r\n    },\r\n    {\r\n        \"featureType\": \"administrative\",\r\n        \"elementType\": \"labels.text.stroke\",\r\n        \"stylers\": [\r\n            {\r\n                \"color\": \"#ffffff\"\r\n            },\r\n            {\r\n                \"weight\": 3\r\n            }\r\n        ]\r\n    },\r\n    {\r\n        \"featureType\": \"administrative\",\r\n        \"elementType\": \"labels.text.fill\",\r\n        \"stylers\": [\r\n            {\r\n                \"color\": \"#2D333C\"\r\n            }\r\n        ]\r\n    }\r\n   ]\r\n\r\n",
      "views":485,
      "createdBy":{
         "name":"Veit Stumpf",
         "url":"http://www.physiotherapie-stumpf.de/"
      },
      "createdOn":"2014-01-06T19:35:58.207"
   },
   {
      "id":75,
      "name":"Shade of green",
      "description":"A subtle twist on the default map style with roads and parks highlighted green.",
      "url":"http://snazzymaps.com/style/75/shade-of-green",
      "json":"[{featureType:\"water\",elementType:\"all\",stylers:[{hue:\"#76aee3\"},{saturation:38},{lightness:-11},{visibility:\"on\"}]},{featureType:\"road.highway\",elementType:\"all\",stylers:[{hue:\"#8dc749\"},{saturation:-47},{lightness:-17},{visibility:\"on\"}]},{featureType:\"poi.park\",elementType:\"all\",stylers:[{hue:\"#c6e3a4\"},{saturation:17},{lightness:-2},{visibility:\"on\"}]},{featureType:\"road.arterial\",elementType:\"all\",stylers:[{hue:\"#cccccc\"},{saturation:-100},{lightness:13},{visibility:\"on\"}]},{featureType:\"administrative.land_parcel\",elementType:\"all\",stylers:[{hue:\"#5f5855\"},{saturation:6},{lightness:-31},{visibility:\"on\"}]},{featureType:\"road.local\",elementType:\"all\",stylers:[{hue:\"#ffffff\"},{saturation:-100},{lightness:100},{visibility:\"simplified\"}]},{featureType:\"water\",elementType:\"all\",stylers:[]}]",
      "views":466,
      "createdBy":{
         "name":"Kevin Lofthouse",
         "url":"http://www.lofthou.se"
      },
      "createdOn":"2014-02-28T15:14:02.35"
   },
   {
      "id":49,
      "name":"Subtle Green",
      "description":"A simplified style with a touch of green.",
      "url":"http://snazzymaps.com/style/49/subtle-green",
      "json":"[\r\n  {\r\n    \"stylers\": [\r\n      { \"visibility\": \"on\" },\r\n      { \"saturation\": -100 }\r\n    ]\r\n  },{\r\n    \"featureType\": \"water\",\r\n    \"stylers\": [\r\n      { \"visibility\": \"on\" },\r\n      { \"saturation\": 100 },\r\n      { \"hue\": \"#00ffe6\" }\r\n    ]\r\n  },{\r\n    \"featureType\": \"road\",\r\n    \"elementType\": \"geometry\",\r\n    \"stylers\": [\r\n      { \"saturation\": 100 },\r\n      { \"hue\": \"#00ffcc\" }\r\n    ]\r\n  },{\r\n    \"featureType\": \"poi\",\r\n    \"stylers\": [\r\n      { \"visibility\": \"off\" }\r\n    ]\r\n  },{\r\n    \"featureType\": \"poi.park\",\r\n    \"stylers\": [\r\n      { \"visibility\": \"on\" }\r\n    ]\r\n  }\r\n]",
      "views":399,
      "createdBy":{
         "name":"jl",
         "url":"http://snazzymaps.com"
      },
      "createdOn":"2014-01-06T19:34:41.393"
   },
   {
      "id":57,
      "name":"Military Flat",
      "description":"A military-grey coloured map, only with borders, cities and bodies of water.\r\nInspired to maps used by the blitzortung.org project.",
      "url":"http://snazzymaps.com/style/57/military-flat",
      "json":"[ { \"featureType\": \"landscape\", \"elementType\": \"geometry.fill\", \"stylers\": [ { \"visibility\": \"on\" }, { \"hue\": \"#00ff88\" }, { \"lightness\": 14 }, { \"color\": \"#667348\" }, { \"saturation\": 4 }, { \"gamma\": 1.14 } ] },{ \"elementType\": \"labels.text.stroke\", \"stylers\": [ { \"visibility\": \"simplified\" } ] },{ \"featureType\": \"administrative.country\", \"elementType\": \"geometry.stroke\", \"stylers\": [ { \"color\": \"#313916\" }, { \"weight\": 0.8 } ] },{ \"featureType\": \"road\", \"stylers\": [ { \"visibility\": \"off\" } ] },{ \"featureType\": \"administrative.locality\", \"elementType\": \"labels.icon\", \"stylers\": [ { \"visibility\": \"simplified\" }, { \"color\": \"#334b1f\" } ] },{ \"featureType\": \"administrative.province\", \"stylers\": [ { \"visibility\": \"off\" } ] },{ \"featureType\": \"poi\", \"stylers\": [ { \"visibility\": \"off\" } ] },{ \"featureType\": \"transit\", \"stylers\": [ { \"visibility\": \"off\" } ] },{ \"featureType\": \"water\", \"stylers\": [ { \"visibility\": \"simplified\" } ] } ]\r\n",
      "views":396,
      "createdBy":{
         "name":"Juri",
         "url":"http://snazzymaps.com"
      },
      "createdOn":"2014-01-19T17:13:59.64"
   },
   {
      "id":76,
      "name":"HashtagNineNineNine",
      "description":"#999 style.",
      "url":"http://snazzymaps.com/style/76/hashtagnineninenine",
      "json":"[\r\n\t{\r\n\t\tfeatureType: 'water',\r\n\t\telementType: 'all',\r\n\t\tstylers: [\r\n\t\t\t{ hue: '#bbbbbb' },\r\n\t\t\t{ saturation: -100 },\r\n\t\t\t{ lightness: -4 },\r\n\t\t\t{ visibility: 'on' }\r\n\t\t]\r\n\t},{\r\n\t\tfeatureType: 'landscape',\r\n\t\telementType: 'all',\r\n\t\tstylers: [\r\n\t\t\t{ hue: '#999999' },\r\n\t\t\t{ saturation: -100 },\r\n\t\t\t{ lightness: -33 },\r\n\t\t\t{ visibility: 'on' }\r\n\t\t]\r\n\t},{\r\n\t\tfeatureType: 'road',\r\n\t\telementType: 'all',\r\n\t\tstylers: [\r\n\t\t\t{ hue: '#999999' },\r\n\t\t\t{ saturation: -100 },\r\n\t\t\t{ lightness: -6 },\r\n\t\t\t{ visibility: 'on' }\r\n\t\t]\r\n\t},{\r\n\t\tfeatureType: 'poi',\r\n\t\telementType: 'all',\r\n\t\tstylers: [\r\n\t\t\t{ hue: '#aaaaaa' },\r\n\t\t\t{ saturation: -100 },\r\n\t\t\t{ lightness: -15 },\r\n\t\t\t{ visibility: 'on' }\r\n\t\t]\r\n\t}\r\n]",
      "views":386,
      "createdBy":{
         "name":"kukac7",
         "url":"http://kukac7.hu"
      },
      "createdOn":"2014-02-28T15:14:56.743"
   },
   {
      "id":64,
      "name":"Old Dry Mud",
      "description":"Orange as a way of manifesting tranquility and to remind of the desert past of parts of this world. Water is depicted pale, reflecting a  sky coated with a thin sheet of autumn clouds. ",
      "url":"http://snazzymaps.com/style/64/old-dry-mud",
      "json":"[\r\n\t{\r\n\t\t\"featureType\": \"landscape\",\r\n\t\t\"stylers\": [\r\n\t\t\t{\r\n\t\t\t\t\"hue\": \"#FFAD00\"\r\n\t\t\t},\r\n\t\t\t{\r\n\t\t\t\t\"saturation\": 50.2\r\n\t\t\t},\r\n\t\t\t{\r\n\t\t\t\t\"lightness\": -34.8\r\n\t\t\t},\r\n\t\t\t{\r\n\t\t\t\t\"gamma\": 1\r\n\t\t\t}\r\n\t\t]\r\n\t},\r\n\t{\r\n\t\t\"featureType\": \"road.highway\",\r\n\t\t\"stylers\": [\r\n\t\t\t{\r\n\t\t\t\t\"hue\": \"#FFAD00\"\r\n\t\t\t},\r\n\t\t\t{\r\n\t\t\t\t\"saturation\": -19.8\r\n\t\t\t},\r\n\t\t\t{\r\n\t\t\t\t\"lightness\": -1.8\r\n\t\t\t},\r\n\t\t\t{\r\n\t\t\t\t\"gamma\": 1\r\n\t\t\t}\r\n\t\t]\r\n\t},\r\n\t{\r\n\t\t\"featureType\": \"road.arterial\",\r\n\t\t\"stylers\": [\r\n\t\t\t{\r\n\t\t\t\t\"hue\": \"#FFAD00\"\r\n\t\t\t},\r\n\t\t\t{\r\n\t\t\t\t\"saturation\": 72.4\r\n\t\t\t},\r\n\t\t\t{\r\n\t\t\t\t\"lightness\": -32.6\r\n\t\t\t},\r\n\t\t\t{\r\n\t\t\t\t\"gamma\": 1\r\n\t\t\t}\r\n\t\t]\r\n\t},\r\n\t{\r\n\t\t\"featureType\": \"road.local\",\r\n\t\t\"stylers\": [\r\n\t\t\t{\r\n\t\t\t\t\"hue\": \"#FFAD00\"\r\n\t\t\t},\r\n\t\t\t{\r\n\t\t\t\t\"saturation\": 74.4\r\n\t\t\t},\r\n\t\t\t{\r\n\t\t\t\t\"lightness\": -18\r\n\t\t\t},\r\n\t\t\t{\r\n\t\t\t\t\"gamma\": 1\r\n\t\t\t}\r\n\t\t]\r\n\t},\r\n\t{\r\n\t\t\"featureType\": \"water\",\r\n\t\t\"stylers\": [\r\n\t\t\t{\r\n\t\t\t\t\"hue\": \"#00FFA6\"\r\n\t\t\t},\r\n\t\t\t{\r\n\t\t\t\t\"saturation\": -63.2\r\n\t\t\t},\r\n\t\t\t{\r\n\t\t\t\t\"lightness\": 38\r\n\t\t\t},\r\n\t\t\t{\r\n\t\t\t\t\"gamma\": 1\r\n\t\t\t}\r\n\t\t]\r\n\t},\r\n\t{\r\n\t\t\"featureType\": \"poi\",\r\n\t\t\"stylers\": [\r\n\t\t\t{\r\n\t\t\t\t\"hue\": \"#FFC300\"\r\n\t\t\t},\r\n\t\t\t{\r\n\t\t\t\t\"saturation\": 54.2\r\n\t\t\t},\r\n\t\t\t{\r\n\t\t\t\t\"lightness\": -14.4\r\n\t\t\t},\r\n\t\t\t{\r\n\t\t\t\t\"gamma\": 1\r\n\t\t\t}\r\n\t\t]\r\n\t}\r\n]",
      "views":385,
      "createdBy":{
         "name":"Asafaga",
         "url":"http://asafaga.com"
      },
      "createdOn":"2014-02-07T15:21:06.483"
   },
   {
      "id":56,
      "name":"Esperanto",
      "description":"A bright theme with a wide array of colours for every single element type.",
      "url":"http://snazzymaps.com/style/56/esperanto",
      "json":" [\r\n {\r\n    \"elementType\": \"labels.text.stroke\",\r\n    \"stylers\": [\r\n      { \"color\": \"#ffffff\" }\r\n    ]\r\n  },\r\n  {\r\n    \"elementType\": \"labels.text.fill\",\r\n    \"stylers\": [\r\n      { \"color\": \"#000000\" }\r\n    ]\r\n  },\r\n  {\r\n    \"featureType\": \"water\",\r\n    \"elementType\": \"geometry\",\r\n    \"stylers\": [\r\n      { \"color\": \"#0000ff\" }\r\n    ]\r\n  },\r\n  {\r\n    \"featureType\": \"road.highway\",\r\n    \"elementType\": \"geometry.fill\",\r\n    \"stylers\": [\r\n      { \"color\": \"#ff0000\" }\r\n    ]\r\n  },{\r\n    \"featureType\": \"road.highway\",\r\n    \"elementType\": \"geometry.stroke\",\r\n    \"stylers\": [\r\n      { \"color\": \"#000100\" }\r\n    ]\r\n  },{\r\n    \"featureType\": \"road.highway.controlled_access\",\r\n    \"elementType\": \"geometry.fill\",\r\n    \"stylers\": [\r\n      { \"color\": \"#ffff00\" }\r\n    ]\r\n  },{\r\n    \"featureType\": \"road.highway.controlled_access\",\r\n    \"elementType\": \"geometry.stroke\",\r\n    \"stylers\": [\r\n      { \"color\": \"#ff0000\" }\r\n    ]\r\n  },\r\n  {\r\n    \"featureType\": \"road.arterial\",\r\n    \"elementType\": \"geometry.fill\",\r\n    \"stylers\": [\r\n      { \"color\": \"#ffa91a\" }\r\n    ]\r\n  },\r\n  {\r\n    \"featureType\": \"road.arterial\",\r\n    \"elementType\": \"geometry.stroke\",\r\n    \"stylers\": [\r\n      { \"color\": \"#000000\" }\r\n    ]\r\n  },\r\n  {\r\n    \"featureType\": \"landscape.natural\",\r\n    \"stylers\": [\r\n      { \"saturation\": 36 },\r\n      { \"gamma\": 0.55 }\r\n    ]\r\n  },\r\n  {\r\n    \"featureType\": \"road.local\",\r\n    \"elementType\": \"geometry.stroke\",\r\n    \"stylers\": [\r\n      { \"color\": \"#000000\" }\r\n    ]\r\n  },\r\n  {\r\n    \"featureType\": \"road.local\",\r\n    \"elementType\": \"geometry.fill\",\r\n    \"stylers\": [\r\n      { \"color\": \"#ffffff\" }\r\n    ]\r\n  },\r\n  {\r\n    \"featureType\": \"landscape.man_made\",\r\n    \"elementType\": \"geometry.stroke\",\r\n    \"stylers\": [\r\n      { \"lightness\": -100 },\r\n      { \"weight\": 2.1 }\r\n    ]\r\n  }, \r\n  {\r\n    \"featureType\": \"landscape.man_made\",\r\n    \"elementType\": \"geometry.fill\",\r\n    \"stylers\": [\r\n      { \"invert_lightness\": true },\r\n      { \"hue\": \"#ff0000\" },\r\n      { \"gamma\": 3.02 },\r\n      { \"lightness\": 20 },\r\n      { \"saturation\": 40 }\r\n    ]\r\n  },\r\n  {\r\n    \"featureType\": \"poi.attraction\",\r\n    \"stylers\": [\r\n      { \"saturation\": 100 },\r\n      { \"hue\": \"#ff00ee\" },\r\n      { \"lightness\": -13 }\r\n    ]\r\n  },\r\n  {\r\n    \"featureType\": \"poi.government\",\r\n    \"stylers\": [\r\n      { \"saturation\": 100 },\r\n      { \"hue\": \"#eeff00\" },\r\n      { \"gamma\": 0.67 },\r\n      { \"lightness\": -26 }\r\n    ]\r\n  },\r\n {\r\n    \"featureType\": \"poi.medical\",\r\n    \"elementType\": \"geometry.fill\",\r\n    \"stylers\": [\r\n      { \"hue\": \"#ff0000\" },\r\n      { \"saturation\": 100 },\r\n      { \"lightness\": -37 }\r\n    ]\r\n  },\r\n   {\r\n    \"featureType\": \"poi.medical\",\r\n    \"elementType\": \"labels.text.fill\",\r\n    \"stylers\": [\r\n      { \"color\": \"#ff0000\" }\r\n    ]\r\n  },\r\n  {\r\n    \"featureType\": \"poi.school\",\r\n    \"stylers\": [\r\n      { \"hue\": \"#ff7700\" },\r\n      { \"saturation\": 97 },\r\n      { \"lightness\": -41 }\r\n    ]\r\n  }, \r\n  {\r\n    \"featureType\": \"poi.sports_complex\",\r\n    \"stylers\": [\r\n      { \"saturation\": 100 },\r\n      { \"hue\": \"#00ffb3\" },\r\n      { \"lightness\": -71 }\r\n    ]\r\n  }, \r\n  {\r\n    \"featureType\": \"poi.park\",\r\n    \"stylers\": [\r\n      { \"saturation\": 84 },\r\n      { \"lightness\": -57 },\r\n      { \"hue\": \"#a1ff00\" }\r\n    ]\r\n  },\r\n  {\r\n    \"featureType\": \"transit.station.airport\",\r\n    \"elementType\": \"geometry.fill\",\r\n    \"stylers\": [\r\n      { \"gamma\": 0.11 }\r\n    ]\r\n  },\r\n  {\r\n    \"featureType\": \"transit.station\",\r\n    \"elementType\": \"labels.text.stroke\",\r\n    \"stylers\": [\r\n      { \"color\": \"#ffc35e\" }\r\n    ]\r\n  },\r\n  {\r\n    \"featureType\": \"transit.line\",\r\n    \"elementType\": \"geometry\",\r\n    \"stylers\": [\r\n      { \"lightness\": -100 }\r\n    ]\r\n  },\r\n  {\r\n    \"featureType\": \"administrative\",\r\n    \"stylers\": [\r\n      { \"saturation\": 100 },\r\n      { \"gamma\": 0.35 },\r\n      { \"lightness\": 20 }\r\n    ]\r\n  },\r\n  {\r\n    \"featureType\": \"poi.business\",\r\n    \"elementType\": \"geometry.fill\",\r\n    \"stylers\": [\r\n      { \"saturation\": -100 },\r\n      { \"gamma\": 0.35 }\r\n    ]\r\n  },\r\n  {\r\n    \"featureType\": \"poi.business\",\r\n    \"elementType\": \"labels.text.stroke\",\r\n    \"stylers\": [\r\n      { \"color\": \"#69ffff\" }\r\n    ]\r\n  },\r\n  {\r\n    \"featureType\": \"poi.place_of_worship\",\r\n    \"elementType\": \"labels.text.stroke\",\r\n    \"stylers\": [\r\n      { \"color\": \"#c3ffc3\" }\r\n    ]\r\n  }\r\n]",
      "views":377,
      "createdBy":{
         "name":"mikel",
         "url":"http://snazzymaps.com"
      },
      "createdOn":"2014-01-15T22:21:29.35"
   },
   {
      "id":73,
      "name":"A Dark World",
      "description":"A dark with no label map style.",
      "url":"http://snazzymaps.com/style/73/a-dark-world",
      "json":"[\r\n            {\r\n                \"stylers\": [\r\n                    {\"visibility\": \"simplified\"}\r\n                ]\r\n            }, {\r\n                \"stylers\": [\r\n                    {\"color\": \"#131314\"}\r\n                ]\r\n            }, {\r\n                \"featureType\": \"water\",\r\n                \"stylers\": [\r\n                    {\"color\": \"#131313\"},\r\n                    {\"lightness\": 7}\r\n                ]\r\n            }, {\r\n                \"elementType\": \"labels.text.fill\",\r\n                \"stylers\": [\r\n                    {\"visibility\": \"on\"},\r\n                    {\"lightness\": 25}\r\n                ]\r\n            }\r\n        ]",
      "views":376,
      "createdBy":{
         "name":"Bim",
         "url":"http://snazzymaps.com"
      },
      "createdOn":"2014-02-28T15:10:39.477"
   },
   {
      "id":69,
      "name":"Holiday",
      "description":"A bright and colorful style with great contrast between land, parks, and water.",
      "url":"http://snazzymaps.com/style/69/holiday",
      "json":"[\r\n\t{\r\n\t\t\"featureType\": \"landscape\",\r\n\t\t\"stylers\": [\r\n\t\t\t{\r\n\t\t\t\t\"hue\": \"#FFB000\"\r\n\t\t\t},\r\n\t\t\t{\r\n\t\t\t\t\"saturation\": 71.66666666666669\r\n\t\t\t},\r\n\t\t\t{\r\n\t\t\t\t\"lightness\": -28.400000000000006\r\n\t\t\t},\r\n\t\t\t{\r\n\t\t\t\t\"gamma\": 1\r\n\t\t\t}\r\n\t\t]\r\n\t},\r\n\t{\r\n\t\t\"featureType\": \"road.highway\",\r\n\t\t\"stylers\": [\r\n\t\t\t{\r\n\t\t\t\t\"hue\": \"#E8FF00\"\r\n\t\t\t},\r\n\t\t\t{\r\n\t\t\t\t\"saturation\": -76.6\r\n\t\t\t},\r\n\t\t\t{\r\n\t\t\t\t\"lightness\": 113\r\n\t\t\t},\r\n\t\t\t{\r\n\t\t\t\t\"gamma\": 1\r\n\t\t\t}\r\n\t\t]\r\n\t},\r\n\t{\r\n\t\t\"featureType\": \"road.arterial\",\r\n\t\t\"stylers\": [\r\n\t\t\t{\r\n\t\t\t\t\"hue\": \"#FF8300\"\r\n\t\t\t},\r\n\t\t\t{\r\n\t\t\t\t\"saturation\": -77\r\n\t\t\t},\r\n\t\t\t{\r\n\t\t\t\t\"lightness\": 27.400000000000006\r\n\t\t\t},\r\n\t\t\t{\r\n\t\t\t\t\"gamma\": 1\r\n\t\t\t}\r\n\t\t]\r\n\t},\r\n\t{\r\n\t\t\"featureType\": \"road.local\",\r\n\t\t\"stylers\": [\r\n\t\t\t{\r\n\t\t\t\t\"hue\": \"#FF8C00\"\r\n\t\t\t},\r\n\t\t\t{\r\n\t\t\t\t\"saturation\": -66.6\r\n\t\t\t},\r\n\t\t\t{\r\n\t\t\t\t\"lightness\": 34.400000000000006\r\n\t\t\t},\r\n\t\t\t{\r\n\t\t\t\t\"gamma\": 1\r\n\t\t\t}\r\n\t\t]\r\n\t},\r\n\t{\r\n\t\t\"featureType\": \"water\",\r\n\t\t\"stylers\": [\r\n\t\t\t{\r\n\t\t\t\t\"hue\": \"#00C4FF\"\r\n\t\t\t},\r\n\t\t\t{\r\n\t\t\t\t\"saturation\": 22.799999999999997\r\n\t\t\t},\r\n\t\t\t{\r\n\t\t\t\t\"lightness\": -11.399999999999991\r\n\t\t\t},\r\n\t\t\t{\r\n\t\t\t\t\"gamma\": 1\r\n\t\t\t}\r\n\t\t]\r\n\t},\r\n\t{\r\n\t\t\"featureType\": \"poi\",\r\n\t\t\"stylers\": [\r\n\t\t\t{\r\n\t\t\t\t\"hue\": \"#9FFF00\"\r\n\t\t\t},\r\n\t\t\t{\r\n\t\t\t\t\"saturation\": 0\r\n\t\t\t},\r\n\t\t\t{\r\n\t\t\t\t\"lightness\": -23.200000000000003\r\n\t\t\t},\r\n\t\t\t{\r\n\t\t\t\t\"gamma\": 1\r\n\t\t\t}\r\n\t\t]\r\n\t}\r\n]",
      "views":344,
      "createdBy":{
         "name":"Ferienhaus Godewind",
         "url":"http://ferienhaus-godewind.net"
      },
      "createdOn":"2014-02-20T03:20:27.927"
   },
   {
      "id":63,
      "name":"Caribbean Mountain",
      "description":"Inspired by mountain towns in the Dominican Republic.",
      "url":"http://snazzymaps.com/style/63/caribbean-mountain",
      "json":"[\r\n  {\r\n    \"featureType\": \"poi.medical\",\r\n    \"stylers\": [\r\n      { \"visibility\": \"simplified\" }\r\n    ]\r\n  },{\r\n    \"featureType\": \"poi.business\",\r\n    \"stylers\": [\r\n      { \"visibility\": \"off\" }\r\n    ]\r\n  },{\r\n    \"featureType\": \"poi.place_of_worship\",\r\n    \"stylers\": [\r\n      { \"visibility\": \"off\" }\r\n    ]\r\n  },{\r\n    \"featureType\": \"poi\",\r\n    \"elementType\": \"geometry\",\r\n    \"stylers\": [\r\n      { \"visibility\": \"off\" }\r\n    ]\r\n  },{\r\n    \"featureType\": \"landscape\",\r\n    \"stylers\": [\r\n      { \"color\": \"#cec6b3\" }\r\n    ]\r\n  },{\r\n    \"featureType\": \"road\",\r\n    \"stylers\": [\r\n      { \"color\": \"#f2eee8\" }\r\n    ]\r\n  },{\r\n    \"featureType\": \"water\",\r\n    \"stylers\": [\r\n      { \"color\": \"#01186a\" }\r\n    ]\r\n  },{\r\n    \"featureType\": \"road\",\r\n    \"elementType\": \"labels.text.fill\",\r\n    \"stylers\": [\r\n      { \"color\": \"#cec6b3\" }\r\n    ]\r\n  },{\r\n    \"featureType\": \"landscape.man_made\",\r\n    \"stylers\": [\r\n      { \"visibility\": \"off\" }\r\n    ]\r\n  },{\r\n    \"featureType\": \"poi.government\",\r\n    \"stylers\": [\r\n      { \"visibility\": \"off\" }\r\n    ]\r\n  }\r\n]",
      "views":282,
      "createdBy":{
         "name":"Josiah Sprague",
         "url":"http://josiahsprague.com"
      },
      "createdOn":"2014-02-07T15:19:08.227"
   },
   {
      "id":72,
      "name":"Transport for London",
      "description":null,
      "url":"http://snazzymaps.com/style/72/transport-for-london",
      "json":"[ { \"elementType\": \"labels.text\", \"stylers\": [ { \"visibility\": \"off\" } ] },{ \"elementType\": \"labels.icon\", \"stylers\": [ { \"visibility\": \"off\" } ] },{ \"elementType\": \"geometry.stroke\", \"stylers\": [ { \"visibility\": \"off\" } ] },{ \"featureType\": \"water\", \"elementType\": \"geometry.fill\", \"stylers\": [ { \"color\": \"#0099cc\" } ] },{ \"featureType\": \"road\", \"elementType\": \"geometry.fill\", \"stylers\": [ { \"color\": \"#00314e\" } ] },{ \"featureType\": \"transit.line\", \"elementType\": \"geometry.fill\", \"stylers\": [ { \"visibility\": \"on\" }, { \"color\": \"#f0f0f0\" } ] },{ \"featureType\": \"landscape.man_made\", \"stylers\": [ { \"color\": \"#adbac9\" } ] },{ \"featureType\": \"landscape.natural\", \"stylers\": [ { \"color\": \"#adb866\" } ] },{ \"featureType\": \"poi\", \"stylers\": [ { \"color\": \"#f7c742\" } ] },{ \"featureType\": \"poi.park\", \"stylers\": [ { \"color\": \"#adb866\" } ] },{ \"featureType\": \"transit.station\", \"elementType\": \"geometry.fill\", \"stylers\": [ { \"color\": \"#ff8dd3\" } ] },{ \"featureType\": \"transit.station\", \"stylers\": [ { \"color\": \"#ff8dd3\" } ] },{ \"featureType\": \"transit.line\", \"elementType\": \"geometry.fill\", \"stylers\": [ { \"visibility\": \"on\" }, { \"color\": \"#808080\" } ] },{ } ]",
      "views":276,
      "createdBy":{
         "name":"Anonymous",
         "url":"http://snazzymaps.com"
      },
      "createdOn":"2014-02-28T15:09:39.617"
   },
   {
      "id":62,
      "name":"Night vision",
      "description":"A style reminiscent of awesome night vision goggles.",
      "url":"http://snazzymaps.com/style/62/night-vision",
      "json":"[\r\n\t{\r\n\t\tfeatureType: 'water',\r\n\t\telementType: 'all',\r\n\t\tstylers: [\r\n\t\t\t{ hue: '#001204' },\r\n\t\t\t{ saturation: 100 },\r\n\t\t\t{ lightness: -95 },\r\n\t\t\t{ visibility: 'on' }\r\n\t\t]\r\n\t},{\r\n\t\tfeatureType: 'landscape.man_made',\r\n\t\telementType: 'all',\r\n\t\tstylers: [\r\n\t\t\t{ hue: '#007F1E' },\r\n\t\t\t{ saturation: 100 },\r\n\t\t\t{ lightness: -72 },\r\n\t\t\t{ visibility: 'on' }\r\n\t\t]\r\n\t},{\r\n\t\tfeatureType: 'landscape.natural',\r\n\t\telementType: 'all',\r\n\t\tstylers: [\r\n\t\t\t{ hue: '#00C72E' },\r\n\t\t\t{ saturation: 100 },\r\n\t\t\t{ lightness: -59 },\r\n\t\t\t{ visibility: 'on' }\r\n\t\t]\r\n\t},{\r\n\t\tfeatureType: 'road',\r\n\t\telementType: 'all',\r\n\t\tstylers: [\r\n\t\t\t{ hue: '#002C0A' },\r\n\t\t\t{ saturation: 100 },\r\n\t\t\t{ lightness: -87 },\r\n\t\t\t{ visibility: 'on' }\r\n\t\t]\r\n\t},{\r\n\t\tfeatureType: 'poi',\r\n\t\telementType: 'all',\r\n\t\tstylers: [\r\n\t\t\t{ hue: '#00A927' },\r\n\t\t\t{ saturation: 100 },\r\n\t\t\t{ lightness: -58 },\r\n\t\t\t{ visibility: 'on' }\r\n\t\t]\r\n\t}\r\n]",
      "views":268,
      "createdBy":{
         "name":"Raphael Franco",
         "url":"http://snazzymaps.com"
      },
      "createdOn":"2014-02-07T15:18:05.237"
   },
   {
      "id":66,
      "name":"Blueprint (No Labels)",
      "description":"A simplified variation on the original Blueprint style. It's the perfect map for building your own world.",
      "url":"http://snazzymaps.com/style/66/blueprint-no-labels",
      "json":"[\r\n      {\r\n        \"stylers\": [\r\n          { \"visibility\": \"simplified\" },\r\n          { \"saturation\": -100 }\r\n        ]\r\n      },\r\n\t  \r\n\t  \r\n    {\r\n        \"featureType\": \"water\",\r\n        \"elementType\": \"geometry\",\r\n        \"stylers\": [\r\n            {\r\n                \"color\": \"#000045\"\r\n            },\r\n            {\r\n                \"lightness\": 17\r\n            }\r\n        ]\r\n    },\r\n    {\r\n        \"featureType\": \"landscape\",\r\n        \"elementType\": \"geometry\",\r\n        \"stylers\": [\r\n            { \"color\": \"#000045\"\r\n            },\r\n            {\r\n                \"lightness\": 20\r\n            }\r\n        ]\r\n    },\r\n    {\r\n        \"featureType\": \"road.highway\",\r\n        \"elementType\": \"geometry.fill\",\r\n        \"stylers\": [\r\n            { \"color\": \"#000045\"\r\n            },\r\n            {\r\n                \"lightness\": 17\r\n            }\r\n        ]\r\n    },\r\n\t\r\n\t\r\n\r\n\t\r\n\t\r\n    {\r\n        \"featureType\": \"road.highway\",\r\n        \"elementType\": \"geometry.stroke\",\r\n        \"stylers\": [\r\n  \r\n            {\r\n                \"visibility\": \"off\"\r\n            }\r\n        ]\r\n    },\r\n\t\r\n\t\r\n\t {\r\n        \"featureType\": \"road.highway.controlled_access\",\r\n        \"elementType\": \"geometry.stroke\",\r\n        \"stylers\": [\r\n            { \"color\": \"#000045\"\r\n            },\r\n            {\r\n                \"lightness\": 20\r\n            }\r\n        ]\r\n    },\r\n\t\r\n\t\r\n\t\r\n    {\r\n        \"featureType\": \"road.arterial\",\r\n        \"elementType\": \"geometry\",\r\n        \"stylers\": [\r\n            { \"color\": \"#000045\"\r\n            },\r\n            {\r\n                \"lightness\": 25\r\n            }\r\n        ]\r\n    },\r\n    {\r\n        \"featureType\": \"road.local\",\r\n        \"elementType\": \"geometry\",\r\n        \"stylers\": [\r\n            { \"color\": \"#000045\"\r\n            },\r\n            {\r\n                \"lightness\": 25\r\n            }\r\n        ]\r\n    },\r\n    {\r\n        \"featureType\": \"poi\",\r\n        \"elementType\": \"geometry\",\r\n        \"stylers\": [\r\n            { \"color\": \"#000045\"\r\n            },\r\n            {\r\n                \"lightness\": 21\r\n            }\r\n        ]\r\n    },\r\n    {\r\n        \"elementType\": \"labels.text.stroke\",\r\n        \"stylers\": [\r\n            {\r\n                \"visibility\": \"off\"\r\n            }\r\n        ]\r\n    },\r\n    {\r\n        \"elementType\": \"labels.text.fill\",\r\n        \"stylers\": [\r\n            {                \"saturation\": 100            },\r\n            {                \"color\": \"#7b94be\"            },\r\n            {                \"lightness\": 50            }\r\n        ]\r\n    },\r\n\r\n    {\r\n        \"elementType\": \"labels.icon\",\r\n        \"stylers\": [\r\n            {\r\n                \"visibility\": \"off\"\r\n            }\r\n        ]\r\n    },\r\n    {\r\n        \"featureType\": \"transit\",\r\n        \"elementType\": \"geometry\",\r\n        \"stylers\": [\r\n            { \"color\": \"#000045\"\r\n            },\r\n            {\r\n                \"lightness\": 19\r\n            }\r\n        ]\r\n    },\r\n    {\r\n        \"featureType\": \"administrative\",\r\n        \"elementType\": \"geometry.fill\",\r\n        \"stylers\": [\r\n            { \"color\": \"#000045\"\r\n            },\r\n            {\r\n                \"lightness\": 20\r\n            }\r\n        ]\r\n    },\r\n    {\r\n        \"featureType\": \"administrative\",\r\n        \"elementType\": \"geometry.stroke\",\r\n        \"stylers\": [\r\n            { \"color\": \"#000045\"\r\n            },\r\n            {\r\n                \"lightness\": 17\r\n            },\r\n            {\r\n                \"weight\": 1.2\r\n            }\r\n        ]\r\n    }\r\n]\t\t\t\r\n\t",
      "views":254,
      "createdBy":{
         "name":"Adam Ritchey",
         "url":"http://www.interramedia.com"
      },
      "createdOn":"2014-02-20T03:12:20.75"
   },
   {
      "id":67,
      "name":"Blueprint",
      "description":"If you were going to build your own world, this is the map you would use.",
      "url":"http://snazzymaps.com/style/67/blueprint",
      "json":"[\r\n      \r\n\t  \r\n\t  \r\n    {\r\n        \"featureType\": \"water\",\r\n        \"elementType\": \"geometry\",\r\n        \"stylers\": [\r\n            {\r\n                \"color\": \"#000045\"\r\n            },\r\n            {\r\n                \"lightness\": 17\r\n            }\r\n        ]\r\n    },\r\n    {\r\n        \"featureType\": \"landscape\",\r\n        \"elementType\": \"geometry\",\r\n        \"stylers\": [\r\n            { \"color\": \"#000045\"\r\n            },\r\n            {\r\n                \"lightness\": 20\r\n            }\r\n        ]\r\n    },\r\n    {\r\n        \"featureType\": \"road.highway\",\r\n        \"elementType\": \"geometry.fill\",\r\n        \"stylers\": [\r\n            { \"color\": \"#000045\"\r\n            },\r\n            {\r\n                \"lightness\": 17\r\n            }\r\n        ]\r\n    },\r\n\t\r\n\t\r\n\r\n\t\r\n\t\r\n    {\r\n        \"featureType\": \"road\",\r\n        \"elementType\": \"geometry.stroke\",\r\n        \"stylers\": [\r\n\r\n            {\r\n                \"visibility\": \"off\"\r\n            }\r\n        ]\r\n    },\r\n\t\r\n\t\r\n\t {\r\n        \"featureType\": \"road.highway.controlled_access\",\r\n        \"elementType\": \"geometry.stroke\",\r\n        \"stylers\": [\r\n            { \"color\": \"#000045\"\r\n            },\r\n            {\r\n                \"lightness\": 20\r\n            }\r\n        ]\r\n    },\r\n\t\r\n\t\r\n\t\r\n    {\r\n        \"featureType\": \"road.arterial\",\r\n        \"elementType\": \"geometry\",\r\n        \"stylers\": [\r\n            { \"color\": \"#000045\"\r\n            },\r\n            {\r\n                \"lightness\": 25\r\n            }\r\n        ]\r\n    },\r\n    {\r\n        \"featureType\": \"road.local\",\r\n        \"elementType\": \"geometry\",\r\n        \"stylers\": [\r\n            { \"color\": \"#000045\"\r\n            },\r\n            {\r\n                \"lightness\": 25\r\n            }\r\n        ]\r\n    },\r\n    {\r\n        \"featureType\": \"poi\",\r\n        \"elementType\": \"geometry\",\r\n        \"stylers\": [\r\n            { \"color\": \"#000045\"\r\n            },\r\n            {\r\n                \"lightness\": 21\r\n            }\r\n        ]\r\n    },\r\n    {\r\n        \"elementType\": \"labels.text.stroke\",\r\n        \"stylers\": [\r\n            {\r\n                \"visibility\": \"off\"\r\n            }\r\n        ]\r\n    },\r\n    {\r\n        \"elementType\": \"labels.text.fill\",\r\n        \"stylers\": [\r\n            {                \"saturation\": 0            },\r\n            {                \"color\": \"#4d88ea\"            },\r\n            {                \"lightness\": 0            }\r\n        ]\r\n    },\r\n\r\n    {\r\n        \"elementType\": \"labels.icon\",\r\n        \"stylers\": [\r\n            {\r\n                \"visibility\": \"off\"\r\n            }\r\n        ]\r\n    },\r\n    {\r\n        \"featureType\": \"transit\",\r\n        \"elementType\": \"geometry\",\r\n        \"stylers\": [\r\n            { \"color\": \"#000045\"\r\n            },\r\n            {\r\n                \"lightness\": 19\r\n            }\r\n        ]\r\n    },\r\n    {\r\n        \"featureType\": \"administrative\",\r\n        \"elementType\": \"geometry.fill\",\r\n        \"stylers\": [\r\n            { \"color\": \"#000045\"\r\n            },\r\n            {\r\n                \"lightness\": 20\r\n            }\r\n        ]\r\n    },\r\n    {\r\n        \"featureType\": \"administrative\",\r\n        \"elementType\": \"geometry.stroke\",\r\n        \"stylers\": [\r\n            { \"color\": \"#000045\"\r\n            },\r\n            {\r\n                \"lightness\": 17\r\n            },\r\n            {\r\n                \"weight\": 1.2\r\n            }\r\n        ]\r\n    }\r\n]\t\t",
      "views":241,
      "createdBy":{
         "name":"Adam Ritchey",
         "url":"http://www.interramedia.com"
      },
      "createdOn":"2014-02-20T03:12:38.097"
   },
   {
      "id":71,
      "name":"Jazzygreen",
      "description":"Bright green and black style.",
      "url":"http://snazzymaps.com/style/71/jazzygreen",
      "json":"[\r\n\t{\r\n\t\t\"featureType\": \"landscape\",\r\n\t\t\"stylers\": [\r\n\t\t\t{\r\n\t\t\t\t\"hue\": \"#000000\"\r\n\t\t\t},\r\n\t\t\t{\r\n\t\t\t\t\"saturation\": -100\r\n\t\t\t},\r\n\t\t\t{\r\n\t\t\t\t\"lightness\": 44\r\n\t\t\t},\r\n\t\t\t{\r\n\t\t\t\t\"gamma\": 1\r\n\t\t\t}\r\n\t\t]\r\n\t},\r\n\t{\r\n\t\t\"featureType\": \"road.highway\",\r\n\t\t\"stylers\": [\r\n\t\t\t{\r\n\t\t\t\t\"hue\": \"#00F93f\"\r\n\t\t\t},\r\n\t\t\t{\r\n\t\t\t\t\"saturation\": 100\r\n\t\t\t},\r\n\t\t\t{\r\n\t\t\t\t\"lightness\": -40.95294117647059\r\n\t\t\t},\r\n\t\t\t{\r\n\t\t\t\t\"gamma\": 1\r\n\t\t\t}\r\n\t\t]\r\n\t},\r\n\t{\r\n\t\t\"featureType\": \"road.arterial\",\r\n\t\t\"stylers\": [\r\n\t\t\t{\r\n\t\t\t\t\"hue\": \"#00F93f\"\r\n\t\t\t},\r\n\t\t\t{\r\n\t\t\t\t\"saturation\": 100\r\n\t\t\t},\r\n\t\t\t{\r\n\t\t\t\t\"lightness\": -51.15294117647059\r\n\t\t\t},\r\n\t\t\t{\r\n\t\t\t\t\"gamma\": 1\r\n\t\t\t}\r\n\t\t]\r\n\t},\r\n\t{\r\n\t\t\"featureType\": \"road.local\",\r\n\t\t\"stylers\": [\r\n\t\t\t{\r\n\t\t\t\t\"hue\": \"#00F93f\"\r\n\t\t\t},\r\n\t\t\t{\r\n\t\t\t\t\"saturation\": 100\r\n\t\t\t},\r\n\t\t\t{\r\n\t\t\t\t\"lightness\": -50.35294117647059\r\n\t\t\t},\r\n\t\t\t{\r\n\t\t\t\t\"gamma\": 1\r\n\t\t\t}\r\n\t\t]\r\n\t},\r\n\t{\r\n\t\t\"featureType\": \"water\",\r\n\t\t\"stylers\": [\r\n\t\t\t{\r\n\t\t\t\t\"hue\": \"#00F93f\"\r\n\t\t\t},\r\n\t\t\t{\r\n\t\t\t\t\"saturation\": 100\r\n\t\t\t},\r\n\t\t\t{\r\n\t\t\t\t\"lightness\": -50.35294117647059\r\n\t\t\t},\r\n\t\t\t{\r\n\t\t\t\t\"gamma\": 1\r\n\t\t\t}\r\n\t\t]\r\n\t},\r\n\t{\r\n\t\t\"featureType\": \"poi\",\r\n\t\t\"stylers\": [\r\n\t\t\t{\r\n\t\t\t\t\"hue\": \"#00F93f\"\r\n\t\t\t},\r\n\t\t\t{\r\n\t\t\t\t\"saturation\": 100\r\n\t\t\t},\r\n\t\t\t{\r\n\t\t\t\t\"lightness\": -50.35294117647059\r\n\t\t\t},\r\n\t\t\t{\r\n\t\t\t\t\"gamma\": 1\r\n\t\t\t}\r\n\t\t]\r\n\t}\r\n]",
      "views":138,
      "createdBy":{
         "name":"jazz",
         "url":"http://snazzymaps.com"
      },
      "createdOn":"2014-02-28T15:09:12.847"
   },
   {
      "id":80,
      "name":"Cool Grey",
      "description":"A simplified bright map. ",
      "url":"http://snazzymaps.com/style/80/cool-grey",
      "json":"[ { \"featureType\": \"landscape\", \"elementType\": \"labels\", \"stylers\": [ { \"visibility\": \"off\" } ] },{ \"featureType\": \"transit\", \"elementType\": \"labels\", \"stylers\": [ { \"visibility\": \"off\" } ] },{ \"featureType\": \"poi\", \"elementType\": \"labels\", \"stylers\": [ { \"visibility\": \"off\" } ] },{ \"featureType\": \"water\", \"elementType\": \"labels\", \"stylers\": [ { \"visibility\": \"off\" } ] },{ \"featureType\": \"road\", \"elementType\": \"labels.icon\", \"stylers\": [ { \"visibility\": \"off\" } ] },{ \"stylers\": [ { \"hue\": \"#00aaff\" }, { \"saturation\": -100 }, { \"gamma\": 2.15 }, { \"lightness\": 12 } ] },{ \"featureType\": \"road\", \"elementType\": \"labels.text.fill\", \"stylers\": [ { \"visibility\": \"on\" }, { \"lightness\": 24 } ] },{ \"featureType\": \"road\", \"elementType\": \"geometry\", \"stylers\": [ { \"lightness\": 57 } ] } ]",
      "views":75,
      "createdBy":{
         "name":"Nico",
         "url":"http://Fittter.me"
      },
      "createdOn":"2014-04-16T02:56:47.393"
   },
   {
      "id":83,
      "name":"Muted Blue",
      "description":"An unobtrusive blue design for minimal user-experiences. Design for the Rock RMS project.",
      "url":"http://snazzymaps.com/style/83/muted-blue",
      "json":"[\r\n\t{\"featureType\": \"all\",\r\n\t\t\"stylers\":[\r\n\t\t\t{\"saturation\": 0},\r\n\t\t\t{\"hue\": \"#e7ecf0\"}\r\n\t\t]\r\n\t},\r\n\t{\"featureType\": \"road\",\r\n\t\t\"stylers\":[\r\n\t\t\t{\"saturation\": -70}\r\n\t\t]\r\n\t},\r\n\t{\"featureType\": \"transit\",\r\n\t\t\"stylers\":[\r\n\t\t\t{\"visibility\": \"off\"}\r\n\t\t]\r\n\t},\r\n\t{\"featureType\": \"poi\",\r\n\t\t\"stylers\":[\r\n\t\t\t{\"visibility\": \"off\"}\r\n\t\t]\r\n\t},\r\n\t{\"featureType\": \"water\",\r\n\t\t\"stylers\":[\r\n\t\t\t{\"visibility\": \"simplified\"},\r\n\t\t\t{\"saturation\": -60}\r\n\t\t]\r\n\t}\r\n]",
      "views":39,
      "createdBy":{
         "name":"Jon Edmiston",
         "url":"http://www.rockrms.com"
      },
      "createdOn":"2014-04-16T02:58:37.86"
   },
   {
      "id":82,
      "name":"Grass is greener. Water is bluer.",
      "description":"Bright green parks and bright blue water",
      "url":"http://snazzymaps.com/style/82/grass-is-greener-water-is-bluer",
      "json":"[ { \"stylers\": [ { \"saturation\": -100 } ] },{ \"featureType\": \"water\", \"elementType\": \"geometry.fill\", \"stylers\": [ { \"color\": \"#0099dd\" } ] },{ \"elementType\": \"labels\", \"stylers\": [ { \"visibility\": \"off\" } ] },{ \"featureType\": \"poi.park\", \"elementType\": \"geometry.fill\", \"stylers\": [ { \"color\": \"#aadd55\" } ] },{ \"featureType\": \"road.highway\", \"elementType\": \"labels\", \"stylers\": [ { \"visibility\": \"on\" } ] },{ \"featureType\": \"road.arterial\", \"elementType\": \"labels.text\", \"stylers\": [ { \"visibility\": \"on\" } ] },{ \"featureType\": \"road.local\", \"elementType\": \"labels.text\", \"stylers\": [ { \"visibility\": \"on\" } ] },{ } ]",
      "views":34,
      "createdBy":{
         "name":"vm",
         "url":"http://snazzymaps.com"
      },
      "createdOn":"2014-04-16T02:58:17.053"
   },
   {
      "id":79,
      "name":"Black and White",
      "description":"Simple blank and white style without added information, just street names.",
      "url":"http://snazzymaps.com/style/79/black-and-white",
      "json":"[ { \"featureType\": \"road\", \"elementType\": \"labels\", \"stylers\": [ { \"visibility\": \"on\" } ] },{ \"featureType\": \"poi\", \"stylers\": [ { \"visibility\": \"off\" } ] },{ \"featureType\": \"administrative\", \"stylers\": [ { \"visibility\": \"off\" } ] },{ \"featureType\": \"road\", \"elementType\": \"geometry.fill\", \"stylers\": [ { \"color\": \"#000000\" }, { \"weight\": 1 } ] },{ \"featureType\": \"road\", \"elementType\": \"geometry.stroke\", \"stylers\": [ { \"color\": \"#000000\" }, { \"weight\": 0.8 } ] },{ \"featureType\": \"landscape\", \"stylers\": [ { \"color\": \"#ffffff\" } ] },{ \"featureType\": \"water\", \"stylers\": [ { \"visibility\": \"off\" } ] },{ \"featureType\": \"transit\", \"stylers\": [ { \"visibility\": \"off\" } ] },{ \"elementType\": \"labels\", \"stylers\": [ { \"visibility\": \"off\" } ] },{ \"elementType\": \"labels.text\", \"stylers\": [ { \"visibility\": \"on\" } ] },{ \"elementType\": \"labels.text.stroke\", \"stylers\": [ { \"color\": \"#ffffff\" } ] },{ \"elementType\": \"labels.text.fill\", \"stylers\": [ { \"color\": \"#000000\" } ] },{ \"elementType\": \"labels.icon\", \"stylers\": [ { \"visibility\": \"on\" } ] } ]",
      "views":21,
      "createdBy":{
         "name":null,
         "url":"http://snazzymaps.com"
      },
      "createdOn":"2014-04-16T02:56:22.413"
   },
   {
      "id":81,
      "name":"Ilustração",
      "description":"Estilo baseado nas cores de ilustrações, como panfletos. O estilo também foi utilizado no site Tô No Bloco, que tem como finalidade ser um \"panfleto virtual\" dos blocos de carnaval.\r\n\r\nStyle based on the colors of graphics as flyers. The style was also used on the site Tô In Block, which aims to be a \"virtual flyers\" of carnival blocks.",
      "url":"http://snazzymaps.com/style/81/ilustra%C3%A7%C3%A3o",
      "json":"[\r\n\t{\r\n\t\tfeatureType: 'water',\r\n\t\telementType: 'geometry',\r\n\t\tstylers: [\r\n\t\t\t{ hue: '#71ABC3' },\r\n\t\t\t{ saturation: -10 },\r\n\t\t\t{ lightness: -21 },\r\n\t\t\t{ visibility: 'simplified' }\r\n\t\t]\r\n\t},{\r\n\t\tfeatureType: 'landscape.natural',\r\n\t\telementType: 'geometry',\r\n\t\tstylers: [\r\n\t\t\t{ hue: '#7DC45C' },\r\n\t\t\t{ saturation: 37 },\r\n\t\t\t{ lightness: -41 },\r\n\t\t\t{ visibility: 'simplified' }\r\n\t\t]\r\n\t},{\r\n\t\tfeatureType: 'landscape.man_made',\r\n\t\telementType: 'geometry',\r\n\t\tstylers: [\r\n\t\t\t{ hue: '#C3E0B0' },\r\n\t\t\t{ saturation: 23 },\r\n\t\t\t{ lightness: -12 },\r\n\t\t\t{ visibility: 'simplified' }\r\n\t\t]\r\n\t},{\r\n\t\tfeatureType: 'poi',\r\n\t\telementType: 'all',\r\n\t\tstylers: [\r\n\t\t\t{ hue: '#A19FA0' },\r\n\t\t\t{ saturation: -98 },\r\n\t\t\t{ lightness: -20 },\r\n\t\t\t{ visibility: 'off' }\r\n\t\t]\r\n\t},{\r\n\t\tfeatureType: 'road',\r\n\t\telementType: 'geometry',\r\n\t\tstylers: [\r\n\t\t\t{ hue: '#FFFFFF' },\r\n\t\t\t{ saturation: -100 },\r\n\t\t\t{ lightness: 100 },\r\n\t\t\t{ visibility: 'simplified' }\r\n\t\t]\r\n\t}\r\n]",
      "views":19,
      "createdBy":{
         "name":"Marcelo Oliveira Murta",
         "url":"http://www.tonobloco.com.br"
      },
      "createdOn":"2014-04-16T02:57:57.38"
   },
   {
      "id":78,
      "name":"Pink & Blue",
      "description":null,
      "url":"http://snazzymaps.com/style/78/pink-and-blue",
      "json":"[ { \"featureType\": \"landscape\", \"stylers\": [ { \"visibility\": \"simplified\" }, { \"color\": \"#9debff\" }, { \"weight\": 0.1 } ] },{ \"featureType\": \"water\", \"stylers\": [ { \"visibility\": \"simplified\" }, { \"color\": \"#ebebeb\" } ] },{ \"featureType\": \"road.arterial\", \"elementType\": \"geometry\", \"stylers\": [ { \"visibility\": \"on\" }, { \"color\": \"#51dbff\" } ] },{ \"featureType\": \"poi.park\", \"elementType\": \"geometry.fill\", \"stylers\": [ { \"visibility\": \"on\" }, { \"color\": \"#51dbff\" } ] },{ \"featureType\": \"poi\" },{ \"featureType\": \"transit.line\", \"stylers\": [ { \"color\": \"#ff4e80\" }, { \"visibility\": \"off\" } ] },{ \"featureType\": \"road\", \"elementType\": \"geometry.stroke\", \"stylers\": [ { \"visibility\": \"on\" }, { \"weight\": 1.5 }, { \"color\": \"#51dbff\" } ] },{ \"featureType\": \"road.arterial\", \"elementType\": \"geometry\", \"stylers\": [ { \"visibility\": \"simplified\" }, { \"color\": \"#51dbNaN\" } ] },{ \"featureType\": \"road.highway\", \"elementType\": \"geometry\", \"stylers\": [ { \"visibility\": \"simplified\" }, { \"color\": \"#51dbff\" } ] },{ \"featureType\": \"poi.business\", \"stylers\": [ { \"color\": \"#9debff\" }, { \"visibility\": \"off\" } ] },{ },{ \"featureType\": \"poi.government\", \"stylers\": [ { \"visibility\": \"off\" } ] },{ \"featureType\": \"poi.school\", \"stylers\": [ { \"visibility\": \"off\" } ] },{ \"featureType\": \"administrative\", \"stylers\": [ { \"visibility\": \"on\" } ] },{ \"featureType\": \"poi.medical\", \"stylers\": [ { \"visibility\": \"off\" } ] },{ \"featureType\": \"poi.attraction\", \"elementType\": \"geometry\", \"stylers\": [ { \"visibility\": \"on\" }, { \"color\": \"#51dbff\" } ] },{ \"featureType\": \"poi.place_of_worship\", \"stylers\": [ { \"visibility\": \"off\" } ] },{ \"featureType\": \"poi.sports_complex\", \"stylers\": [ { \"visibility\": \"off\" } ] },{ },{ \"featureType\": \"road.arterial\", \"elementType\": \"labels.text.stroke\", \"stylers\": [ { \"color\": \"#000000\" }, { \"visibility\": \"off\" } ] },{ \"featureType\": \"road.highway\", \"elementType\": \"labels.text\", \"stylers\": [ { \"visibility\": \"off\" } ] },{ \"featureType\": \"road.highway.controlled_access\", \"stylers\": [ { \"visibility\": \"off\" } ] },{ \"featureType\": \"road\" } ]",
      "views":16,
      "createdBy":{
         "name":"cebrat",
         "url":"http://snazzymaps.com"
      },
      "createdOn":"2014-04-16T02:53:43.42"
   }
]